<?php
//Options

function gripvine_theme_info_menu() {

	add_theme_page( 
		esc_html__('Welcome To Gripvine WordPress Theme', 'gripvine'), 
		esc_html__('Gripvine Theme Info', 'gripvine'), 
		'manage_options', 
		'gripvine_theme_info_options', 
		'gripvine_theme_info_display' 
	);

}


add_action( 'admin_menu', 'gripvine_theme_info_menu' );



function gripvine_theme_info_display() {
	if ( !current_user_can( 'manage_options' ) )  {
		wp_die( __( 'You do not have sufficient permissions to access this page.', 'gripvine' ) );
	}
	
	?>
	<div class="wrap gripvine-adm">
		<h1 class="header-welcome"><?php esc_html_e('Welcome to Gripvine - 1.6.4', 'gripvine'); ?></h1>
		<div class="gripvine-adm-dsply-fl gripvine-adm-fl-wrap gripvine-adm-jc-sp-btw">

			<div class="gripvine-adm-wid-49 theme-para theme-doc gripvine-adm-mobwid-100">
				<h4><?php esc_html_e('Theme Documentation','gripvine'); ?></h4>
				<p><?php esc_html_e('Documentation for this theme includes all theme information that is needed to get your site up and running', 'gripvine'); ?></p>
				<p>
					<a href="<?php echo esc_url('http://zidithemes.tumblr.com/post/175432655004/gripvine-wordpress-theme-free'); ?>" class="button button-secondary" target="_blank">
						<?php esc_html_e('Theme Documentation', 'gripvine'); ?>
					</a>
				</p>
			</div>

			<div class="gripvine-adm-wid-49 theme-para theme-opt gripvine-adm-mobwid-100">
				<h4><?php esc_html_e('Gripvine Pro','gripvine'); ?></h4>
				<p class="">
					<?php esc_html_e('Gripvine Pro includes portfolio page templates, additional features and more options to customize your website.',  'gripvine'); ?>
				</p>
				<p>
					<a href="<?php echo esc_url('http://zidithemes.tumblr.com/post/176443871849/gripvine-wordpress-theme-pro'); ?>" class="button button-primary" target="_blank">
						<?php esc_html_e('Upgrade to Gripvine Pro', 'gripvine'); ?>
					</a>
				</p>
			</div>

			<div class="gripvine-adm-wid-49 theme-para theme-opt gripvine-adm-mobwid-100">
				<h4><?php esc_html_e('Theme Options','gripvine'); ?></h4>
				<p class="">
					<?php esc_html_e('Gripvine Theme supports Theme Customizer. Click "Go To Customizer" to open the Customizer now.',  'gripvine'); ?>
				</p>
				<p>
					<a href="<?php echo admin_url('customize.php'); ?>" class="button button-secondary" target="_blank">
						<?php esc_html_e('Go To Customizer', 'gripvine'); ?>
					</a>
				</p>
			</div>

			<div class="gripvine-adm-wid-49 theme-para theme-review gripvine-adm-mobwid-100">
				<h4><?php esc_html_e('Leave us a review','gripvine'); ?></h4>
				<p><?php esc_html_e('We would love to hear your feedback.', 'gripvine'); ?></p>
				<p>
					<a href="<?php echo esc_url('https://wordpress.org/support/theme/gripvine/reviews/#new-post'); ?>" class="button button-secondary" target="_blank">
						<?php esc_html_e('Submit a review', 'gripvine'); ?>
					</a>
				</p>
			</div>


			<div class="gripvine-adm-wid-49 theme-para theme-support gripvine-adm-mobwid-100">
				<h4><?php esc_html_e('Support','gripvine'); ?></h4>
				<p><?php esc_html_e('Reach out in the theme support forums on WordPress.org.', 'gripvine'); ?></p>
				<p>
					<a href="<?php echo esc_url('https://wordpress.org/support/theme/gripvine/'); ?>" class="button button-secondary" target="_blank">
						<?php esc_html_e('Support Forum', 'gripvine'); ?>
					</a>
				</p>
			</div>


			<div class="theme-upgrade gripvine-adm-wid-100">
				<table class="gripvine-adm-wid-100">
					<thead class="theme-table-head">
						<tr>
							<th class="feature"><h3><?php esc_html_e('Features', 'gripvine'); ?></h3></th>
							<th class="gripvine-adm-wid-33"><h3><?php esc_html_e('Gripvine', 'gripvine'); ?></h3></th>
							<th class="gripvine-adm-wid-33"><h3><?php esc_html_e('Gripvine Pro', 'gripvine'); ?></h3></th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td class="feature-items-title">
								<h3><?php esc_html_e('Theme Price', 'gripvine'); ?></h3>
							</td>
							<td class="free-btn"><?php esc_html_e('Free', 'gripvine'); ?></td>
							<td>
								<a class="pro-link-btn" href="<?php echo esc_url('http://zidithemes.tumblr.com/post/176443871849/gripvine-wordpress-theme-pro'); ?>" target="_blank">
									<?php esc_html_e('View Pricing', 'gripvine'); ?>
								</a>
							</td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Responsive Design', 'gripvine'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Portfolio Page Template', 'gripvine'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Testimonials Page Template', 'gripvine'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Team Page Template', 'gripvine'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Gallery Page Template', 'gripvine'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Pricing Page Template', 'gripvine'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('One Column Post Template', 'gripvine'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('3 News Grid Image Styles', 'gripvine'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Full Width Template', 'gripvine'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Footer Credits Options', 'gripvine'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Color Options', 'gripvine'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Gutenberg Compatible', 'gripvine'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Elementor Compatible', 'gripvine'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Major Browser Compatible', 'gripvine'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Woocommerce Compatible', 'gripvine'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class=""></td>
							<td class=""></td>
							<td class="go-pro">
								<span class="">
									<a class="link" href="<?php echo esc_url('http://zidithemes.tumblr.com/post/176443871849/gripvine-wordpress-theme-pro'); ?>" target="_blank">
										<?php esc_html_e('View Pro', 'gripvine'); ?>
									</a>
								</span>
							</td>
						</tr>
					</tbody>
				</table>
			</div>

		</div>
	</div>
	<?php
}
?>
