<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package news-base
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <?php if (!is_single()) { ?>
        <?php $archive_layout_image = news_base_get_option('archive_layout_image'); ?>
        <?php
        $div_image_class = "";
        if (has_post_thumbnail()) {
            if ('left' == $archive_layout_image) {
                $div_image_class = "image-left";
            } elseif ('right' == $archive_layout_image) {
                $div_image_class = "image-right";
            } elseif ('full' == $archive_layout_image) {
                $div_image_class = "image-full";
            } else {
                $div_image_class = "no-image";
            }
        } ?>
        <div class="article-layout <?php echo esc_attr($div_image_class); ?>">
            <div class="article-layout-row">
                <?php $archive_layout = news_base_get_option('archive_layout'); ?>
                <?php if (has_post_thumbnail()) {
                    $thumb = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'large');
                    $url = $thumb['0']; ?>
                    <div class="article-image">
                        <a href="<?php the_permalink(); ?>">
                            <span class="data-bg data-article-image" data-background="<?php echo esc_url($url); ?>">
                              <?php echo news_base_post_format($post->ID); ?>
                            </span>
                        </a>
                    </div>
                <?php } ?>
                <div class="content-wrapper">
                    <?php news_base_category_only(); ?>

                    <?php $show_read_time = news_base_get_option('enable_read_time');
                    $show_read_words = news_base_get_option('number_of_words_per_min');
                    if( 1 == ($show_read_time) ){
                        $content = apply_filters( 'the_content', get_the_content() );
                        $word_count = news_base_count_content_words( $content );
                        //echo $word_count;
                        $word_per_min = ($word_count / $show_read_words);
                        $format_time = __('Read Time : ','news-base');
                        $unit_time = __(' Minutes','news-base');
                        echo "<div class='item-metadata read-time'><span>";
                        echo $format_time;
                        echo round($word_per_min).$unit_time;
                        echo "</span></div>";
                    } ?>

                    <h2 class="entry-title">
                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                    </h2>
                    <div class="item-metadata-group">
                        <?php news_base_posted_date_only(); ?>
                        <?php news_base_posted_by_only(); ?>
                        <?php news_base_posted_comment(); ?>
                    </div>
                    <?php $archive_layout = news_base_get_option('archive_layout'); ?>
                    <?php $archive_layout_image = news_base_get_option('archive_layout_image'); ?>
                    <?php if ('full' == $archive_layout_image) {
                        $full_width_content = 'archive-image-full';
                    } else {
                        $full_width_content = 'tm-archive-lr';
                    }
                    ?>
                    <div class="entry-content tm-entry-content <?php echo esc_attr($full_width_content); ?>">

                        <?php if ('full' == $archive_layout) : ?>
                            <?php
                            the_content(sprintf(
                            /* translators: %s: Name of current post. */
                                wp_kses(__('Continue reading %s <span class="meta-nav">&rarr;</span>', 'news-base'), array('span' => array('class' => array()))),
                                the_title('<span class="screen-reader-text">"', '"</span>', false)
                            ));
                            wp_link_pages(array(
                                'before' => '<div class="page-links">' . esc_html__('Pages:', 'news-base'),
                                'after' => '</div>',
                            ));
                            ?>
                        <?php else : ?>
                            <?php the_excerpt(); ?>
                        <?php endif ?>
                    </div>
                </div>
            </div>
        </div>
    <?php } else { ?>

        <div class="entry-content">
            <?php the_content(); ?>
            <?php
            wp_link_pages(array(
                'before' => '<div class="page-links">' . esc_html__('Pages:', 'news-base'),
                'after' => '</div>',
            ));
            ?>
        </div><!-- .entry-content -->
        <footer class="entry-footer">
            <div class="mb-footer-tags">
                <?php news_base_entry_tags(); ?>
            </div>
        </footer><!-- .entry-footer -->
    <?php } ?>
</article><!-- #post-## -->
