<?php
/**
 * The template for displaying all single posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package news-base
 */

get_header(); ?>

    <div id="primary" class="content-area">
        <div class="theiaStickySidebar">
            <main id="main" class="site-main" role="main">

                <?php
                while (have_posts()) : the_post();

                    get_template_part('template-parts/content');

                    /**
                     * Hook news_base_before_single_nav
                     *
                     * @hooked news_base_related_posts - 10
                     */
                    do_action('news_base_before_single_nav');

                    the_post_navigation(array(
                        'next_text' => '<span class="meta-nav" aria-hidden="true">' . __( 'Next', 'news-base' ) . '</span> ' .
                            '<span class="screen-reader-text">' . __( 'Next post:', 'news-base' ) . '</span> ' .
                            '<span class="post-title">%title</span>',
                        'prev_text' => '<span class="meta-nav" aria-hidden="true">' . __( 'Previous', 'news-base' ) . '</span> ' .
                            '<span class="screen-reader-text">' . __( 'Previous post:', 'news-base' ) . '</span> ' .
                            '<span class="post-title">%title</span>',
                    ));


                    // If comments are open or we have at least one comment, load up the comment template.
                    if (comments_open() || get_comments_number()) :
                        comments_template();
                    endif;

                endwhile; // End of the loop.
                ?>

            </main><!-- #main -->
        </div>
    </div><!-- #primary -->

<?php
get_sidebar();
get_footer();
