<?php
/**
 * Theme widgets.
 *
 * @package News Base
 */

// Load widget base.
require_once get_template_directory() . '/inc/widgets/widget-base-class.php';

if (!function_exists('news_base_load_widgets')) :
    /**
     * Load widgets.
     *
     * @since 1.0.0
     */
    function news_base_load_widgets()
    {
        // News_Base_Grid_Panel widget.
        register_widget('News_Base_widget_style_1');

        //  News_Base_slider
        register_widget('News_Base_widget_slider');

        // list panel widget.
        register_widget('News_Base_widget_style_2');

        // carousel widget.
        register_widget('News_Base_widget_style_3');

        register_widget('News_Base_widget_social');

        // Recent Post widget.
        register_widget('News_Base_sidebar_widget');

        // Tabbed widget.
        register_widget('News_Base_Tabbed_Widget');

        // Auther widget.
        register_widget('News_Base_Author_Post_widget');

    }
endif;
add_action('widgets_init', 'news_base_load_widgets');

/*Grid Panel widget*/
if (!class_exists('News_Base_widget_style_1')) :

    /**
     * Latest news widget Class.
     *
     * @since 1.0.0
     */
    class News_Base_widget_style_1 extends News_Base_Widget_Base
    {

        /**
         * Sets up a new widget instance.
         *
         * @since 1.0.0
         */
        function __construct()
        {
            $opts = array(
                'classname' => 'news_base_grid_panel_widget',
                'description' => __('Displays posts from selected category in grid.', 'news-base'),
                'customize_selective_refresh' => true,
            );
            $fields = array(
                'title' => array(
                    'label' => __('Title:', 'news-base'),
                    'type' => 'text',
                    'class' => 'widefat',
                ),
                'description' => array(
                    'label' => __('Description:', 'news-base'),
                    'type' => 'text',
                    'class' => 'widefat',
                ),
                'post_category' => array(
                    'label' => __('Select Category:', 'news-base'),
                    'type' => 'dropdown-taxonomies',
                    'show_option_all' => __('All Categories', 'news-base'),
                ),
                'post_number' => array(
                    'label' => __('Number of Posts:', 'news-base'),
                    'type' => 'number',
                    'default' => 4,
                    'css' => 'max-width:60px;',
                    'min' => 1,
                    'max' => 10,
                ),
            );

            parent::__construct('news-base-grid-layout', __('NB: Grid Widget', 'news-base'), $opts, array(), $fields);
        }

        /**
         * Outputs the content for the current widget instance.
         *
         * @since 1.0.0
         *
         * @param array $args Display arguments.
         * @param array $instance Settings for the current widget instance.
         */
        function widget($args, $instance)
        {

            $params = $this->get_params($instance);

            echo $args['before_widget'];

            echo "<div class='widget-header-wrapper'>";
            if (!empty($params['title'])) {
                echo $args['before_title'] . $params['title'] . $args['after_title'];
            }

            if (!empty($params['description'])) {
                echo "<p class='widget-description'>";
                echo esc_html($params['description']);
                echo "</p>";
            }
            echo "</div>";

            $qargs = array(
                'posts_per_page' => esc_attr($params['post_number']),
                'no_found_rows' => true,
            );
            if (absint($params['post_category']) > 0) {
                $qargs['category'] = absint($params['post_category']);
            }
            $all_posts = get_posts($qargs);
            ?>
            <?php if (!empty($all_posts)) : ?>

            <?php global $post;
            $author_id = $post->post_author;
            ?>
            <div class="grid-item">
                <div class="row row-sm">
                    <?php foreach ($all_posts as $key => $post) : ?>
                        <?php setup_postdata($post); ?>
                        <div class="column column-half column-clear" data-mh="column-height">
                            <div class="grid-item-image item-image">
                                <figure class="tm-article-item">
                                    <?php if (has_post_thumbnail()) {
                                        $thumb = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'news-base-600-335');
                                        $url = $thumb['0'];
                                    } else {
                                        $url = '';
                                    } ?>
                                    <a href="<?php the_permalink(); ?>">
                                        <span class="data-bg data-bg-1" data-background="<?php echo esc_url($url); ?>">
                                            <?php echo news_base_post_format($post->ID); ?>
                                        </span>
                                    </a>
                                </figure>
                            </div>
                            <div class="grid-item-details">
                                <div class="grid-item-content">
                                    <?php news_base_category_only(); ?>
                                    <h3 class="item-title">
                                        <a href="<?php the_permalink(); ?>">
                                            <?php the_title(); ?>
                                        </a>
                                    </h3>
                                    <div class="item-metadata item-metadata-1 posted-on">
                                        <?php 
                                        $archive_year  = get_the_time('Y'); 
                                        $archive_month = get_the_time('m'); 
                                        $archive_day   = get_the_time('d'); 
                                        ?>
                                        <a href="<?php echo esc_url(get_day_link( $archive_year, $archive_month, $archive_day)) ?>">
                                            <?php echo esc_html(get_the_date()); ?>
                                        </a>
                                    </div>
                                    <div class="entry-content">
                                        <?php
                                        $excerpt = news_base_words_count(30, get_the_content());
                                        echo wp_kses_post(wpautop($excerpt));
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php
                    endforeach; ?>
                </div>
            </div>
            <?php wp_reset_postdata(); ?>

        <?php endif; ?>
            <?php echo $args['after_widget'];
        }
    }
endif;
/*Grid Panel widget*/
if (!class_exists('News_Base_widget_slider')) :

    /**
     * Latest news widget Class.
     *
     * @since 1.0.0
     */
    class News_Base_widget_slider extends News_Base_Widget_Base
    {

        /**
         * Sets up a new widget instance.
         *
         * @since 1.0.0
         */
        function __construct()
        {
            $opts = array(
                'classname' => 'news_base_slider_widget',
                'description' => __('Displays posts from selected category in slider', 'news-base'),
                'customize_selective_refresh' => true,
            );
            $fields = array(
                'title' => array(
                    'label' => __('Title:', 'news-base'),
                    'type' => 'text',
                    'class' => 'widefat',
                ),
                'description' => array(
                    'label' => __('Description:', 'news-base'),
                    'type' => 'text',
                    'class' => 'widefat',
                ),
                'post_category' => array(
                    'label' => __('Select Category:', 'news-base'),
                    'type' => 'dropdown-taxonomies',
                    'show_option_all' => __('All Categories', 'news-base'),
                ),
                'post_number' => array(
                    'label' => __('Number of Posts:', 'news-base'),
                    'type' => 'number',
                    'default' => 4,
                    'css' => 'max-width:60px;',
                    'min' => 1,
                    'max' => 5,
                ),
            );

            parent::__construct('news-base-slider-layout', __('NB: Slider Widget', 'news-base'), $opts, array(), $fields);
        }

        /**
         * Outputs the content for the current widget instance.
         *
         * @since 1.0.0
         *
         * @param array $args Display arguments.
         * @param array $instance Settings for the current widget instance.
         */
        function widget($args, $instance)
        {

            $params = $this->get_params($instance);

            echo $args['before_widget'];

            echo "<div class='widget-header-wrapper'>";
            if (!empty($params['title'])) {
                echo $args['before_title'] . $params['title'] . $args['after_title'];
            }
            if (!empty($params['description'])) {
                echo "<p class='widget-description'>";
                echo esc_html($params['description']);
                echo "</p>";
            }
            echo "</div>";

            $qargs = array(
                'posts_per_page' => esc_attr($params['post_number']),
                'no_found_rows' => true,
            );
            if (absint($params['post_category']) > 0) {
                $qargs['category'] = absint($params['post_category']);
            }
            $all_posts = get_posts($qargs);
            ?>
            <?php if (!empty($all_posts)) : ?>

            <?php global $post;
            $author_id = $post->post_author;
            ?>
            <?php $rtl_class_c = 'false';
            if(is_rtl()){ 
                $rtl_class_c = 'true';
            }?>
            <div class="tm-slider-widget" data-slick='{"rtl": <?php echo($rtl_class_c); ?>}'>
                <?php foreach ($all_posts as $key => $post) : ?>
                    <?php setup_postdata($post); ?>
                    <?php if (has_post_thumbnail()) {
                        $thumb = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'news-base-1200-675');
                        $url = $thumb['0'];
                    } else {
                        $url = '';
                    }
                    ?>
                    <figure class="slick-item primary-bgcolor">
                        <a href="<?php the_permalink(); ?>" class="data-bg data-bg-slide data-bg-slide-widget" data-background="<?php echo esc_url($url); ?>">
                            <?php echo news_base_post_format($post->ID); ?>
                        </a>
                            <figcaption class="slider-figcaption">
                                <div class="slider-figcaption-inner">
                                    <?php news_base_category_only(); ?>
                                    <h2 class="slide-title">
                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                    </h2>

                                    <div class="item-metadata-group">
                                        <?php news_base_posted_date_only(); ?>
                                        <?php news_base_posted_by_only(); ?>
                                        <?php news_base_posted_comment(); ?>
                                    </div>
                                </div>
                            </figcaption>
                    </figure>
                <?php endforeach; ?>
            </div>
            <?php wp_reset_postdata(); ?>

        <?php endif; ?>
            <?php echo $args['after_widget'];
        }
    }
endif;

/*Grid Panel widget*/
if (!class_exists('News_Base_widget_style_2')) :

    /**
     * Latest news widget Class.
     *
     * @since 1.0.0
     */
    class News_Base_widget_style_2 extends News_Base_Widget_Base
    {

        /**
         * Sets up a new widget instance.
         *
         * @since 1.0.0
         */
        function __construct()
        {
            $opts = array(
                'classname' => 'news_base_list_panel_widget',
                'description' => __('Displays post form selected category on List Format.', 'news-base'),
                'customize_selective_refresh' => true,
            );
            $fields = array(
                'title' => array(
                    'label' => __('Title:', 'news-base'),
                    'type' => 'text',
                    'class' => 'widefat',
                ),
                'description' => array(
                    'label' => __('Description:', 'news-base'),
                    'type' => 'text',
                    'class' => 'widefat',
                ),
                'post_category' => array(
                    'label' => __('Select Category:', 'news-base'),
                    'type' => 'dropdown-taxonomies',
                    'show_option_all' => __('All Categories', 'news-base'),
                ),
                'excerpt_length' => array(
                    'label' => __('Excerpt Length:', 'news-base'),
                    'description' => __('Number of words', 'news-base'),
                    'type' => 'number',
                    'css' => 'max-width:60px;',
                    'default' => 20,
                    'min' => 0,
                    'max' => 200,
                ),
            );

            parent::__construct('news-base-list-layout', __('NB: Two Column Widget', 'news-base'), $opts, array(), $fields);
        }

        /**
         * Outputs the content for the current widget instance.
         *
         * @since 1.0.0
         *
         * @param array $args Display arguments.
         * @param array $instance Settings for the current widget instance.
         */
        function widget($args, $instance)
        {

            $params = $this->get_params($instance);

            echo $args['before_widget'];

            echo "<div class='widget-header-wrapper'>";
            if (!empty($params['title'])) {
                echo $args['before_title'] . $params['title'] . $args['after_title'];
            }
            if (!empty($params['description'])) {
                echo "<p class='widget-description'>";
                echo esc_html($params['description']);
                echo "</p>";
            }
            echo "</div>";

            $qargs = array(
                'posts_per_page' => 2,
                'no_found_rows' => true,
            );
            $qargs2 = array(
                'posts_per_page' => 3,
                'no_found_rows' => true,
                'offset' => 2,
            );
            if (absint($params['post_category']) > 0) {
                $qargs['category'] = absint($params['post_category']);
                $qargs2['category'] = absint($params['post_category']);
            }
            $all_posts = get_posts($qargs);
            $all_short_posts = get_posts($qargs2);
            ?>
            <?php $rtl_class_c = 'false';
            if(is_rtl()){
                $rtl_class_c = 'true';
            }?>
            <?php global $post;
            $author_id = $post->post_author;
            ?>
            <?php if (!empty($all_posts)) : ?>
            <div class="tm-widget-wrapper">
                <div class="row row-sm">
                    <?php
                    $i = 1;
                    foreach ($all_posts as $key => $post) : ?>
                        <?php setup_postdata($post);
                        if ($i == 1) {
                            $mb_coll_widget = 'column-half-left';
                        } else {
                            $mb_coll_widget = 'column-half-right';
                        }
                        $i++; ?>
                        <div class="column column-half <?php echo esc_attr($mb_coll_widget) ?>">
                            <figure class="article-figure">
                                <a href="<?php the_permalink(); ?>">
                                    <?php if (has_post_thumbnail()) {
                                        $thumb = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'news-base-600-335');
                                        $url = $thumb['0'];
                                    } else {
                                        $url = '';
                                    } ?>
                                    <span class="data-bg data-bg-1" data-background="<?php echo esc_url($url); ?>">
                                        <?php echo news_base_post_format($post->ID); ?>
                                    </span>
                                </a>
                            </figure>
                            <div class="tm-article-body">
                                <div class="tm-article-inner">
                                    <?php news_base_category_only(); ?>

                                    <div class="item-metadata item-metadata-1 posted-on">
                                        <?php
                                        $archive_year  = get_the_time('Y');
                                        $archive_month = get_the_time('m');
                                        $archive_day   = get_the_time('d');
                                        ?>
                                        <a href="<?php echo esc_url(get_day_link( $archive_year, $archive_month, $archive_day)) ?>">
                                            <?php echo esc_html(get_the_date()); ?>
                                        </a>
                                    </div>

                                    <h3 class="item-title">
                                        <a href="<?php the_permalink(); ?>">
                                            <?php the_title(); ?>
                                        </a>
                                    </h3>

                                    <?php $show_read_time = news_base_get_option('enable_read_time');
                                    $show_read_words = news_base_get_option('number_of_words_per_min');
                                    if( 1 == ($show_read_time) ){
                                        $content = apply_filters( 'the_content', get_the_content() );
                                        $word_count = news_base_count_content_words( $content );
                                        //echo $word_count;
                                        $word_per_min = ($word_count / $show_read_words);
                                        $format_time = __('Read Time : ','news-base');
                                        $unit_time = __(' Minutes','news-base');
                                        echo "<div class='item-metadata read-time'><span>";
                                        echo $format_time;
                                        echo round($word_per_min).$unit_time;
                                        echo "</span></div>";
                                    } ?>

                                    <div class="entry-content">
                                        <?php if (absint($params['excerpt_length']) > 0) : ?>
                                            <?php
                                            $excerpt = news_base_words_count(absint($params['excerpt_length']), get_the_content());
                                            echo wp_kses_post(wpautop($excerpt));
                                            ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                <div class="row-sm row-sm">
                    <?php foreach ($all_short_posts as $key => $post) : ?>
                        <?php setup_postdata($post); ?>
                        <div class="column column-three-1">
                            <div class="grid-item-image item-image">
                                <figure class="tm-article-item">
                                    <a href="<?php the_permalink(); ?>">
                                        <?php if (has_post_thumbnail()) {
                                            $thumb = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'news-base-600-335');
                                            $url = $thumb['0'];
                                        } else {
                                            $url = '';
                                        }?>
                                        <span class="data-bg data-bg-2" data-background="<?php echo esc_url($url); ?>">
                                            <?php echo news_base_post_format($post->ID); ?>
                                        </span>
                                    </a>
                                </figure>
                            </div>

                            <div class="tm-article-sm">
                                <h3 class="item-title item-title-small">
                                    <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a>
                                </h3>
                            </div>

                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <?php wp_reset_postdata(); ?>

        <?php endif; ?>
            <?php echo $args['after_widget'];
        }
    }
endif;

/*Grid Panel widget*/
if (!class_exists('News_Base_widget_style_3')) :

    /**
     * Latest news widget Class.
     *
     * @since 1.0.0
     */
    class News_Base_widget_style_3 extends News_Base_Widget_Base
    {

        /**
         * Sets up a new widget instance.
         *
         * @since 1.0.0
         */
        function __construct()
        {
            $opts = array(
                'classname' => 'news_base_carousel_widget',
                'description' => __('Displays post form selected category on carousel Format.', 'news-base'),
                'customize_selective_refresh' => true,
            );
            $fields = array(
                'title' => array(
                    'label' => __('Title:', 'news-base'),
                    'type' => 'text',
                    'class' => 'widefat',
                ),
                'description' => array(
                    'label' => __('Description:', 'news-base'),
                    'type' => 'text',
                    'class' => 'widefat',
                ),
                'post_category' => array(
                    'label' => __('Select Category:', 'news-base'),
                    'type' => 'dropdown-taxonomies',
                    'show_option_all' => __('All Categories', 'news-base'),
                ),
                'post_number' => array(
                    'label' => __('Number of Posts:', 'news-base'),
                    'type' => 'number',
                    'default' => 4,
                    'css' => 'max-width:60px;',
                    'min' => 1,
                    'max' => 6,
                ),
                'slides_to_show' => array(
                    'label' => __('Number Slides To Show:', 'news-base'),
                    'type'    => 'select',
                    'default' => 3,
                    'options' => array(
                        '1' => __( '1 Item At a Time', 'news-base' ),
                        '2' => __( '2 Items At a Time', 'news-base' ),
                        '3' => __( '3 Items At a Time', 'news-base' ),
                        ),
                    ),
                'excerpt_length' => array(
                    'label' => __('Excerpt Length:', 'news-base'),
                    'description' => __('Number of words', 'news-base'),
                    'type' => 'number',
                    'css' => 'max-width:60px;',
                    'default' => 20,
                    'min' => 0,
                    'max' => 200,
                ),
            );

            parent::__construct('news-base-carousel-layout', __('NB: Carousel Slider Widget', 'news-base'), $opts, array(), $fields);
        }

        /**
         * Outputs the content for the current widget instance.
         *
         * @since 1.0.0
         *
         * @param array $args Display arguments.
         * @param array $instance Settings for the current widget instance.
         */
        function widget($args, $instance)
        {

            $params = $this->get_params($instance);

            echo $args['before_widget'];

            echo "<div class='widget-header-wrapper'>";
            if (!empty($params['title'])) {
                echo $args['before_title'] . $params['title'] . $args['after_title'];
            }
            if (!empty($params['description'])) {
                echo "<p class='widget-description'>";
                echo esc_html($params['description']);
                echo "</p>";
            }
            echo "</div>";

            $qargs = array(
                'posts_per_page' => esc_attr($params['post_number']),
                'no_found_rows' => true,
            );
            if (absint($params['post_category']) > 0) {
                $qargs['category'] = absint($params['post_category']);
            }
            $all_posts = get_posts($qargs);
            ?>
            <?php if (!empty($all_posts)) : ?>

            <?php global $post;
            $author_id = $post->post_author;
            ?>
            <?php $rtl_class_c = 'false';
            if(is_rtl()){
                $rtl_class_c = 'true';
            }?>
            <div class="tm-carousel-widget slide-hover primary-bgcolor"  data-slick='{"slidesToShow": <?php echo esc_attr( $params['slides_to_show'] ); ?>,"rtl": <?php echo($rtl_class_c); ?>}'>
                <?php foreach ($all_posts as $key => $post) : ?>
                    <?php setup_postdata($post); ?>
                    <?php if (has_post_thumbnail()) {
                        $thumb = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'news-base-1200-675');
                        $url = $thumb['0'];
                    } else {
                        $url = '';
                    }
                    ?>
                    <figure class="slick-item">
                        <a href="<?php the_permalink(); ?>" class="data-bg data-bg-slide" data-background="<?php echo esc_url($url); ?>">
                            <?php echo news_base_post_format($post->ID); ?>
                        </a>
                        <figcaption class="slider-figcaption slider-figcaption-1">
                            <?php news_base_category_only(); ?>

                            <div class="item-metadata item-metadata-1 posted-on">
                                <?php
                                $archive_year = get_the_time('Y');
                                $archive_month = get_the_time('m');
                                $archive_day = get_the_time('d');
                                ?>
                                <a href="<?php echo esc_url(get_day_link($archive_year, $archive_month, $archive_day)) ?>">
                                    <?php echo esc_html(get_the_date()); ?>
                                </a>
                            </div>

                            <h2 class="item-title">
                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                            </h2>

                            <?php $show_read_time = news_base_get_option('enable_read_time');
                            $show_read_words = news_base_get_option('number_of_words_per_min');
                            if( 1 == ($show_read_time) ){
                                $content = apply_filters( 'the_content', get_the_content() );
                                $word_count = news_base_count_content_words( $content );
                                //echo $word_count;
                                $word_per_min = ($word_count / $show_read_words);
                                $format_time = __('Read Time : ','news-base');
                                $unit_time = __(' Minutes','news-base');
                                echo "<div class='item-metadata read-time'><span>";
                                echo $format_time;
                                echo round($word_per_min).$unit_time;
                                echo "</span></div>";
                            } ?>

                            <div class="entry-content">
                                <?php if (absint($params['excerpt_length']) > 0) : ?>
                                    <?php
                                    $excerpt = news_base_words_count(absint($params['excerpt_length']), get_the_content());
                                    echo wp_kses_post(wpautop($excerpt));
                                    ?>
                                <?php endif; ?>
                            </div>
                        </figcaption>
                    </figure>
                <?php endforeach; ?>
            </div>
            <?php wp_reset_postdata(); ?>

        <?php endif; ?>
            <?php echo $args['after_widget'];
        }
    }
endif;

/*Grid Panel widget*/
if (!class_exists('News_Base_sidebar_widget')) :

    /**
     * Popular widget Class.
     *
     * @since 1.0.0
     */
    class News_Base_sidebar_widget extends News_Base_Widget_Base
    {

        /**
         * Sets up a new widget instance.
         *
         * @since 1.0.0
         */
        function __construct()
        {
            $opts = array(
                'classname' => 'news_base_popular_post_widget',
                'description' => __('Displays post form selected category specific for popular post in sidebars.', 'news-base'),
                'customize_selective_refresh' => true,
            );
            $fields = array(
                'title' => array(
                    'label' => __('Title:', 'news-base'),
                    'type' => 'text',
                    'class' => 'widefat',
                ),
                'description' => array(
                    'label' => __('Description:', 'news-base'),
                    'type' => 'text',
                    'class' => 'widefat',
                ),
                'post_category' => array(
                    'label' => __('Select Category:', 'news-base'),
                    'type' => 'dropdown-taxonomies',
                    'show_option_all' => __('All Categories', 'news-base'),
                ),
                'enable_description' => array(
                    'label' => __('Enable Description:', 'news-base'),
                    'type' => 'checkbox',
                    'default' => true,
                ),
                'excerpt_length' => array(
                    'label' => __('Excerpt Length:', 'news-base'),
                    'description' => __('Number of words', 'news-base'),
                    'default' => 15,
                    'css' => 'max-width:60px;',
                    'min' => 0,
                    'max' => 200,
                ),
                'post_number' => array(
                    'label' => __('Number of Posts:', 'news-base'),
                    'type' => 'number',
                    'default' => 4,
                    'css' => 'max-width:60px;',
                    'min' => 1,
                    'max' => 6,
                ),
            );

            parent::__construct('news-base-popular-sidebar-layout', __('NB: Post List Widget', 'news-base'), $opts, array(), $fields);
        }

        /**
         * Outputs the content for the current widget instance.
         *
         * @since 1.0.0
         *
         * @param array $args Display arguments.
         * @param array $instance Settings for the current widget instance.
         */
        function widget($args, $instance)
        {

            $params = $this->get_params($instance);

            echo $args['before_widget'];
            echo "<div class='widget-header-wrapper'>";
            if (!empty($params['title'])) {
                echo $args['before_title'] . $params['title'] . $args['after_title'];
            }
            if (!empty($params['description'])) {
                echo "<p class='widget-description'>";
                echo esc_html($params['description']);
                echo "</p>";
            }
            echo "</div>";

            $qargs = array(
                'posts_per_page' => esc_attr($params['post_number']),
                'no_found_rows' => true,
            );
            if (absint($params['post_category']) > 0) {
                $qargs['category'] = absint($params['post_category']);
            }
            $all_posts = get_posts($qargs);
            $count = 1;
            ?>
            <?php global $post;
            $author_id = $post->post_author;
            ?>
            <?php if (!empty($all_posts)) : ?>
            <div class="tm-recent-widget">
                <?php foreach ($all_posts as $key => $post) : ?>
                    <?php setup_postdata($post); ?>
                    <div class="full-item">
                        <div class="row row-sm">
                            <div class="column column-four">
                                <?php if (has_post_thumbnail()) {
                                    $thumb = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'news-base-600-335');
                                    $url = $thumb['0'];
                                } else {
                                    $url = '';
                                } ?>
                                <figure class="tm-article-item">
                                    <a href="<?php the_permalink(); ?>">
                                        <span class="data-bg data-bg-2" data-background="<?php echo esc_url($url); ?>">
                                            <?php echo news_base_post_format($post->ID); ?>
                                        </span>
                                    </a>
                                </figure>

                            </div>
                            <div class="column column-six">
                                <?php news_base_category_only(); ?>

                                <h3 class="item-title">
                                    <a href="<?php the_permalink(); ?>">
                                        <?php the_title(); ?>
                                    </a>
                                </h3>

                                <div class="item-metadata-group">
                                    <?php news_base_posted_date_only(); ?>
                                    <?php news_base_posted_by_only(); ?>
                                </div>

                                <?php if (true === $params['enable_description']) { ?>
                                    <div class="entry-content">
                                        <?php if (absint($params['excerpt_length']) > 0) : ?>
                                            <?php
                                            $excerpt = news_base_words_count(absint($params['excerpt_length']), get_the_content());
                                            echo wp_kses_post(wpautop($excerpt));
                                            ?>
                                        <?php endif; ?>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <?php
                    $count++;
                endforeach; ?>
            </div>

            <?php wp_reset_postdata(); ?>

        <?php endif; ?>
            <?php echo $args['after_widget'];
        }
    }
endif;

/*tabed widget*/
if (!class_exists('News_Base_Tabbed_Widget')) :

    /**
     * Tabbed widget Class.
     *
     * @since 1.0.0
     */
    class News_Base_Tabbed_Widget extends News_Base_Widget_Base
    {

        /**
         * Sets up a new widget instance.
         *
         * @since 1.0.0
         */
        function __construct()
        {

            $opts = array(
                'classname' => 'news_base_widget_tabbed',
                'description' => __('Tabbed widget.', 'news-base'),
            );
            $fields = array(
                'popular_heading' => array(
                    'label' => __('Popular', 'news-base'),
                    'type' => 'heading',
                ),
                'popular_number' => array(
                    'label' => __('No. of Posts:', 'news-base'),
                    'type' => 'number',
                    'css' => 'max-width:60px;',
                    'default' => 5,
                    'min' => 1,
                    'max' => 10,
                ),
                'enable_description' => array(
                    'label' => __('Enable Discription:', 'news-base'),
                    'type' => 'checkbox',
                    'default' => true,
                ),
                'excerpt_length' => array(
                    'label' => __('Excerpt Length:', 'news-base'),
                    'description' => __('Number of words', 'news-base'),
                    'default' => 15,
                    'css' => 'max-width:60px;',
                    'min' => 0,
                    'max' => 200,
                ),
                'recent_heading' => array(
                    'label' => __('Recent', 'news-base'),
                    'type' => 'heading',
                ),
                'recent_number' => array(
                    'label' => __('No. of Posts:', 'news-base'),
                    'type' => 'number',
                    'css' => 'max-width:60px;',
                    'default' => 5,
                    'min' => 1,
                    'max' => 10,
                ),
                'comments_heading' => array(
                    'label' => __('Comments', 'news-base'),
                    'type' => 'heading',
                ),
                'comments_number' => array(
                    'label' => __('No. of Comments:', 'news-base'),
                    'type' => 'number',
                    'css' => 'max-width:60px;',
                    'default' => 5,
                    'min' => 1,
                    'max' => 10,
                ),
            );

            parent::__construct('news-base-tabbed', __('NB: Tab Widget', 'news-base'), $opts, array(), $fields);

        }

        /**
         * Outputs the content for the current widget instance.
         *
         * @since 1.0.0
         *
         * @param array $args Display arguments.
         * @param array $instance Settings for the current widget instance.
         */
        function widget($args, $instance)
        {

            $params = $this->get_params($instance);
            $tab_id = 'tabbed-' . $this->number;

            echo $args['before_widget'];
            ?>
            <div class="tabbed-container">
                <div class="tabbed-head">
                    <ul class="nav nav-tabs" role="tablist">
                        <li role="presentation" class="tab tab-popular active">
                            <a href="#<?php echo esc_attr($tab_id); ?>-popular" aria-controls="<?php esc_html_e('Popular', 'news-base'); ?>" role="tab" data-toggle="tab" class="tab-popular-bgcolor">
                                <span>
                                    <svg xmlns="http://www.w3.org/2000/svg" height="18" version="1.1" viewBox="-22 0 134 134.06032" width="15" fill="currentcolor">
                                        <g>
                                        <path d="M 23.347656 134.058594 C 8.445312 84.953125 39.933594 67.023438 39.933594 67.023438 C 37.730469 93.226562 52.621094 113.640625 52.621094 113.640625 C 58.097656 111.988281 68.550781 104.265625 68.550781 104.265625 C 68.550781 113.640625 63.035156 134.046875 63.035156 134.046875 C 63.035156 134.046875 82.34375 119.117188 88.421875 94.320312 C 94.492188 69.523438 76.859375 44.628906 76.859375 44.628906 C 77.921875 62.179688 71.984375 79.441406 60.351562 92.628906 C 60.933594 91.957031 61.421875 91.210938 61.796875 90.402344 C 63.886719 86.222656 67.242188 75.359375 65.277344 50.203125 C 62.511719 14.890625 30.515625 0 30.515625 0 C 33.273438 21.515625 25.003906 26.472656 5.632812 67.3125 C -13.738281 108.144531 23.347656 134.058594 23.347656 134.058594 Z M 23.347656 134.058594 " />
                                        </g>
                                    </svg>
                                </span>
                                <span class="tab-label">
                                    <?php esc_html_e('Popular', 'news-base'); ?>
                                </span>
                            </a>
                        </li>
                        <li class="tab tab-recent">
                            <a href="#<?php echo esc_attr($tab_id); ?>-recent" aria-controls="<?php esc_html_e('Recent', 'news-base'); ?>" role="tab" data-toggle="tab" class="tab-popular-bgcolor">
                                <span class="tab-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" height="18" version="1.1" viewBox="0 0 129 129" width="15" fill="currentcolor">
                                      <g>
                                        <path d="m57.4,122.2c0.5,0.2 1,0.3 1.5,0.3 1.3,0 2.6-0.6 3.4-1.8l42.9-62c0.9-1.2 1-2.9 0.3-4.2-0.7-1.3-2.1-2.2-3.6-2.2l-26.6-.2 7.7-40.8c0.4-1.8-0.6-3.7-2.3-4.5-1.7-0.8-3.7-0.3-4.9,1.2l-45.5,57.3c-1,1.2-1.2,2.9-0.5,4.3 0.7,1.4 2.1,2.3 3.7,2.3l29.4,.2-7.9,45.6c-0.4,1.9 0.6,3.8 2.4,4.5zm-15.5-58.4l30-37.8-5.6,29.5c-0.2,1.2 0.1,2.4 0.9,3.4 0.8,0.9 1.9,1.5 3.1,1.5l23.7,.1-27.9,40.4 5.5-32.2c0.2-1.2-0.1-2.4-0.9-3.3-0.7-0.9-1.8-1.4-3-1.4l-25.8-.2z"/>
                                      </g>
                                    </svg>
                                </span>
                                <span class="tab-label">
                                    <?php esc_html_e('Recent', 'news-base'); ?>
                                </span>
                            </a>
                        </li>
                        <li class="tab tab-comments">
                            <a href="#<?php echo esc_attr($tab_id); ?>-comments" aria-controls="<?php esc_html_e('Comments', 'news-base'); ?>" role="tab" data-toggle="tab" class="tab-popular-bgcolor">
                                <span class="tab-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" height="18" version="1.1" viewBox="0 0 511.626 511.627" width="15" fill="currentcolor">
                                      <g>
                                        <path d="M477.364,127.481c-22.839-28.072-53.864-50.248-93.072-66.522c-39.208-16.274-82.036-24.41-128.479-24.41
                                            c-46.442,0-89.269,8.136-128.478,24.41c-39.209,16.274-70.233,38.446-93.074,66.522C11.419,155.555,0,186.15,0,219.269
                                            c0,28.549,8.61,55.299,25.837,80.232c17.227,24.934,40.778,45.874,70.664,62.813c-2.096,7.611-4.57,14.842-7.426,21.7
                                            c-2.855,6.851-5.424,12.467-7.708,16.847c-2.286,4.374-5.376,9.23-9.281,14.555c-3.899,5.332-6.849,9.093-8.848,11.283
                                            c-1.997,2.19-5.28,5.801-9.851,10.848c-4.565,5.041-7.517,8.33-8.848,9.853c-0.193,0.097-0.953,0.948-2.285,2.574
                                            c-1.331,1.615-1.999,2.419-1.999,2.419l-1.713,2.57c-0.953,1.42-1.381,2.327-1.287,2.703c0.096,0.384-0.094,1.335-0.57,2.854
                                            c-0.477,1.526-0.428,2.669,0.142,3.429v0.287c0.762,3.234,2.283,5.853,4.567,7.851c2.284,1.992,4.858,2.991,7.71,2.991h1.429
                                            c12.375-1.526,23.223-3.613,32.548-6.279c49.87-12.751,93.649-35.782,131.334-69.094c14.274,1.523,28.074,2.283,41.396,2.283
                                            c46.442,0,89.271-8.135,128.479-24.414c39.208-16.276,70.233-38.444,93.072-66.517c22.843-28.072,34.263-58.67,34.263-91.789
                                            C511.626,186.154,500.207,155.555,477.364,127.481z M445.244,292.075c-19.896,22.456-46.733,40.303-80.517,53.529
                                            c-33.784,13.223-70.093,19.842-108.921,19.842c-11.609,0-23.98-0.76-37.113-2.286l-16.274-1.708l-12.277,10.852
                                            c-23.408,20.558-49.582,36.829-78.513,48.821c8.754-15.414,15.416-31.785,19.986-49.102l7.708-27.412l-24.838-14.27
                                            c-24.744-14.093-43.918-30.793-57.53-50.114c-13.61-19.315-20.412-39.638-20.412-60.954c0-26.077,9.945-50.343,29.834-72.803
                                            c19.895-22.458,46.729-40.303,80.515-53.531c33.786-13.229,70.089-19.849,108.92-19.849c38.828,0,75.13,6.617,108.914,19.845
                                            c33.783,13.229,60.62,31.073,80.517,53.531c19.89,22.46,29.834,46.727,29.834,72.802S465.133,269.615,445.244,292.075z"/>
                                    </g>
                                    </svg>
                                </span>
                                <span class="tab-label">
                                    <?php esc_html_e('Comment', 'news-base'); ?>
                                </span>
                            </a>
                        </li>
                    </ul>
                </div>
                <div class="tab-content">
                    <div id="<?php echo esc_attr($tab_id); ?>-popular" role="tabpanel" class="tab-pane active">
                        <?php $this->render_news('popular', $params); ?>
                    </div>
                    <div id="<?php echo esc_attr($tab_id); ?>-recent" role="tabpanel" class="tab-pane">
                        <?php $this->render_news('recent', $params); ?>
                    </div>
                    <div id="<?php echo esc_attr($tab_id); ?>-comments" role="tabpanel" class="tab-pane">
                        <?php $this->render_comments($params); ?>
                    </div>
                </div>
            </div>
            <?php

            echo $args['after_widget'];

        }

        /**
         * Render news.
         *
         * @since 1.0.0
         *
         * @param array $type Type.
         * @param array $params Parameters.
         * @return void
         */
        function render_news($type, $params)
        {

            if (!in_array($type, array('popular', 'recent'))) {
                return;
            }

            switch ($type) {
                case 'popular':
                    $qargs = array(
                        'posts_per_page' => $params['popular_number'],
                        'no_found_rows' => true,
                        'orderby' => 'comment_count',
                    );
                    break;

                case 'recent':
                    $qargs = array(
                        'posts_per_page' => $params['recent_number'],
                        'no_found_rows' => true,
                    );
                    break;

                default:
                    break;
            }

            $all_posts = get_posts($qargs);
            ?>
            <?php if (!empty($all_posts)) : ?>
            <?php global $post;
            ?>

            <div class="article-item article-list-item">
                <?php foreach ($all_posts as $key => $post) : ?>
                    <?php setup_postdata($post); ?>
                    <div class="full-item">
                        <div class="row row-sm">
                            <div class="col-xs-4">
                                <a href="<?php the_permalink(); ?>">
                                    <?php if (has_post_thumbnail($post->ID)) : ?>
                                        <?php $image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'news-base-600-335'); ?>
                                        <?php if (!empty($image)) : ?>
                                        <span class="data-bg data-bg-4" data-background="<?php echo esc_url($image[0]); ?>">
                                            <?php echo news_base_post_format($post->ID); ?>
                                        </span>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </a>
                            </div>
                            <div class="col-xs-8">
                                <div class="list-item-content">
                                    <div class="item-metadata item-metadata-1 posted-on">
                                        <?php 
                                        $archive_year  = get_the_time('Y'); 
                                        $archive_month = get_the_time('m'); 
                                        $archive_day   = get_the_time('d'); 
                                        ?>
                                        <a href="<?php echo esc_url(get_day_link( $archive_year, $archive_month, $archive_day)) ?>">
                                            <?php echo esc_html(get_the_date()); ?>
                                        </a>
                                    </div>
                                    <h3 class="item-title item-title-small">
                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                    </h3>

                                    <?php if (true === $params['enable_description']) { ?>
                                        <div class="entry-content">
                                            <?php if (absint($params['excerpt_length']) > 0) : ?>
                                                <?php
                                                $excerpt = news_base_words_count(absint($params['excerpt_length']), get_the_content());
                                                echo wp_kses_post(wpautop($excerpt));
                                                ?>
                                            <?php endif; ?>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div><!-- .news-content -->
                    </div>
                <?php endforeach; ?>
            </div><!-- .news-list -->

            <?php wp_reset_postdata(); ?>

        <?php endif; ?>

            <?php

        }

        /**
         * Render comments.
         *
         * @since 1.0.0
         *
         * @param array $params Parameters.
         * @return void
         */
        function render_comments($params)
        {

            $comment_args = array(
                'number' => $params['comments_number'],
                'status' => 'approve',
                'post_status' => 'publish',
            );

            $comments = get_comments($comment_args);
            ?>
            <?php if (!empty($comments)) : ?>
            <ul class="article-item article-list-item">
                <?php foreach ($comments as $key => $comment) : ?>
                    <li class="full-item">
                        <div class="row row-sm">
                            <div class="col-xs-4">
                                <figure class="article-thumbmnail">
                                    <?php $comment_author_url = get_comment_author_url($comment); ?>
                                    <?php if (!empty($comment_author_url)) : ?>
                                        <a href="<?php echo esc_url($comment_author_url); ?>"><?php echo get_avatar($comment, 200); ?></a>
                                    <?php else : ?>
                                        <?php echo get_avatar($comment, 200); ?>
                                    <?php endif; ?>
                                </figure>
                            </div>
                            <div class="col-xs-8">
                                <div class="comments-content">
                                    <?php echo get_comment_author_link($comment); ?>
                                    &nbsp;<?php echo esc_html_x('on', 'Tabbed Widget', 'news-base'); ?>&nbsp;
                                    <a href="<?php echo esc_url(get_comment_link($comment)); ?>"><?php echo get_the_title($comment->comment_post_ID); ?></a>
                                </div>
                            </div>
                        </div>
                    </li>
                <?php endforeach; ?>
            </ul><!-- .comments-list -->
        <?php endif; ?>
            <?php
        }

    }
endif;


/*author widget*/
if (!class_exists('News_Base_Author_Post_widget')) :

    /**
     * Author widget Class.
     *
     * @since 1.0.0
     */
    class News_Base_Author_Post_widget extends News_Base_Widget_Base
    {

        /**
         * Sets up a new widget instance.
         *
         * @since 1.0.0
         */
        function __construct()
        {
            $opts = array(
                'classname' => 'news_base_author_widget',
                'description' => __('Displays authors details in post.', 'news-base'),
                'customize_selective_refresh' => true,
            );
            $fields = array(
                'title' => array(
                    'label' => __('Title:', 'news-base'),
                    'type' => 'text',
                    'class' => 'widefat',
                ),
                'author-name' => array(
                    'label' => __('Name:', 'news-base'),
                    'type' => 'text',
                    'class' => 'widefat',
                ),
                'description' => array(
                    'label' => __('Description:', 'news-base'),
                    'type' => 'textarea',
                    'class' => 'widget-content widefat'
                ),
                'image_url' => array(
                    'label' => __('Author Image:', 'news-base'),
                    'type' => 'image',
                ),
                'url-fb' => array(
                    'label' => __('Facebook URL:', 'news-base'),
                    'type' => 'url',
                    'class' => 'widefat',
                ),
                'url-tw' => array(
                    'label' => __('Twitter URL:', 'news-base'),
                    'type' => 'url',
                    'class' => 'widefat',
                ),
                'url-insta' => array(
                    'label' => __('Instagram URL:', 'news-base'),
                    'type' => 'url',
                    'class' => 'widefat',
                ),
            );

            parent::__construct('news-base-author-layout', __('NB: Author Widget', 'news-base'), $opts, array(), $fields);
        }

        /**
         * Outputs the content for the current widget instance.
         *
         * @since 1.0.0
         *
         * @param array $args Display arguments.
         * @param array $instance Settings for the current widget instance.
         */
        function widget($args, $instance)
        {

            $params = $this->get_params($instance);

            echo $args['before_widget'];

            if (!empty($params['title'])) {
                echo $args['before_title'] . $params['title'] . $args['after_title'];
            } ?>

            <!--cut from here-->
            <div class="author-info">
                <div class="author-image">
                    <?php if (!empty($params['image_url'])) { ?>
                        <div class="profile-image">
                            <img src="<?php echo esc_url($params['image_url']); ?>">
                        </div>
                    <?php } ?>
                </div> <!-- /#author-image -->
                <div class="author-details">
                    <?php if (!empty($params['author-name'])) { ?>
                        <h3 class="author-name"><?php echo esc_html($params['author-name']); ?></h3>
                    <?php } ?>
                    <?php if (!empty($params['description'])) { ?>
                        <p><?php echo wp_kses_post($params['description']); ?></p>
                    <?php } ?>
                </div> <!-- /#author-details -->
                <div class="author-social">
                    <?php if (!empty($params['url-fb'])) { ?>
                        <a href="<?php echo esc_url($params['url-fb']); ?>" target="_blank"><i class="meta-icon ion-social-facebook"></i></a>
                    <?php } ?>
                    <?php if (!empty($params['url-tw'])) { ?>
                        <a href="<?php echo esc_url($params['url-tw']); ?>" target="_blank"><i class="meta-icon ion-social-twitter"></i></a>
                    <?php } ?>
                    <?php if (!empty($params['url-insta'])) { ?>
                        <a href="<?php echo esc_url($params['url-insta']); ?>" target="_blank"><i class="meta-icon ion-social-instagram"></i></a>
                    <?php } ?>
                </div>
            </div>
            <?php echo $args['after_widget'];
        }
    }
endif;

/*author widget*/
if (!class_exists('News_Base_widget_social')) :

    /**
     * Author widget Class.
     *
     * @since 1.0.0
     */
    class News_Base_widget_social extends News_Base_Widget_Base
    {

        /**
         * Sets up a new widget instance.
         *
         * @since 1.0.0
         */
        function __construct()
        {
            $opts = array(
                'classname' => 'news_base_social_widget',
                'description' => __('Displays social menu if you have set it(social menu)', 'news-base'),
                'customize_selective_refresh' => true,
            );
            $fields = array(
                'title' => array(
                    'label' => __('Title:', 'news-base'),
                    'description' => __('Note: Displays social menu if you have set it(social menu)', 'news-base'),
                    'type' => 'text',
                    'class' => 'widefat',
                ),
                'description' => array(
                    'label' => __('Description:', 'news-base'),
                    'type' => 'text',
                    'class' => 'widefat',
                ),
            );
            parent::__construct('news-base-social-layout', __('NB: Social Menu Widget', 'news-base'), $opts, array(), $fields);
        }

        /**
         * Outputs the content for the current widget instance.
         *
         * @since 1.0.0
         *
         * @param array $args Display arguments.
         * @param array $instance Settings for the current widget instance.
         */
        function widget($args, $instance)
        {

            $params = $this->get_params($instance);

            echo $args['before_widget'];

            echo "<div class='widget-header-wrapper'>";
            if (!empty($params['title'])) {
                echo $args['before_title'] . $params['title'] . $args['after_title'];
            }
            if (!empty($params['description'])) {
                echo "<p class='widget-description'>";
                echo esc_html($params['description']);
                echo "</p>";
            }
            echo "</div>";
            ?>

            <!--cut from here-->
            <div class="social-widget-menu">
                <?php
                if ( has_nav_menu( 'social' ) ) {
                    wp_nav_menu( array(
                        'theme_location' => 'social',
                        'link_before'    => '<span>',
                        'link_after'     => '</span>',
                    ) );
                } ?>
            </div>
            <?php if ( ! has_nav_menu( 'social' ) ) : ?>
            <p>
                <?php esc_html_e( 'Social menu is not set. You need to create menu and assign it to Social Menu on Menu Settings.', 'news-base' ); ?>
            </p>
        <?php endif; ?>
            <?php echo $args['after_widget'];
        }
    }
endif;

