<?php
/**
 * Custom template tags for this theme.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package news-base
 */
if ( ! function_exists( 'news_base_category_only' ) ) :
/**
 * Prints HTML with meta information for the categories, tags and comments.
 */
function news_base_category_only() {
	// Hide category and tag text for pages.
	if ( 'post' === get_post_type() ) {
		/* translators: used between list items, there is a space after the comma */
		$categories_list = get_the_category_list( esc_html__( ' ', 'news-base' ) );
		if ( $categories_list && news_base_categorized_blog() ) {
			printf( '<div class="item-metadata categories-list">' . esc_html__( ' ', 'news-base' ).' %1$s'. '</div>', $categories_list ); // WPCS: XSS OK.
		}
	}

}
endif;

if (!function_exists('news_base_posted_comment')) :
    function news_base_posted_comment()
    {
        if (!is_single() && !post_password_required() && (comments_open() || get_comments_number())) {
            echo '<div class="item-metadata comments-link"><span class="tmicon-meta ion-chatbubbles"></span> ';
            comments_popup_link(esc_html__(' 0 ', 'news-base'), esc_html__(' 1 ', 'news-base'), esc_html__(' % ', 'news-base'));
            echo '</div>';
        } 
    }
endif;


if (!function_exists('news_base_posted_date_only')) :
    /**
     * Prints HTML with meta information for the current post-date/time and author.
     */
    function news_base_posted_date_only()
    {
        global $post;
        $author_id = $post->post_author;
        $time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
        if (get_the_time('U') !== get_the_modified_time('U')) {
            $time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
        }

        $time_string = sprintf($time_string,
            esc_attr(get_the_date('c')),
            esc_html(get_the_date()),
            esc_attr(get_the_modified_date('c')),
            esc_html(get_the_modified_date())
        );
        $archive_year  = get_the_time('Y'); 
        $archive_month = get_the_time('m'); 
        $archive_day   = get_the_time('d'); 
        $posted_on = sprintf(
            esc_html__( ' %s', 'news-base' ),
                                                                   
            '<a href="' . esc_url(get_day_link( $archive_year, $archive_month, $archive_day)) . '" rel="bookmark">'. '<span class="tmicon-meta ion-android-alarm-clock"></span> ' . $time_string . '</a>'
        );

        echo '<div class="item-metadata posted-on">' . $posted_on . '</div>'; // WPCS: XSS OK.
    }
endif;



if (!function_exists('news_base_posted_by_only')) :
    /**
     * Prints HTML with meta information for the current post-date/time and author.
     */
    function news_base_posted_by_only()
    {
        global $post;
        $author_id = $post->post_author;
        $byline = sprintf(
        	__( ' %s', 'news-base' ),
        	'<a class="url fn n" href="' . esc_url( get_author_posts_url( $author_id ) ) . '"><span class="tmicon-meta ion-person"></span>' . esc_html( get_the_author_meta( 'display_name', $author_id ) ) . '</a>'
        );

        echo '<div class="item-metadata byline"> ' . $byline . '</div>'; // WPCS: XSS OK.
    }
endif;



if ( ! function_exists( 'news_base_entry_tags' ) ) :
/**
 * Prints HTML with meta information for the tags.
 */
	function news_base_entry_tags() {
		/* translators: used between list items, there is a space after the comma */
		$tags_list = get_the_tag_list( '', esc_html__( ' ', 'news-base' ) );
		if ( $tags_list ) {
			printf( '<span class="tags-links item-metadata categories-list">' . esc_html__( 'Tagged in :', 'news-base' ).'<span class="categories-list">' .' %1$s'. '</span></span>', $tags_list ); // WPCS: XSS OK.
		}
	}
endif;

/**
 * Returns true if a blog has more than 1 category.
 *
 * @return bool
 */
function news_base_categorized_blog() {
	if ( false === ( $all_the_cool_cats = get_transient( 'news_base_categories' ) ) ) {
		// Create an array of all the categories that are attached to posts.
		$all_the_cool_cats = get_categories( array(
			'fields'     => 'ids',
			'hide_empty' => 1,
			// We only need to know if there is more than one category.
			'number'     => 2,
		) );

		// Count the number of categories that are attached to the posts.
		$all_the_cool_cats = count( $all_the_cool_cats );

		set_transient( 'news_base_categories', $all_the_cool_cats );
	}

	if ( $all_the_cool_cats > 1 ) {
		// This blog has more than 1 category so news_base_categorized_blog should return true.
		return true;
	} else {
		// This blog has only 1 category so news_base_categorized_blog should return false.
		return false;
	}
}

/**
 * Flush out the transients used in news_base_categorized_blog.
 */
function news_base_category_transient_flusher() {
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}
	// Like, beat it. Dig?
	delete_transient( 'news_base_categories' );
}
add_action( 'edit_category', 'news_base_category_transient_flusher' );
add_action( 'save_post',     'news_base_category_transient_flusher' );
