<?php
/**
 * Implement theme metabox.
 *
 * @package news-base
 */

if ( ! function_exists( 'news_base_add_theme_meta_box' ) ) :

    /**
     * Add the Meta Box
     *
     * @since 1.0.0
     */
    function news_base_add_theme_meta_box() {

        $apply_metabox_post_types = array( 'post', 'page' );

        foreach ( $apply_metabox_post_types as $key => $type ) {
            add_meta_box(
                'news-base-theme-settings',
                esc_html__( 'Single Page/Post Settings', 'news-base' ),
                'news_base_render_theme_settings_metabox',
                $type
            );
        }

    }

endif;

add_action( 'add_meta_boxes', 'news_base_add_theme_meta_box' );

if ( ! function_exists( 'news_base_render_theme_settings_metabox' ) ) :

    /**
     * Render theme settings meta box.
     *
     * @since 1.0.0
     */
    function news_base_render_theme_settings_metabox( $post, $metabox ) {

        $post_id = $post->ID;
        $news_base_post_meta_value = get_post_meta($post_id);

        // Meta box nonce for verification.
        wp_nonce_field( basename( __FILE__ ), 'news_base_meta_box_nonce' );
        // Fetch Options list.
        $page_layout = get_post_meta($post_id,'news-base-meta-select-layout',true);
        $page_image_layout = get_post_meta($post_id,'news-base-meta-image-layout',true);
        ?>

        <div class="tmt-tab-main">

            <div class="tmt-metabox-tab">
                <ul>
                    <li>
                        <a id="tmt-tab-og" class="tmt-tab-active" href="javascript:void(0)">

                            <?php esc_html_e('General Settings', 'news-base'); ?>
                        
                        </a>
                    </li>
                </ul>
            </div>

            <div class="tmt-tab-content">
                
                <div id="tmt-tab-og-content" class="tmt-content-wrap tmt-tab-content-active">

                    <div class="tmt-meta-panels">

                        <div class="tmt-opt-wrap tmt-opt-wrap-alt">

                            <label><b><?php esc_html_e( 'Sidebar Layout','news-base' ); ?></b></label>

                            <select name="news-base-meta-select-layout">

                                <option value="right-sidebar" <?php selected('right-sidebar',$page_layout);?>>

                                    <?php _e( 'Content - Primary Sidebar', 'news-base' )?>

                                </option>

                                <option value="left-sidebar" <?php selected('left-sidebar',$page_layout);?>>

                                    <?php _e( 'Primary Sidebar - Content', 'news-base' )?>

                                </option>

                                <option value="no-sidebar" <?php selected('no-sidebar',$page_layout);?>>

                                    <?php _e( 'No Sidebar', 'news-base' )?>

                                </option>

                            </select>

                        </div>

                        <?php $tmt_ed_feature_image = esc_attr(get_post_meta($post->ID, 'tmt_ed_feature_image', true)); ?>

                        <div class="tmt-opt-wrap tmt-checkbox-wrap">

                            <input id="tmt-normal-comment" name="tmt_ed_feature_image" type="checkbox" <?php if ($tmt_ed_feature_image) { ?> checked="checked" <?php } ?> />

                            <label for="tmt-normal-comment"><?php esc_html_e('Disable Feature Image For This Post', 'news-base'); ?></label>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    <?php
    }

endif;



if ( ! function_exists( 'news_base_save_theme_settings_meta' ) ) :

    /**
     * Save theme settings meta box value.
     *
     * @since 1.0.0
     *
     * @param int     $post_id Post ID.
     * @param WP_Post $post Post object.
     */
    function news_base_save_theme_settings_meta( $post_id, $post ) {

        // Verify nonce.
        if ( ! isset( $_POST['news_base_meta_box_nonce'] ) || ! wp_verify_nonce( $_POST['news_base_meta_box_nonce'], basename( __FILE__ ) ) ) {
            return; }

        // Bail if auto save or revision.
        if ( defined( 'DOING_AUTOSAVE' ) || is_int( wp_is_post_revision( $post ) ) || is_int( wp_is_post_autosave( $post ) ) ) {
            return;
        }

        // Check the post being saved == the $post_id to prevent triggering this call for other save_post events.
        if ( empty( $_POST['post_ID'] ) || $_POST['post_ID'] != $post_id ) {
            return;
        }

        // Check permission.
        if ( 'page' === $_POST['post_type'] ) {
            if ( ! current_user_can( 'edit_page', $post_id ) ) {
                return; }
        } else if ( ! current_user_can( 'edit_post', $post_id ) ) {
            return;
        }
        
        $tmt_ed_feature_image_old = esc_html( get_post_meta( $post_id, 'tmt_ed_feature_image', true ) ); 
        $tmt_ed_feature_image_new = sanitize_text_field( wp_unslash( $_POST['tmt_ed_feature_image'] ) );
        if ( $tmt_ed_feature_image_new && $tmt_ed_feature_image_new != $tmt_ed_feature_image_old ) {  
            update_post_meta ( $post_id, 'tmt_ed_feature_image', $tmt_ed_feature_image_new );
        } elseif ( '' == $tmt_ed_feature_image_new && $tmt_ed_feature_image_old ) {  
            delete_post_meta( $post_id,'tmt_ed_feature_image', $tmt_ed_feature_image_old );  
        }
        
        if ( isset( $_POST['news-base-meta-select-layout'] )){
            $valid_layout_values = array(
                'left-sidebar',
                'right-sidebar',
                'no-sidebar',
            );
            $layout_value = sanitize_text_field( $_POST['news-base-meta-select-layout'] );
            if( in_array( $layout_value, $valid_layout_values ) ) {
                update_post_meta($post_id, 'news-base-meta-select-layout', $layout_value);
            }else{
                delete_post_meta($post_id,'news-base-meta-select-layout');
            }
        }

    }

endif;

add_action( 'save_post', 'news_base_save_theme_settings_meta', 10, 2 );