<?php
if (!function_exists('news_base_trending_news')) :
    /**
     * Banner Slider
     *
     * @since news-base 1.0.0
     *
     */
    function news_base_trending_news()
    {
        if (1 != news_base_get_option('show_trending_news_section')) {
            return null;
        }
        global $post;
        $news_base_trending_news_category = esc_attr(news_base_get_option('select_category_for_trending_news'));
        $news_base_trending_news_title = esc_html(news_base_get_option('trending_news_title'));
        $news_base_trending_news_number = 4;
        ?>
        <section class="trending-news-corousal section-block section-block-space">
            <div class="container">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="trending-title">
                            <h2 class="section-title">
                                <?php echo esc_html($news_base_trending_news_title); ?>
                            </h2>
                        </div>
                        <?php
                        $news_base_trending_news_args = array(
                            'post_type' => 'post',
                            'cat' => absint($news_base_trending_news_category),
                            'ignore_sticky_posts' => true,
                            'posts_per_page' => absint( $news_base_trending_news_number ),
                        ); ?>
                        <?php $rtl_class_c = 'false';
                        if(is_rtl()){ 
                            $rtl_class_c = 'true';
                        }?>
                        <div class="trending-slider" data-slick='{"rtl": <?php echo($rtl_class_c); ?>}'>
                        <?php $news_base_trending_news_post_query = new WP_Query($news_base_trending_news_args);
                        if ($news_base_trending_news_post_query->have_posts()) :
                            while ($news_base_trending_news_post_query->have_posts()) : $news_base_trending_news_post_query->the_post();
                                if(has_post_thumbnail()){
                                    $thumb = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'news-base-600-335' );
                                    $url = $thumb['0'];
                                } else {
                                    $url = '';
                                }
                                ?>
                                <div class="slider-nav-item">
                                    <figure class="tm-article-item tm-article-corousal-slides" data-mh="trending-height">
                                        <a href="<?php the_permalink(); ?>">
                                            <span class="data-bg data-bg-2" data-background="<?php echo esc_url($url); ?>">
                                                <?php echo news_base_post_format($post->ID); ?>
                                            </span>
                                        </a>
                                        <figcaption>
                                            <?php news_base_category_only(); ?>

                                            <h3 class="item-title item-title-medium">
                                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                            </h3>

                                            <?php $show_read_time = news_base_get_option('enable_read_time');
                                            $show_read_words = news_base_get_option('number_of_words_per_min');
                                            if( 1 == ($show_read_time) ){
                                                $content = apply_filters( 'the_content', get_the_content() );
                                                $word_count = news_base_count_content_words( $content );
                                                //echo $word_count;
                                                $word_per_min = ($word_count / $show_read_words);
                                                $format_time = __('Read Time : ','news-base');
                                                $unit_time = __(' Minutes','news-base');
                                                echo "<div class='item-metadata read-time'><span>";
                                                echo $format_time;
                                                echo round($word_per_min).$unit_time;
                                                echo "</span></div>";
                                            } ?>
                                        </figcaption>
                                    </figure>
                                </div>
                            <?php
                            endwhile;
                        endif;
                        wp_reset_postdata();
                        ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <?php
    }
endif;
add_action('news_base_action_trending_slider', 'news_base_trending_news', 30);
