<?php
global $post;
if (!function_exists('news_base_single_page_title')) :
    function news_base_single_page_title()
    {
        if (is_home()) {
            return;
        }
        global $post;
        ?>
        <div class="inner-banner">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">

                        <?php if( !is_404() ){ ?>
                            <div class="breadcrumb-wrapper">
                                <?php
                                /**
                                 * Hook - news_base_add_breadcrumb.
                                 */
                                do_action('news_base_action_breadcrumb');
                                ?>
                            </div>
                        <?php 
                        }
                        
                        if (is_singular()) { ?>
                            <div class="single-category">
                                <?php news_base_category_only(); ?>
                            </div>
                            <?php the_title('<h1 class="entry-title">', '</h1>'); ?>
                            <?php if (!is_page()) { ?>
                                <div class="item-metadata-group">
                                    <?php news_base_posted_date_only(); ?>
                                    <?php news_base_posted_by_only(); ?>
                                </div>
                            <?php } ?>
                            <?php if (has_post_thumbnail()) {
                                $thumb = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'full');
                                $url = $thumb['0'];
                            }  else {
                                $url = '';
                            }
                            
                            $tmt_ed_feature_image = esc_attr( get_post_meta( get_the_ID(), 'tmt_ed_feature_image', true ) ); ?>

                            <?php if( $url && !$tmt_ed_feature_image ){ ?>
                                <span class="data-bg data-bg-banner" data-background="<?php echo esc_url($url); ?>"></span>
                            <?php } ?>

                            <?php $show_read_time = news_base_get_option('enable_read_time');
                            $show_read_words = news_base_get_option('number_of_words_per_min');
                            if( 1 == ($show_read_time) ){
                                $content = apply_filters( 'the_content', get_the_content() );
                                $word_count = news_base_count_content_words( $content );
                                //echo $word_count;
                                $word_per_min = ($word_count / $show_read_words);
                                $format_time = __('Read Time : ','news-base');
                                $unit_time = __(' Minutes','news-base');
                                echo "<div class='item-metadata read-time'><span>";
                                echo $format_time;
                                echo round($word_per_min).$unit_time;
                                echo "</span></div>";
                            } ?>
                            <?php if (has_excerpt()) { ?>
                                <div class="banner-excerpt">
                                    <?php the_excerpt(); ?>
                                </div>
                            <?php } ?>

                        <?php } elseif (is_404()) { ?>
                            <h1 class="entry-title"><?php esc_html_e('Oops! That page can&rsquo;t be found.', 'news-base'); ?></h1>
                        <?php } elseif (is_archive()) {
                            the_archive_title('<h1 class="entry-title">', '</h1>');
                            the_archive_description('<div class="taxonomy-description">', '</div>');
                        } elseif (is_search()) { ?>
                            <h1 class="entry-title"><?php printf(esc_html__('Search Results for: %s', 'news-base'), '<span>' . get_search_query() . '</span>'); ?></h1>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>

        <?php
    }
endif;
add_action('news-base-page-inner-title', 'news_base_single_page_title', 15);
