<?php
if (!function_exists('news_base_fullwidth_video')) :
    /**
     * Banner Slider
     *
     * @since news-base 1.0.0
     *
     */
    function news_base_fullwidth_video()
    {
        if (1 != news_base_get_option('show_fullwidth_video_section')) {
            return null;
        }
        $news_base_fullwidth_video_category = absint(news_base_get_option('select_category_for_fullwidth_video'));
        $news_base_fullwidth_video_number = absint(news_base_get_option('number_of_home_fullwidth_video'));
        $number_of_content_video_slider = absint(news_base_get_option('number_of_content_video_slider'));
        ?>
        <?php $rtl_class_c = 'false';
        if(is_rtl()){ 
            $rtl_class_c = 'true';
        }?>
        <!--Videoslider-->
        <section class="section-video section-block">
            <div class="container">
            <?php $news_base_fullwidth_video_args = array(
                'post_type' => 'post',
                'cat' => absint($news_base_fullwidth_video_category),
                'ignore_sticky_posts' => true,
                'posts_per_page' => absint($news_base_fullwidth_video_number),
            ); ?>
                <div class="tm-videos slide-hover slide-hover-reversed" data-slick='{"rtl": <?php echo($rtl_class_c); ?>}'>
                    <?php
                    $news_base_fullwidth_video_post_query = new WP_Query($news_base_fullwidth_video_args);
                    if ($news_base_fullwidth_video_post_query->have_posts()) :
                        $slider_pagenav = '';
                        while ($news_base_fullwidth_video_post_query->have_posts()) : $news_base_fullwidth_video_post_query->the_post();
                            if (has_post_thumbnail()) {
                                $thumb = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'news-base-1200-675');
                                $url = $thumb['0'];
                            } else {
                                $url = '';
                            }
                            global $post;
                            $author_id = $post->post_author;
                            $content = apply_filters( 'the_content', get_the_content() );
                            $video = false;
                            if ( false === strpos( $content, 'wp-playlist-script' ) ) {
                                $video = get_media_embedded_in_content( $content, array( 'video', 'object', 'embed', 'iframe' ) );
                            }
                            $reg = "";
                            $reg = preg_match('|^\s*(https?://[^\s"]+)\s*$|im', get_the_content(), $matches);
                            if ($reg == 1) {
                                $videos = trim($matches[0]);
                            }
                            ?>
                            <figure class="slick-item video-data-bg data-bg data-bg-banner" data-background="<?php echo esc_url($url); ?>">
                                <figcaption class="video-figcaption">
                                    <h2 class="slide-title alt-font">
                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                    </h2>
                                </figcaption>

                                <div class="video-excerpt hidden-xs">
                                    <?php if (has_excerpt()) {
                                        $news_base_video_content = get_the_excerpt();
                                    } else {
                                        $news_base_video_content = news_base_words_count($number_of_content_video_slider, get_the_content());
                                    }
                                    echo esc_html($news_base_video_content);
                                    ?>
                                </div>

                                <?php if ( ! empty( $video ) ) {
                                    foreach ( $video as $video_html ) {
                                        ?>
                                        <a href="<?php echo esc_url($videos); ?>" class="popup-video">
                                            <i class="ion-ios-play play-button"></i>
                                        </a>
                                    <?php }
                                } ?>
                            </figure>
                        <?php
                        $slider_pagenav .= '<div class="slider-nav-item">';
                        $slider_pagenav .= '<figure class="navtitle-wrapper">';
                        $slider_pagenav .= ' <span class="data-bg data-bg-thumbnails data-radius" data-background="'. esc_url($url) .'"></span>';
                        $slider_pagenav .= '<h4 class="item-title item-title-small">';
                        $slider_pagenav .=  esc_html(wp_trim_words( get_the_title() ));
                        $slider_pagenav .= '</h4>';
                        $slider_pagenav .= '</figure></div>';
                            endwhile;
                        endif;
                        wp_reset_postdata();
                        ?>
                </div>
            </div>
            <div class="slider-pagenav hidden-xs">
                <div class="container">
                    <div class="video-pagenav" data-slick='{"rtl": <?php echo($rtl_class_c); ?>}'>
                        <?php echo $slider_pagenav;?>
                    </div>
                </div>
            </div>
        </section>

        <!--Videoslider-->

        <?php
    }
endif;
add_action('news_base_action_fullwidth_video', 'news_base_fullwidth_video', 10);
