<?php
if (!function_exists('news_base_fullwidth_slider')) :
    /**
     * Banner Slider
     *
     * @since news-base 1.0.0
     *
     */
    function news_base_fullwidth_slider()
    {
        if (1 != news_base_get_option('show_fullwidth_slider_section')) {
            return null;
        }
        $news_base_fullwidth_slider_category = absint(news_base_get_option('select_category_for_fullwidth_slider'));
        $news_base_fullwidth_slider_number = absint(news_base_get_option('number_of_home_fullwidth_slider'));
        ?>

        <section class="fullwidth-banner section-block">
            <?php $rtl_class_c = 'false';
            if(is_rtl()){ 
                $rtl_class_c = 'true';
            }?>
            <div class="mainbanner-jumbotron" data-slick='{"rtl": <?php echo($rtl_class_c); ?>}'>
                <?php
                $news_base_fullwidth_slider_args = array(
                    'post_type' => 'post',
                    'cat' => absint($news_base_fullwidth_slider_category),
                    'ignore_sticky_posts' => true,
                    'posts_per_page' => absint($news_base_fullwidth_slider_number),
                ); ?>
                <?php
                $news_base_fullwidth_slider_post_query = new WP_Query($news_base_fullwidth_slider_args);
                if ($news_base_fullwidth_slider_post_query->have_posts()) :
                    $slider_pagenav = '';
                    while ($news_base_fullwidth_slider_post_query->have_posts()) : $news_base_fullwidth_slider_post_query->the_post();
                        if (has_post_thumbnail()) {
                            $thumb = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'news-base-1200-675');
                            $url = $thumb['0'];
                        } else {
                            $url = '';
                        }
                        global $post;
                        $author_id = $post->post_author;
                        ?>
                            <figure class="slick-item primary-bgcolor">
                                <a href="<?php the_permalink(); ?>" class="data-bg data-bg-banner" data-background="<?php echo esc_url( $url ) ?>">
                                    <span class="background-overlay">
                                        <?php echo news_base_post_format($post->ID); ?>
                                    </span>
                                </a>
                                <figcaption class="slider-figcaption slider-figcaption-full">
                                    <div class="container">
                                        <div class="row">
                                            <div class="col-sm-12 col-md-6">
                                                <?php news_base_category_only(); ?>
                                                <h2 class="slide-title">
                                                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                                </h2>
                                                <div class="item-metadata-group">
                                                    <?php news_base_posted_date_only(); ?>
                                                    <?php news_base_posted_by_only(); ?>
                                                    <?php news_base_posted_comment(); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </figcaption>
                            </figure>
                        <?php
                        $slider_pagenav .= '<div class="slider-nav-item"><figure class="slider-article">';
                        $slider_pagenav .= '<figcaption class="navtitle-wrapper">';
                        $slider_pagenav .= '<div class="item-metadata item-metadata-1 posted-on">'.esc_html(get_the_date()).'</div>';
                        $slider_pagenav .= '<h4 class="item-title">'.esc_html(wp_trim_words( get_the_title() )).'</h4>';
                        $slider_pagenav .= '</figcaption>';
                        $slider_pagenav .= '</figure></div>';
                        endwhile;
                    endif;
                    wp_reset_postdata();
                    ?>
            </div>

            <div class="slider-pagenav hidden-xs">
                <div class="container">
                    <div class="jumbotron-pagenav" data-background="<?php echo esc_url( $url ) ?>">
                        <?php echo $slider_pagenav;?>
                    </div>
                </div>
            </div>
        </section>
        <?php
    }
endif;
add_action('news_base_action_fullwidth_slider', 'news_base_fullwidth_slider', 10);
