<?php
/**
 * CSS related hooks.
 *
 * This file contains hook functions which are related to CSS.
 *
 * @package news-base
 */

if (!function_exists('news_base_trigger_custom_css_action')) :

    /**
     * Do action theme custom CSS.
     *
     * @since 1.0.0
     */
    function news_base_trigger_custom_css_action()
    {
        $news_base_header_text_color = news_base_get_option('header_text_color');
        ?>
        <style type="text/css">
            <?php
                if (!empty($news_base_header_text_color) ){ ?>
                .site #masthead .data-bg.header-middle a,
                .site #masthead .data-bg.header-middle,
                .site #masthead .data-bg.header-middle .site-branding,
                .site #masthead .data-bg.header-middle .site-branding .site-title a {
                    color: <?php echo esc_attr( $news_base_header_text_color ); ?>;
                }

                <?php }
            ?>
        </style>

    <?php }

endif;