<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package news-base
 */

?>
        </div>
    </div> <!-- site-content-container -->
</div>
<?php if (is_front_page()) { ?>
    <?php do_action('news_base_action_footer_recomended'); ?>
<?php } ?>
<?php if (has_nav_menu( 'social' )) { ?>
    <div class="footer-social-area">
        <div class="container">
            <div class="row">
                <div class="col-sm-12">
                    <div class="tm-social-share">
                        <div class="social-icons">
                            <?php
                            wp_nav_menu(
                                array('theme_location' => 'social',
                                    'link_before' => '<span class="social-label">',
                                    'link_after' => '</span>',
                                    'menu_id' => 'social-menu',
                                    'fallback_cb' => false,
                                    'menu_class' => false
                                )); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php } ?>

<footer id="footer-main" class="site-footer" role="contentinfo">
    <?php $news_base_footer_widgets_number = news_base_get_option('number_of_footer_widget');
    if (1 == $news_base_footer_widgets_number) {
        $col = 'col-md-12';
    } elseif (2 == $news_base_footer_widgets_number) {
        $col = 'col-md-6';
    } elseif (3 == $news_base_footer_widgets_number) {
        $col = 'col-md-4';
    } elseif (4 == $news_base_footer_widgets_number) {
        $col = 'col-md-3';
    } else {
        $col = 'col-md-3';
    }
    if (is_active_sidebar('footer-col-one') || is_active_sidebar('footer-col-two') || is_active_sidebar('footer-col-three') || is_active_sidebar('footer-col-four')) { ?>
        <div class="footer-widget">
            <div class="container">
                <div class="row">
                    <?php if (is_active_sidebar('footer-col-one') && $news_base_footer_widgets_number > 0) : ?>
                        <div class="widget-grid <?php echo esc_attr($col); ?>">
                            <?php dynamic_sidebar('footer-col-one'); ?>
                        </div>
                    <?php endif; ?>
                    <?php if (is_active_sidebar('footer-col-two') && $news_base_footer_widgets_number > 1) : ?>
                        <div class="widget-grid <?php echo esc_attr($col); ?>">
                            <?php dynamic_sidebar('footer-col-two'); ?>
                        </div>
                    <?php endif; ?>
                    <?php if (is_active_sidebar('footer-col-three') && $news_base_footer_widgets_number > 2) : ?>
                        <div class="widget-grid <?php echo esc_attr($col); ?>">
                            <?php dynamic_sidebar('footer-col-three'); ?>
                        </div>
                    <?php endif; ?>
                    <?php if (is_active_sidebar('footer-col-four') && $news_base_footer_widgets_number > 3) : ?>
                        <div class="widget-grid <?php echo esc_attr($col); ?>">
                            <?php dynamic_sidebar('footer-col-four'); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php } ?>


        
    <div class="footer-bottom">
        <div class="container">
            <div class="row">
                <div class="col-md-6 col-sm-12 col-xs-12">
                    <div class="site-copyright">
                        <?php
                        $news_base_copyright_text = news_base_get_option('copyright_text');
                        if (!empty ($news_base_copyright_text)) {
                            echo wp_kses_post($news_base_copyright_text);
                        }
                        ?>
                        <?php printf(esc_html__('Theme: %1$s by %2$s', 'news-base'), 'News Base', '<a href="https://thememattic.com" target = "_blank" rel="designer">Themematic </a>'); ?>
                    </div>
                </div>
                <div class="col-md-6 col-sm-12 col-xs-12">
                    <div class="footer-menu-wrapper">
                        <?php
                        wp_nav_menu(
                            array('theme_location' => 'footer',
                                'link_before' => '<span class="footer-label">',
                                'link_after' => '</span>',
                                'menu_id' => 'footer-menu',
                                'fallback_cb' => false,
                                'depth'           => 1,
                                'menu_class' => false
                            ));
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>

<?php $navigation_collaps_enable = absint(news_base_get_option(' show_navigation_collaps')); ?>
<?php if (1 >= $navigation_collaps_enable) { ?>
    <div class="offcanvas-sidebar" id="sidr">
        <a class="sidr-class-sidr-button-close" href="javascript:void(0)"><i class="ion-ios-close"></i></a>
        <?php if (1 == news_base_get_option('enable_language_switcher')) { ?>
            <div class="nav-language offcanvas-item hidden visible-xs visible-sm">
                <?php echo do_shortcode(news_base_get_option('shortcode_for_language_switcher')); ?>
            </div>
        <?php } ?>

        <?php $show_current_date = absint(news_base_get_option('show_current_date')); ?>
        <?php if (1 == $show_current_date) { ?>
            <div class="news-base-date offcanvas-item hidden visible-xs">
                <?php $news_base_post_date = get_the_date('l F j, Y');
                echo esc_html($news_base_post_date); ?>
            </div>
        <?php } ?>

        <?php $show_search_option = absint(news_base_get_option('show_search_option')); ?>
        <?php if (1 == $show_search_option) { ?>
            <div class="icon-search offcanvas-item hidden visible-xs">
                <?php get_search_form(); ?>
            </div>
        <?php } ?>

        <?php if (is_active_sidebar('tab-sidebar-1')) { ?>
            <div class="tm-sidr-recent-posts">
                <?php dynamic_sidebar('tab-sidebar-1'); ?>
            </div>
        <?php } ?>
        <button type="button" class="tmt-canvas-focus screen-reader-text"></button>
    </div>
<?php } ?>

</div><!-- #page -->
<a id="scroll-up" class="secondary-bgcolor"><i class="ion-ios-arrow-up"></i></a>
<?php wp_footer(); ?>
</body>
</html>