/**
 * Theme Customizer enhancements for a better user experience
 *
 * Contains handlers to make Theme Customizer preview reload changes asynchronously
 */

( function( $ ) {

	wp.customize('blogname', function( value ) {
		value.bind( function( to ) {
			$('.site-title a').text( to );
		} );
	} );
	wp.customize('blogdescription', function( value ) {
		value.bind( function( to ) {
			$('.site-description').text( to );
		} );
	} );

	wp.customize('header_textcolor', function( value ) {
		value.bind( function( to ) {
			if ( 'blank' === to ) {
				$( 'body' ).addClass( 'title-tagline-hidden' );
			} else {
				$( 'body' ).removeClass( 'title-tagline-hidden' );
				$('.site-title a, .site-description').css('color', to );
			}			
		} );
	} );

	wp.customize('hi_color', function( value ) {
		value.bind( function( to ) {			
			var styleBackground = '.button,a.button,button,input[type="button"],input[type="reset"],input[type="submit"],.related-posts h2:before,#top-bar a.button,#top-bar button,#top-bar input[type="button"],#top-bar input[type="reset"],#top-bar input[type="submit"],#colophon h5.widget-title:after{background:' + to + ';}';			
			var styleBackgroundColor = '.mejs-overlay-button,.home .entry-video .mejs-overlay-button,.blog .entry-video .mejs-overlay-button,.archive .entry-video .mejs-overlay-button,.search .entry-video .mejs-overlay-button{background-color:' + to + ';}';
			var styleColor = 'a,a:hover,a:focus,a:active,.single-entry-content a,.latest-entry-icon:before,.latest-entry-icon:after,.entry-header .entry-title a:hover,.entry-header.with-image .entry-title a:hover,.entry-header .entry-title .entry-cat,.entry-header .entry-title .entry-cat a,.entry-header.with-image .entry-title .entry-cat,.entry-header.with-image .entry-title .entry-cat a,.entry-header.with-image .entry-title .entry-cat-sep,.entry-header.with-image .entry-meta .entry-meta-sep,.entry-meta span .fa,.entry-footer span .fa,.entry-footer span.tags-links,.comment-list a:hover,.comment-navigation .nav-previous a,.comment-navigation .nav-next a,#top-bar a,#top-bar a:hover,#top-bar .fa,#primary-menu li a:hover,#primary-menu li.current-menu-item a,#primary-menu li:hover.menu-item-has-children:after,.single #primary-menu li.primary-category a,#primary-menu ul li a:hover,.pagination a:hover,.pagination .current{color:' + to + ';}';		
			var styleBorderColor = '.sticky,#primary-menu > li:hover,#primary-menu > li.current-menu-item,.single #primary-menu > li.primary-category{border-color:' + to + ';}';
			var styleBorderLeftColor = '.comment-navigation .nav-next a:after{border-left-color:' + to + ';}';
			var styleBorderRightColor = '.comment-navigation .nav-previous a:after{border-right-color:' + to + ';}';
			var styleSocialMenu = '#footer-menu a[href*="codepen.io"]:before,#footer-menu a[href*="digg.com"]:before,#footer-menu a[href*="dribbble.com"]:before,#footer-menu a[href*="dropbox.com"]:before,#footer-menu a[href*="facebook.com"]:before,#footer-menu a[href*="flickr.com"]:before,#footer-menu a[href*="foursquare.com"]:before,#footer-menu a[href*="plus.google.com"]:before,#footer-menu a[href*="github.com"]:before,#footer-menu a[href*="instagram.com"]:before,#footer-menu a[href*="linkedin.com"]:before,#footer-menu a[href*="pinterest.com"]:before,#footer-menu a[href*="getpocket.com"]:before,#footer-menu a[href*="reddit.com"]:before,#footer-menu a[href*="skype.com"]:before,#footer-menu a[href*="stumbleupon.com"]:before,#footer-menu a[href*="tumblr.com"]:before,#footer-menu a[href*="twitter.com"]:before,#footer-menu a[href*="vimeo.com"]:before,#footer-menu a[href*="wordpress.com"]:before,#footer-menu a[href*="wordpress.org"]:before,#footer-menu a[href*="youtube.com"]:before,#footer-menu a[href^="mailto:"]:before,#footer-menu a[href*="spotify.com"]:before,#footer-menu a[href*="twitch.tv"]:before,#footer-menu a[href$="/feed/"]:before{box-shadow: inset 0 0 0 ' + to + ';}';
			var styleSocialMenuHover = '#footer-menu a[href*="codepen.io"]:hover:before,#footer-menu a[href*="digg.com"]:hover:before,#footer-menu a[href*="dribbble.com"]:hover:before,#footer-menu a[href*="dropbox.com"]:hover:before,#footer-menu a[href*="facebook.com"]:hover:before,#footer-menu a[href*="flickr.com"]:hover:before,#footer-menu a[href*="foursquare.com"]:hover:before,#footer-menu a[href*="plus.google.com"]:hover:before,#footer-menu a[href*="github.com"]:hover:before,#footer-menu a[href*="instagram.com"]:hover:before,#footer-menu a[href*="linkedin.com"]:hover:before,#footer-menu a[href*="pinterest.com"]:hover:before,#footer-menu a[href*="getpocket.com"]:hover:before,#footer-menu a[href*="reddit.com"]:hover:before,#footer-menu a[href*="skype.com"]:hover:before,#footer-menu a[href*="stumbleupon.com"]:hover:before,#footer-menu a[href*="tumblr.com"]:hover:before,#footer-menu a[href*="twitter.com"]:hover:before,#footer-menu a[href*="vimeo.com"]:hover:before,#footer-menu a[href*="wordpress.com"]:hover:before,#footer-menu a[href*="wordpress.org"]:hover:before,#footer-menu a[href*="youtube.com"]:hover:before,#footer-menu a[href^="mailto:"]:hover:before,#footer-menu a[href*="spotify.com"]:hover:before,#footer-menu a[href*="twitch.tv"]:hover:before,#footer-menu a[href$="/feed/"]:hover:before{background:' + to + ';box-shadow: inset 0 -40px 0 ' + to + ';}';
			$('head').append('<style>' + styleBackground + styleBackgroundColor + styleColor + styleBorderColor + styleBorderLeftColor + styleBorderRightColor + styleSocialMenu + styleSocialMenuHover + '</style>');
		} );
	} );

} )( jQuery );
