<?php
/**
 * Theme help
 *
 * Adds a simple Theme help page to the Appearance section of the WordPress Dashboard.
 *
 * @package Latest
 */

// Add Theme help page to admin menu.
add_action( 'admin_menu', 'latest_add_theme_help_page' );

function latest_add_theme_help_page() {

	// Get Theme Details from style.css
	$theme = wp_get_theme();

	add_theme_page(
		sprintf( esc_html__( 'Welcome to %1$s %2$s', 'latest' ), $theme->get( 'Name' ), $theme->get( 'Version' ) ), esc_html__( 'Theme Help', 'latest' ), 'edit_theme_options', 'latest', 'latest_display_theme_help_page'
	);
}

// Display Theme help page.
function latest_display_theme_help_page() {

	// Get Theme Details from style.css.
	$theme = wp_get_theme();
	?>

	<div class="wrap theme-help-wrap">

		<h1><?php printf( esc_html__( 'Welcome to %1$s %2$s', 'latest' ), esc_html( $theme->get( 'Name' ) ), esc_html( $theme->get( 'Version' ) ) ); ?></h1>

		<div class="theme-description"><?php echo esc_html( $theme->get( 'Description' ) ); ?></div>

		<hr>
		<div class="important-links clearfix">
			<p><strong><?php esc_html_e( 'Theme Links', 'latest' ); ?>:</strong>
				<a href="<?php echo esc_url( 'http://uxlthemes.com/theme/latest/' ); ?>" target="_blank"><?php esc_html_e( 'Theme Page', 'latest' ); ?></a>
				<a href="<?php echo esc_url( 'http://uxlthemes.com/demo/?demo=latest' ); ?>" target="_blank"><?php esc_html_e( 'Theme Demo', 'latest' ); ?></a>
				<a href="<?php echo esc_url( 'http://uxlthemes.com/docs/latest-theme/' ); ?>" target="_blank"><?php esc_html_e( 'Theme Documentation', 'latest' ); ?></a>
				<a href="<?php echo esc_url( 'http://uxlthemes.com/forums/forum/latest/' ); ?>" target="_blank"><?php esc_html_e( 'Theme Support', 'latest' ); ?></a>
				<a href="<?php echo esc_url( 'http://wordpress.org/support/theme/latest/reviews/?filter=5' ); ?>" target="_blank"><?php esc_html_e( 'Rate this theme', 'latest' ); ?></a>
			</p>
		</div>
		<hr>

		<div id="getting-started">

			<h3><?php printf( esc_html__( 'Getting Started with %s', 'latest' ), esc_html( $theme->get( 'Name' ) ) ); ?></h3>

			<div class="columns-wrapper clearfix">

				<div class="column column-half clearfix">

					<div class="section">
						<h4><?php esc_html_e( 'Theme Documentation', 'latest' ); ?></h4>

						<p class="about">
							<?php esc_html_e( 'Do you need help to setup, configure and customize this theme? Check out the extensive theme documentation on our website.', 'latest' ); ?>
						</p>
						<p>
							<a href="<?php echo esc_url( 'http://uxlthemes.com/docs/latest-theme/' ); ?>" target="_blank" class="button button-secondary">
								<?php printf( esc_html__( 'View %s Documentation', 'latest' ), 'Latest' ); ?>
							</a>
						</p>
					</div>

					<div class="section">
						<h4><?php esc_html_e( 'Theme Options', 'latest' ); ?></h4>

						<p class="about">
							<?php printf( esc_html__( '%s makes use of the Customizer for the theme settings.', 'latest' ), esc_html( $theme->get( 'Name' ) ) ); ?>
						</p>
						<p>
							<a href="<?php echo esc_url( wp_customize_url() ); ?>" class="button button-primary">
								<?php esc_html_e( 'Customize Theme', 'latest' ); ?>
							</a>
						</p>
					</div>

					<div class="section">
						<h4><?php esc_html_e( 'Primary Categories', 'latest' ); ?></h4>

						<p class="about">
							<?php esc_html_e( 'The theme is optimized to work with the Easy Primary Category plugin.', 'latest' ) ; ?>
						</p>
						<p class="about">
							<?php esc_html_e( 'With the plugin installed and activated, you can select a primary category for those posts with more than one category. If you do not install the plugin, the first category (alphabetically ordered) of the post will be used as the primary category.', 'latest' ) ; ?>
						</p>
					</div>

				</div>

				<div class="column column-half clearfix">

					<img src="<?php echo esc_url( get_template_directory_uri() ); ?>/screenshot.png" />

				</div>

			</div>

		</div>

		<hr>

		<div id="theme-author">

			<p>
				<?php printf( esc_html__( '%1$s is proudly brought to you by %2$s. If you like this theme, %3$s :)', 'latest' ), esc_html( $theme->get( 'Name' ) ), '<a target="_blank" href="http://uxlthemes.com/" title="uXL Themes">uXL Themes</a>', '<a target="_blank" href="http://wordpress.org/support/theme/latest/reviews/?filter=5" title="' . esc_html__( 'Latest Review', 'latest' ) . '">' . esc_html__( 'rate it', 'latest' ) . '</a>' ); ?>
			</p>

		</div>

	</div>

	<?php
}

// Add CSS for Theme help Panel.
add_action( 'admin_enqueue_scripts', 'latest_theme_help_page_css' );

function latest_theme_help_page_css( $hook ) {

	// Load styles and scripts only on theme help page.
	if ( 'appearance_page_latest' != $hook ) {
		return;
	}

	// Embed theme help css style.
	wp_enqueue_style( 'latest-theme-help-css', get_template_directory_uri() . '/css/theme-help.css' );
}
