<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Definite_Lite
 */
 
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?>

<?php $definite_lite_blog_layout = get_theme_mod( 'definite_lite_blog_layout', 'default' );	
		switch ( esc_attr($definite_lite_blog_layout ) ) {		
	
			case "grid":
			// grid
			echo '<li class="grid-item col-lg-6"><article id="post-', the_ID(), '"', esc_attr(post_class()), '>';
			if ( false == esc_attr(get_theme_mod( 'definite_lite_show_summary_image', false ) ) ) {
				definite_lite_post_thumbnail();
			}	
			echo '<div class="post-content"><header class="post-header">';
				the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );			
			if ( false == esc_attr(get_theme_mod( 'definite_lite_show_summary_meta', false ) ) ) {
				definite_lite_summary_meta();
			}			
			echo '</header>';
			
				the_excerpt();
	
			echo '</div></article></li>';				
			break;				
			
		default:
			// default blog
			echo '<article id="post-', the_ID(), '"', esc_attr(post_class()), '>';
			if ( false == esc_attr(get_theme_mod( 'definite_lite_show_summary_image', false ) ) ) {
				definite_lite_post_thumbnail();
			}		
			echo '<div class="post-content"><header class="post-header">';
			
			if ( false == esc_attr(get_theme_mod( 'definite_lite_show_featured_label', false ) ) ) {
			definite_lite_sticky_entry_post();
			}
			
			the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );						
			if ( false == esc_attr(get_theme_mod( 'definite_lite_show_summary_meta', false ) ) ) {
				definite_lite_summary_meta();
			}				
			echo '</header>';
			
			// default summary or excerpt
			$definite_lite_blog_content = get_theme_mod( 'definite_lite_blog_content', 'excerpt' );
			if ( 'excerpt' === $definite_lite_blog_content ) {
				the_excerpt();				
			} else {	
				/* translators: %s: Name of current post */
				the_content();
			}	

			definite_lite_multipage_navigation();
			echo '</div></article>';
		}
	?>
