<?php
/**
 * Single post partial template.
 * @package Definite_Lite
 */
 
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>


    <div class="post-content">

        <header class="post-header">
            <?php  if (get_theme_mod( 'definite_lite_show_default_post_title_group', true ) ) {				
				the_title( '<h1 class="entry-title">', '</h1>' ); 			
				if ( false == esc_attr(get_theme_mod( 'definite_lite_show_single_meta', false ) ) ) {
					definite_lite_single_entry_meta();
				}						
			} 
			?>
        </header>

        <div class="entry-content clearfix">
            <?php the_content(); ?>
        </div>

        <footer class="entry-footer">

            <?php 
			
			if ( false == esc_attr(get_theme_mod( 'definite_lite_footer_categories', false ) ) ) {
				definite_lite_categories();
			}
			
			if ( false == esc_attr(get_theme_mod( 'definite_lite_footer_tags', false ) ) && has_tag() ) {
				echo '<p id="post-tags">', esc_html(definite_lite_entry_tags()), '</p>';
			}
			
			if ( false == esc_attr(get_theme_mod( 'definite_lite_display_author_bio', false ) ) ) {
				get_template_part( 'author-bio' ); 
			}		
			
			if ( false == esc_attr(get_theme_mod( 'definite_lite_post_navigation', false ) ) ) {
				definite_lite_post_navigation(); 
			}	
			
			if( false == esc_attr(get_theme_mod( 'definite_lite_show_related_posts', false ) ) ) {
				get_template_part( 'inc/related-posts' );
			}


			?>

        </footer>

        <?php // If comments are open or we have at least one comment, load up the comment template.
			comments_template(); 
		?>

    </div>
</article>
