<?php
/**
 * Displays the post summary meta
 */
if ( ! function_exists( 'definite_lite_summary_meta' ) ) :

	function definite_lite_summary_meta() {

		echo '<ul class="post-details">' ;	

			if ( false == esc_attr(get_theme_mod( 'definite_lite_show_summary_format', false ) ) ) {
				definite_lite_post_format();
			}			
			if ( false == esc_attr(get_theme_mod( 'definite_lite_show_summary_author', false ) ) ) {
				definite_lite_posted_by();
			}		
			if ( false == esc_attr(get_theme_mod( 'definite_lite_show_summary_date', false ) ) ) {
				definite_lite_posted_on();
			}					
			if ( false == esc_attr(get_theme_mod( 'definite_lite_show_summary_category', false ) ) ) {
				definite_lite_summary_first_category();
			}			
			if ( false == esc_attr(get_theme_mod( 'definite_lite_show_summary_comments', false ) ) ) {
				definite_lite_comment_count();
			}	
			if ( false == esc_attr(get_theme_mod( 'definite_lite_show_edit', false ) ) ) {
				definite_lite_edit_link();
			}	
		
		echo '</ul>';
	}
endif;

/**
 * Displays the date and author of a post summary
 */
if ( ! function_exists( 'definite_lite_entry_meta' ) ) :

	function definite_lite_entry_meta() {

		echo '<ul class="post-details">' ;	

			if ( false == esc_attr(get_theme_mod( 'definite_lite_show_summary_format', false ) ) ) {
				definite_lite_post_format();
			}			
			if ( false == esc_attr(get_theme_mod( 'definite_lite_show_summary_author', false ) ) ) {
				definite_lite_posted_by();
			}		
			if ( false == esc_attr(get_theme_mod( 'definite_lite_show_summary_date', false ) ) ) {
				definite_lite_posted_on();
			}					
			if ( false == esc_attr(get_theme_mod( 'definite_lite_show_summary_comments', false ) ) ) {
				definite_lite_comment_count();
			}	
			if ( false == esc_attr(get_theme_mod( 'definite_lite_show_edit', false ) ) ) {
				definite_lite_edit_link();
			}	

		echo '</ul>';
	}
endif;

/**
 * Displays the date and author of a full post
 */
if ( ! function_exists( 'definite_lite_single_entry_meta' ) ) :

	function definite_lite_single_entry_meta() {

		echo '<ul class="post-details">' ;	
		
			if ( false == esc_attr(get_theme_mod( 'definite_lite_show_single_author', false ) ) ) {
				definite_lite_posted_by();
			}		
			if ( false == esc_attr(get_theme_mod( 'definite_lite_show_single_date', false ) ) ) {
				definite_lite_posted_on();
			}					
			if ( false == esc_attr(get_theme_mod( 'definite_lite_show_single_comments', false ) ) ) {
				definite_lite_comment_count();
			}	
			if ( false == esc_attr(get_theme_mod( 'definite_lite_show_edit', false ) ) ) {
				definite_lite_edit_link();
			}
			
		echo '</ul>';
	}
endif;



// Show the post format label
if ( ! function_exists( 'definite_lite_post_format' ) ) :
	// Returns the post date
	function definite_lite_post_format() {
		
		$format = get_post_format();
		if ( current_theme_supports( 'post-formats', $format ) ) {		
			printf( '<li class="post-format"><a href="%1$s">%2$s</a></li>',
				esc_url( get_post_format_link( $format ) ),
				esc_html(get_post_format_string( $format ))
			);
		}
	}
endif;


if ( ! function_exists( 'definite_lite_posted_on' ) ) :
	// Returns the post date
	function definite_lite_posted_on() {

		$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
		if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
			$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
		}

		$time_string = sprintf( $time_string,
			esc_attr( get_the_date( DATE_W3C ) ),
			esc_html( get_the_date() ),
			esc_attr( get_the_modified_date( DATE_W3C ) ),
			esc_html( get_the_modified_date() )
		);
		
		$posted_on = sprintf(
			/* translators: %s: post date */
		__( '<span class="screen-reader-text">Posted on</span> %s', 'definite-lite' ),
		'<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . $time_string . '</a>' );

		echo '<li class="posted-on meta-date">' . $posted_on . '</li>'; 	
	}
endif;

if ( ! function_exists( 'definite_lite_posted_by' ) ) :
	/**
	 * Prints HTML with meta information about theme author.
	 */
	function definite_lite_posted_by() {
		printf(
			'<li class="byline"><span class="postauthor">%1$s </span><span class="author vcard"><a class="url fn n" href="%2$s">%3$s</a></span></li>',
			esc_html__( 'by', 'definite-lite' ),
			esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
			esc_html( get_the_author() )
		);
	}
endif;

if ( ! function_exists( 'definite_lite_comment_count' ) ) :
	/**
	 * Prints HTML with the comment count for the current post.
	 */
	function definite_lite_comment_count() {
		if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
			echo '<li class="comments-link">';
			/* translators: %s: Name of current post. Only visible to screen readers. */
			comments_popup_link( sprintf( __( 'Leave a comment<span class="screen-reader-text"> on %s</span>', 'definite-lite' ), get_the_title() ) );

			echo '</li>';
		}
	}
endif;

if ( ! function_exists( 'definite_lite_edit_link' ) ) :
	function definite_lite_edit_link() {
		edit_post_link(
			sprintf(
				/* translators: %s: Name of current post */
				__( 'Edit<span class="screen-reader-text">%s</span>', 'definite-lite' ),
				get_the_title()
			),
			'<li class="edit-link">',
			'</li>'
		);
	}
	
endif;

if ( ! function_exists( 'definite_lite_sticky_entry_post' ) ) :
	// Returns the sticky label
	function definite_lite_sticky_entry_post() {         
				if ( is_sticky() && ! is_paged() ) { 
					echo '<div class="featured-label">', esc_html_e('Featured', 'definite-lite'), '</div>';
				}
	}
endif;


// Displays the featured image caption on the image
if ( ! function_exists( 'definite_lite_featured_image_caption' ) ) :
function definite_lite_featured_image_caption() {
	
				$get_description = get_post(get_post_thumbnail_id())->post_excerpt;
				  if(!empty($get_description)  ) {
					  // If caption exists - show it
					 echo '<figcaption class="featured-caption">' . esc_html($get_description) . '</figcaption>';
				  }
	}
endif;


	/**
	 * Displays an optional post thumbnail.
	 *
	 * Wraps the post thumbnail in an anchor element on index views, or a div
	 * element when on single views.
	 */
if ( ! function_exists( 'definite_lite_post_thumbnail' ) ) :

	function definite_lite_post_thumbnail() {
		
		if ( is_single() || is_page()) :
			?>

<figure class="post-thumbnail">
    <?php 
			the_post_thumbnail(); 
			
			if ( false == esc_attr(get_theme_mod( 'definite_lite_show_single_image_caption', false ) ) && is_single() ) {
				definite_lite_featured_image_caption();
			}
			
			if ( false == esc_attr(get_theme_mod( 'definite_lite_show_page_image_caption', false ) ) && is_page() ) {		
				definite_lite_featured_image_caption();		
			}
			?>
</figure>


<?php
		else :
			$post_thumbnail = get_the_post_thumbnail_url( get_the_ID(), 'post-thumbnail' );
			?>

<figure class="post-thumbnail">

    <a class="wp-post-image-link" href="<?php the_permalink(); ?>" rel="bookmark">

        <?php 
				// Set the post thumbnail based on the blog layout and active cropped thumbnail setting
				$definite_lite_blog_layout = get_theme_mod( 'definite_lite_blog_layout', 'default' );	
				switch ( esc_attr($definite_lite_blog_layout ) ) {
					
				case "grid":
					// grid thumbnail
					if ( has_post_thumbnail() ) {
					the_post_thumbnail( 'definite-lite-grid', array(
						'alt' => the_title_attribute(
							array( 'echo' => false )
						),
					)  	
				);	
				}				
				break;

				default:
					the_post_thumbnail( 'post-thumbnails', array(
						'alt' => the_title_attribute(
							array( 'echo' => false )
						),
					)  	
				);
				}
				?>
    </a>

    <?php // for the blog home page
			if ( false == esc_attr(get_theme_mod( 'definite_lite_show_summary_image_caption', false ) ) ) {			
			definite_lite_featured_image_caption();
			} 
	?>


</figure>

<?php
		endif; // End is_singular().
	}
endif;


if ( ! function_exists( 'definite_lite_blog_title_group' ) ) :
	/**
	 * Show a custom blog home title and introduction.
	 * Displays the archive title and archive description for the blog index
	 */
	function definite_lite_blog_title_group() {

		// Get blog title and descripton from database.
		$definite_lite_blog_title = get_theme_mod( 'definite_lite_blog_title' );
		$definite_lite_blog_description = get_theme_mod( 'definite_lite_blog_description' );
		
		// Display Blog Title.
		
		if ( '' !== $definite_lite_blog_title || '' !== $definite_lite_blog_description || is_customize_preview() ) : ?>
<div class="row">
    <header id="page-title-group" class="col-lg-12">

        <?php // Display Blog Title.
				if ( '' !== $definite_lite_blog_title || is_customize_preview() ) : ?>

        <h1 id="blog-title">
            <?php echo wp_kses_post( $definite_lite_blog_title ); ?>
        </h1>

        <?php endif;

				// Display Blog Description.
				if ( '' !== $definite_lite_blog_description || is_customize_preview() ) : ?>

        <p id="blog-description" class="lead">
            <?php echo wp_kses_post( $definite_lite_blog_description ); ?>
        </p>

        <?php endif; ?>

    </header>
</div>
<?php endif;
	}
endif;



// Get the full category list for a post
if ( ! function_exists( 'definite_lite_categories' ) ) :
function definite_lite_categories() {
	echo '<p id="post-categories">', esc_html_e( 'Categories: ', 'definite-lite' ) .  the_category(' &bull; ') .'</p>';
	}
endif;

// Get just the first category name of a post
function definite_lite_summary_first_category() {
	if ( 'post' === get_post_type() ) {
		$cats = get_the_category();
		echo '<li class="post-category"><span class="post-summary-category-label">', esc_html_e( 'in ', 'definite-lite' ) . '</span><span class="post-summary-category">' . esc_html( $cats[0]->name ) . '</span></li>';
	}
}

// Get just the first category name of a post
function definite_lite_first_category() {
	if ( 'post' === get_post_type() ) {
		$cats = get_the_category();
		echo '<div class="post-category">' . esc_html( $cats[0]->name ) . '</div>';
	}
}

/**
 * Displays the post tags on single post view
 */
if ( ! function_exists( 'definite_lite_entry_tags' ) ) :
	function definite_lite_entry_tags() {	 
				$tags_list = get_the_tag_list( '', esc_html_x( ', ', 'list item separator', 'definite-lite' ) );
			if ( $tags_list ) {
				/* translators: 1: list of tags. */
				printf( '<span class="tags-links">' . esc_html__( 'Tags: %1$s', 'definite-lite' ) . '</span>', $tags_list ); 
			}	
	}
endif;


/**
 * Displays pagination on the blog and archive pages
 */
if ( ! function_exists( 'definite_lite_blog_navigation' ) ) :

	function definite_lite_blog_navigation() {

		the_posts_pagination( array(
			'mid_size'  => 2,
			'prev_text' => '<span class="nav-arrow">&laquo</span><span class="screen-reader-text">' . esc_html_x( 'Previous Posts', 'pagination', 'definite-lite' ) . '</span>',
			'next_text' => '<span class="screen-reader-text">' . esc_html_x( 'Next Posts', 'pagination', 'definite-lite' ) . '</span><span class="nav-arrow">&raquo;</span>',
		) );
	}
endif;

/**
 * Displays Single Post Navigation
 */
if ( ! function_exists( 'definite_lite_post_navigation' ) ) :

	function definite_lite_post_navigation() {

			the_post_navigation( array(
				'prev_text' => '<span class="nav-link-text">' . esc_html_x( 'Previous Post', 'post navigation', 'definite-lite' ) . '</span><h5 class="nav-entry-title">%title</h5>',
				'next_text' => '<span class="nav-link-text">' . esc_html_x( 'Next Post', 'post navigation', 'definite-lite' ) . '</span><h5 class="nav-entry-title">%title</h5>',
			) );
	}
endif;

/**
 * Displays Multi-page Navigation
 */
if ( ! function_exists( 'definite_lite_multipage_navigation' ) ) :

	function definite_lite_multipage_navigation() {
		wp_link_pages( array(
		'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'definite-lite' ),
		'after'  => '</div>',
		'link_before' => '<span class="page-wrap">',
		'link_after' => '</span>',
		) ); 
	}
endif;				


/**
* Display custom archive titles without the labels
*/

 if ( false !== esc_attr(get_theme_mod( 'definite_lite_show_archive_labels', false ) ) ) :
	 
	if ( ! function_exists( 'definite_lite_archive_title' ) ) :

	function definite_lite_archive_title( $before = '', $after = '' ) {
		if ( is_category() ) {
			$title = single_cat_title( '', false );
		} elseif ( is_tag() ) {
			$title = sprintf( 
			/* translators: %s: Name of tag */
			esc_html__( 'Articles with %s', 'definite-lite' ), single_tag_title( '', false ) );
		} elseif ( is_author() ) {
			$title = sprintf( 
			/* translators: %s: Name of author */
			esc_html__( 'Articles by %s', 'definite-lite' ), '<span class="vcard">' . get_the_author() . '</span>' );
		} elseif ( is_year() ) {
			$title = sprintf( 
			/* translators: %s: Name of year */
			esc_html__( 'Articles from %s', 'definite-lite' ), get_the_date( esc_html_x( 'Y', 'yearly archives date format', 'definite-lite' ) ) );
		} elseif ( is_month() ) {
			$title = sprintf( 
			/* translators: %s: Name of month  */
			esc_html__( 'Articles from %s', 'definite-lite' ), get_the_date( esc_html_x( 'F Y', 'monthly archives date format', 'definite-lite' ) ) );
		} elseif ( is_day() ) {
			$title = sprintf( 
			/* translators: %s: Name of day */
			esc_html__( 'Articles from %s', 'definite-lite' ), get_the_date( esc_html_x( 'F j, Y', 'daily archives date format', 'definite-lite' ) ) );
		} elseif ( is_post_type_archive() ) {
			$title = sprintf( 
			/* translators: %s: Name of archive title */
			esc_html__( 'Archives: %s', 'definite-lite' ), post_type_archive_title( '', false ) );
		} elseif ( is_tax( 'post_format' ) ) {
			if ( is_tax( 'post_format', 'post-format-gallery' ) ) {
				$title = esc_html_x( 'Galleries', 'post format archive title', 'definite-lite' );
			} elseif ( is_tax( 'post_format', 'post-format-image' ) ) {
				$title = esc_html_x( 'Images', 'post format archive title', 'definite-lite' );
			} elseif ( is_tax( 'post_format', 'post-format-video' ) ) {
				$title = esc_html_x( 'Videos', 'post format archive title', 'definite-lite' );
			} elseif ( is_tax( 'post_format', 'post-format-audio' ) ) {
				$title = esc_html_x( 'Audio', 'post format archive title', 'definite-lite' );
			}		
		} elseif ( is_tax() ) {
			$tax = get_taxonomy( get_queried_object()->taxonomy );
			/* translators: 1: Taxonomy singular name, 2: Current taxonomy term */
			$title = sprintf( 
			/* translators: %s: Name of title  */
			esc_html__( '%1$s: %2$s', 'definite-lite' ), $tax->labels->singular_name, single_term_title( '', false ) );
		} else {
			$title = esc_html__( 'Archives', 'definite-lite' );
		}

		/**
		 * Filter the archive title.
		 * @param string $title Archive title to be displayed.
		 */
		$title = apply_filters( 'definite_lite_archive_title', $title );

		if ( ! empty( $title ) ) {
			echo $before . $title . $after;  
		}
	}
	endif;
endif;