<?php
/**
 * Thumbnail Settings
 * Register Thumbnails section, settings and controls for the Theme Customizer
 * Settings and controls to manage image thumbnail cropping
 *
 * @package Definite_Lite
 */

/**
 * Adds all layout settings to the Customizer
 *
 * @param object $wp_customize / Customizer Object.
 */
function definite_lite_customize_register_thumbnail_settings( $wp_customize ) {

	// Add Section for Theme Options.
	$wp_customize->add_section( 'definite_lite_section_thumbnails', array(
		'title'    => esc_html__( 'Thumbnail Settings', 'definite-lite' ),
		'priority' => 50,
		'panel'    => 'definite_lite_options_panel',
	) );


	// Add Setting and Control for cropping the front page featured image
	$wp_customize->add_setting( 'definite_lite_crop_blog_featured_post', array(
		'default'           => false,
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_crop_blog_featured_post', array(
		'label'    => esc_html__( 'Crop image for the Blog Featured Post.', 'definite-lite' ),
		'section'  => 'definite_lite_section_thumbnails',
		'type'     => 'checkbox',
	) );
	
	// Add Setting and Control for cropping the recent posts thumbnails
	$wp_customize->add_setting( 'definite_lite_crop_recent', array(
		'default'           => false,
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_crop_recent', array(
		'label'    => esc_html__( 'Crop images for the recent posts thumbnails.', 'definite-lite' ),
		'section'  => 'definite_lite_section_thumbnails',
		'type'     => 'checkbox',
	) );	
	
	// Add Setting and Control for cropping Grid featured images on blog and archives.
	$wp_customize->add_setting( 'definite_lite_crop_grid_featured', array(
		'default'           => false,
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_crop_grid_featured', array(
		'label'    => esc_html__( 'Crop featured images for the Grid Blog Layout', 'definite-lite' ),
		'section'  => 'definite_lite_section_thumbnails',
		'type'     => 'checkbox',
	) );	

}
add_action( 'customize_register', 'definite_lite_customize_register_thumbnail_settings' );
