<?php
/**
 * Pro Version Upgrade Section
 *
 * Registers Upgrade Section for the Pro Version of the theme
 *
 * @package Definite_Lite
 */

/**
 * Adds pro version description and CTA button
 * @param object $wp_customize / Customizer Object.
 */
function definite_lite_customize_register_upgrade_settings( $wp_customize ) {

// SECTION - UPGRADE
    $wp_customize->add_section( 'definite_lite_upgrade', array(
        'title'       => esc_html__( 'Upgrade to Pro', 'definite-lite' ),
        'priority'    => 1
    ) );
	
	
	
	// Add custom Upgrade Content control.
		$wp_customize->add_setting( 'definite_lite_upgrade', array(
			'default' => '',
			'sanitize_callback' => '__return_false'
		) );
		
		$wp_customize->add_control( new Definite_Lite_Customize_Static_Text_Control( $wp_customize, 'definite_lite_upgrade', array(
			'label'	=> esc_html__('Get The Pro Version:','definite-lite'),
			'section'	=> 'definite_lite_upgrade',
			'description' => array('')
		) ) );	

}
add_action( 'customize_register', 'definite_lite_customize_register_upgrade_settings' );
 