<?php
/**
 * Page Settings
 *
 * Register Page Settings section, settings and controls for Theme Customizer
 *
 * @package Definite_Lite
 */

/**
 * Adds post settings in the Customizer
 *
 * @param object $wp_customize / Customizer Object.
 */
function definite_lite_customize_register_page_settings( $wp_customize ) {

	// Add Sections for Post Settings.
	$wp_customize->add_section( 'definite_lite_section_page', array(
		'title'    => esc_html__( 'Page Settings', 'definite-lite' ),
		'priority' => 42,
		'panel' => 'definite_lite_options_panel',
	) );

	
	// Add Setting and Control for showing summary image.
	$wp_customize->add_setting( 'definite_lite_show_page_featured_image', array(
		'default'           => false,
		'transport'         => 'postMessage',
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_show_page_featured_image', array(
		'label'    => esc_html__( 'Hide Page Featured Image', 'definite-lite' ),
		'section'  => 'definite_lite_section_page',
		'type'     => 'checkbox',
	) );
	
	// Add Setting and Control for showing summary image caption.
	$wp_customize->add_setting( 'definite_lite_show_page_image_caption', array(
		'default'           => false,
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_show_page_image_caption', array(
		'label'    => esc_html__( 'Hide Page Featured Image Caption', 'definite-lite' ),
		'section'  => 'definite_lite_section_page',
		'type'     => 'checkbox',
	) );	

}
add_action( 'customize_register', 'definite_lite_customize_register_page_settings' );
