<?php
/**
 * Layout Settings
 *
 * Register Layout section, settings and controls for Theme Customizer
 *
 * @package Definite_Lite
 */

/**
 * Adds all layout settings to the Customizer
 *
 * @param object $wp_customize / Customizer Object.
 */
function definite_lite_customize_register_colour_settings( $wp_customize ) {
	
// Accent Colour 
 	$wp_customize->add_setting( 'definite_lite_accent_colour', array(
		'default'        => '#cd4433',
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'         => 'postMessage',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'definite_lite_accent_colour', array(
		'label'   => esc_html__( 'Accent Colour', 'definite-lite' ),
		'description'   => esc_html__( 'This is the main accent colour that is used for the top bar area, button hovers, and links.', 'definite-lite' ),
		'section' => 'colors',
		'settings'   => 'definite_lite_accent_colour',
	) ) );		

// Second Colour
 	$wp_customize->add_setting( 'definite_lite_second_colour', array(
		'default'        => '#3e8cc1',
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'         => 'postMessage',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'definite_lite_second_colour', array(
		'label'   => esc_html__( 'Second Colour', 'definite-lite' ),
		'description'   => esc_html__( 'This is a marine colour that is used for some buttons and the featured image captions.', 'definite-lite' ),
		'section' => 'colors',
		'settings'   => 'definite_lite_second_colour',
	) ) );		

// Third Colour
 	$wp_customize->add_setting( 'definite_lite_third_colour', array(
		'default'        => '#2f3335',
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'         => 'postMessage',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'definite_lite_third_colour', array(
		'label'   => esc_html__( 'Third Colour', 'definite-lite' ),
		'description'   => esc_html__( 'This is a dark grey colour that is used for some buttons and bottom sidebar area.', 'definite-lite' ),
		'section' => 'colors',
		'settings'   => 'definite_lite_third_colour',
	) ) );	
	
// Fourth Colour
 	$wp_customize->add_setting( 'definite_lite_fourth_colour', array(
		'default'        => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'         => 'postMessage',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'definite_lite_fourth_colour', array(
		'label'   => esc_html__( 'Fourth Colour', 'definite-lite' ),
		'description'   => esc_html__( 'This is a white colour; used mostly for text on elements with coloured backgrounds.', 'definite-lite' ),
		'section' => 'colors',
		'settings'   => 'definite_lite_fourth_colour',
	) ) );		

	// Separator 
	$wp_customize->add_setting(	'definite_lite_separator1',	array(
			'sanitize_callback' => 'wp_filter_nohtml_kses',
	) );

	$wp_customize->add_control( new Definite_Lite_Separator_Control( $wp_customize, 'definite_lite_separator1',	array(
				'section' => 'colors',
	)));
		
// Content area background
 	$wp_customize->add_setting( 'definite_lite_content_bg', array(
		'default'        => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'         => 'postMessage',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'definite_lite_content_bg', array(
		'label'   => esc_html__( 'Content Area Background', 'definite-lite' ),
		'section' => 'colors',
		'settings'   => 'definite_lite_content_bg',
	) ) );	
	
// border and line Colours
 	$wp_customize->add_setting( 'definite_lite_line_colour', array(
		'default'        => '#dedede',
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'         => 'postMessage',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'definite_lite_line_colour', array(
		'label'   => esc_html__( 'Border and Line  Colours', 'definite-lite' ),
		'section' => 'colors',
		'settings'   => 'definite_lite_line_colour',
	) ) );	

// top social icon colour
 	$wp_customize->add_setting( 'definite_lite_top_social_icon', array(
		'default'        => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'         => 'postMessage',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'definite_lite_top_social_icon', array(
		'label'   => esc_html__( 'Top Social Icon Colour', 'definite-lite' ),
		'section' => 'colors',
		'settings'   => 'definite_lite_top_social_icon',
	) ) );		
	
// menu toggle icon
 	$wp_customize->add_setting( 'definite_lite_toggle_icon', array(
		'default'        => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'         => 'postMessage',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'definite_lite_toggle_icon', array(
		'label'   => esc_html__( 'Mobile Toggle Menu Icon', 'definite-lite' ),
		'section' => 'colors',
		'settings'   => 'definite_lite_toggle_icon',
	) ) );	
	
// main body text
 	$wp_customize->add_setting( 'definite_lite_body_text', array(
		'default'        => '#484848',
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'         => 'postMessage',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'definite_lite_body_text', array(
		'label'   => esc_html__( 'Body Text Colour', 'definite-lite' ),
		'section' => 'colors',
		'settings'   => 'definite_lite_body_text',
	) ) );		

// headings and titles
 	$wp_customize->add_setting( 'definite_lite_headings', array(
		'default'        => '#262626',
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'         => 'postMessage',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'definite_lite_headings', array(
		'label'   => esc_html__( 'Headings and Titles', 'definite-lite' ),
		'section' => 'colors',
		'settings'   => 'definite_lite_headings',
	) ) );	
	
// main menu link colour
 	$wp_customize->add_setting( 'definite_lite_menu_link_colour', array(
		'default'        => '#262626',
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'         => 'postMessage',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'definite_lite_menu_link_colour', array(
		'label'   => esc_html__( 'Menu Link Colour', 'definite-lite' ),
		'section' => 'colors',
		'settings'   => 'definite_lite_menu_link_colour',
	) ) );	

// main menu link hover colour
 	$wp_customize->add_setting( 'definite_lite_menu_link_hover_colour', array(
		'default'        => '#cd4433',
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'         => 'postMessage',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'definite_lite_menu_link_hover_colour', array(
		'label'   => esc_html__( 'Menu Link Colour [hover]', 'definite-lite' ),
		'section' => 'colors',
		'settings'   => 'definite_lite_menu_link_hover_colour',
	) ) );	
	
	
// main submenu background
 	$wp_customize->add_setting( 'definite_lite_submenu_bg', array(
		'default'        => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'         => 'postMessage',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'definite_lite_submenu_bg', array(
		'label'   => esc_html__( 'Main Submenu Background', 'definite-lite' ),
		'section' => 'colors',
		'settings'   => 'definite_lite_submenu_bg',
	) ) );
	
// main submenu link colour
 	$wp_customize->add_setting( 'definite_lite_submenu_link_colour', array(
		'default'        => '#262626',
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'         => 'postMessage',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'definite_lite_submenu_link_colour', array(
		'label'   => esc_html__( 'Main Submenu Link Colour', 'definite-lite' ),
		'section' => 'colors',
		'settings'   => 'definite_lite_submenu_link_colour',
	) ) );
	
// Page Intro text
 	$wp_customize->add_setting( 'definite_lite_intro_text', array(
		'default'        => '#9a9a9a',
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'         => 'postMessage',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'definite_lite_intro_text', array(
		'label'   => esc_html__( 'Page Sub Header Text', 'definite-lite' ),
		'description'   => esc_html__( 'This is for the blog, archive, and page intro text.', 'definite-lite' ),
		'section' => 'colors',
		'settings'   => 'definite_lite_intro_text',
	) ) );	
	
// bottom text colour
 	$wp_customize->add_setting( 'definite_lite_bottom_text', array(
		'default'        => '#ccc',
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'         => 'postMessage',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'definite_lite_bottom_text', array(
		'label'   => esc_html__( 'Bottom Area Text Colour', 'definite-lite' ),
		'section' => 'colors',
		'settings'   => 'definite_lite_bottom_text',
	) ) );	

// Bottom widget titles
 	$wp_customize->add_setting( 'definite_lite_bottom_widget_titles', array(
		'default'        => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'         => 'postMessage',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'definite_lite_bottom_widget_titles', array(
		'label'   => esc_html__( 'Bottom Area Widget Titles', 'definite-lite' ),
		'section' => 'colors',
		'settings'   => 'definite_lite_bottom_widget_titles',
	) ) );	

// Footer background
 	$wp_customize->add_setting( 'definite_lite_footer_bg', array(
		'default'        => '#202325',
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'         => 'postMessage',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'definite_lite_footer_bg', array(
		'label'   => esc_html__( 'Footer Background', 'definite-lite' ),
		'section' => 'colors',
		'settings'   => 'definite_lite_footer_bg',
	) ) );	

// Footer text icons
 	$wp_customize->add_setting( 'definite_lite_footer_text_icons', array(
		'default'        => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'         => 'postMessage',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'definite_lite_footer_text_icons', array(
		'label'   => esc_html__( 'Footer Text and Social Icons', 'definite-lite' ),
		'section' => 'colors',
		'settings'   => 'definite_lite_footer_text_icons',
	) ) );	

	// Select text background
 	$wp_customize->add_setting( 'definite_lite_select_text', array(
		'default'        => '#3e8cc1',
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'         => 'postMessage',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'definite_lite_select_text', array(
		'label'   => esc_html__( 'Selected Text Background', 'definite-lite' ),
		'section' => 'colors',
		'settings'   => 'definite_lite_select_text',
	) ) );	
	
}
add_action( 'customize_register', 'definite_lite_customize_register_colour_settings' );
