<?php
/**
 * Implement theme options in the Customizer
 *
 * @package Definite_Lite
 */

/**
 * Registers Theme Options panel and sets up some WordPress core settings
 * @param object $wp_customize / Customizer Object.
 */
function definite_lite_customize_register_options( $wp_customize ) {

	// Add Theme Options Panel.
	$wp_customize->add_panel( 'definite_lite_options_panel', array(
		'priority'       => 30,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => esc_html__( 'Theme Options', 'definite-lite' ),
	) );

	// Change default background section.
	$wp_customize->get_control( 'background_color' )->section   = 'background_image';
	$wp_customize->get_section( 'background_image' )->title     = esc_html__( 'Page Background', 'definite-lite' );

	// Add postMessage support for site title and description so we can preview changes instantly.
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';

	// Add selective refresh for site title and description.
	$wp_customize->selective_refresh->add_partial( 'blogname', array(
		'selector'        => '#site-title',
		'render_callback' => 'definite_lite_customize_partial_blogname',
	) );
	$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
		'selector'        => '#site-description',
		'render_callback' => 'definite_lite_customize_partial_blogdescription',
	) );
	
	// Add Display Site Title Setting.
	$wp_customize->add_setting( 'definite_lite_show_site_title', array(
		'default'           => false,
		'transport'         => 'postMessage',
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_show_site_title', array(
		'label'    => esc_html__( 'Hide Site Title', 'definite-lite' ),
		'section'  => 'title_tagline',
		'type'     => 'checkbox',
	) );

	// Add Display Tagline Setting.
	$wp_customize->add_setting( 'definite_lite_show_site_desc', array(
		'default'           => false,
		'transport'         => 'postMessage',
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_show_site_desc', array(
		'label'    => esc_html__( 'Hide Site Tagline', 'definite-lite' ),
		'section'  => 'title_tagline',
		'type'     => 'checkbox',
	) );	
	
	
// Site Title Colour
 	$wp_customize->add_setting( 'definite_lite_sitetitle_colour', array(
		'default'        => '#000',
		'transport'      => 'postMessage',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'definite_lite_sitetitle_colour', array(
		'label'   => esc_html__( 'Site Title Colour', 'definite-lite' ),
		'section' => 'title_tagline',
		'settings'   => 'definite_lite_sitetitle_colour',
	) ) );		
	
// Site desc Colour
 	$wp_customize->add_setting( 'definite_lite_tagline_colour', array(
		'default'        => '#9a9a9a',
		'transport'      => 'postMessage',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'definite_lite_tagline_colour', array(
		'label'   => esc_html__( 'Site Tagline Colour', 'definite-lite' ),
		'section' => 'title_tagline',
		'settings'   => 'definite_lite_tagline_colour',
	) ) );		
	
	
	
	
	
}
add_action( 'customize_register', 'definite_lite_customize_register_options' );



/**
 * Render the site title for the selective refresh partial.
 */
function definite_lite_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 */
function definite_lite_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Embed JS file to make Theme Customizer preview reload changes asynchronously.
 */
function definite_lite_customize_preview_js() {
	wp_enqueue_script( 'definite-lite-customize-preview', get_template_directory_uri() . '/assets/js/customizer.js', array( 'customize-preview' ), null, true );
}
add_action( 'customize_preview_init', 'definite_lite_customize_preview_js' );

/**
 * Embed JS for Customizer Controls.
 */
function definite_lite_customizer_controls_js() {
	wp_enqueue_script( 'definite-lite-customizer-controls', get_template_directory_uri() . '/assets/js/customizer-controls.js', array(), null, true );
}
add_action( 'customize_controls_enqueue_scripts', 'definite_lite_customizer_controls_js' );

/**
 * Embed CSS styles Customizer Controls.
 */
function definite_lite_customizer_controls_css() {
	wp_enqueue_style( 'definite-lite-customizer-controls', get_template_directory_uri() . '/assets/css/customizer-controls.css', array(), null );
}
add_action( 'customize_controls_print_styles', 'definite_lite_customizer_controls_css' );
