<?php
/**
 * The header for our theme
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 * @package Definite_Lite
 */
?><!doctype html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">

    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

    <div id="top-bar-wrapper">
        <div id="top-bar" class="d-flex">
		
		
            <?php 
				if ( has_nav_menu( 'top-social' ) ) : 									
						wp_nav_menu( array(
							'theme_location' => 'top-social',
							'container' => false,
							'menu_class' => 'social-menu',
							'echo' => true,
							'fallback_cb' => '',
							'link_before' => '<span class="screen-reader-text social-icon-label">',
							'link_after' => '</span>',
							'depth' => 1,
							)
						);
			 endif; ?>

        </div>
    </div>

    <div id="page" class="site">

        <a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'definite-lite' ); ?></a>

<header id="site-header">
        <div class="container">
            <div class="row align-items-center">
                <div id="site-branding" class="col-lg-4">
				<?php echo csl_CustomSiteLogo_show_logo(); ?>
                
                <?php if ( has_custom_logo() ) : ?>
                <?php the_custom_logo(); ?>
                <?php endif; ?>

                <?php if (is_front_page() && false == esc_attr(get_theme_mod( 'definite_lite_show_site_title', false ) ) ) : ?>
                <h1 id="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
                <?php else : ?>
                <?php if (  false == esc_attr(get_theme_mod( 'definite_lite_show_site_title', false ) ) ) : ?>
                <p id="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
                <?php	endif;  ?>
                <?php endif; ?>

                <?php	if (  false == esc_attr(get_theme_mod( 'definite_lite_show_site_desc', false ) ) ) :
				$definite_lite_description = get_bloginfo( 'description', 'display' );
					if ( $definite_lite_description || is_customize_preview() ) : ?>
                <p id="site-description"><?php echo esc_html($definite_lite_description); ?></p>
                <?php 
					endif;
					endif; ?>				
				
                </div>


                <nav id="main-navigation" class="primary-navigation col-lg-8">
                    <?php
						// Display Main Navigation.
						wp_nav_menu( array(
							'theme_location' => 'primary',
							'container' => false,
							'menu_class' => 'main-navigation-menu',
							'echo' => true,
							'fallback_cb' => 'definite_lite_fallback_menu',
							)
						);
					?>
                </nav>
            </div>
        </div>
 </header>
 
        <?php get_template_part( 'template-parts/sidebars/sidebar', 'banner' ); ?>

        <div id="content" class="site-content container">

            <?php if (!is_front_page() ) {
				get_template_part( 'template-parts/sidebars/sidebar', 'breadcrumbs' ); 
				}
			?>

            <?php if ( has_post_thumbnail() && false == esc_attr(get_theme_mod( 'definite_lite_show_single_image', false ) ) && is_single() )  : ?>
            <figure class="single-featured-image col-lg-12" style="background-image:url('<?php echo esc_url( get_the_post_thumbnail_url() ) ?>');">
                <?php if ( false == esc_attr(get_theme_mod( 'definite_lite_show_single_image_caption', false ) ) ) {			
						definite_lite_featured_image_caption();
						} 
				?>
            </figure>
            <?php 
			endif; 
			?>

            <?php get_template_part( 'template-parts/heading-titles' ); ?>
