<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Definite_Lite
 */
?>

</div><!-- #content -->

</div><!-- #page -->


<?php get_template_part( 'template-parts/sidebars/sidebar', 'bottom' ); ?>
<?php get_template_part( 'template-parts/sidebars/sidebar' , 'cbottom' ); ?>

<footer id="site-footer">
    <div id="footer-content" class="container">
        <div class="row align-items-center">

            <div id="footer-copyright" class="col-lg-7">

                <?php get_template_part( 'template-parts/sidebars/sidebar', 'footer' ); ?>

                <?php if ( has_nav_menu( 'footer' ) ) {
	 echo '<nav id="footer-nav"> ';
		 wp_nav_menu( array( 
				'theme_location' => 'footer', 
				'fallback_cb' => false, 
				'depth' => 1,
				'container' => false, 
				'menu_id' => 'footer-menu', 
			) ); 
		echo '</nav>';
		}
		?>

                <?php esc_html_e('Copyright &copy;', 'definite-lite'); ?>
                <?php echo date_i18n( _x( 'Y', 'copyright date format', 'definite-lite' ) ); ?>
                <span id="copyright-name">
                    <?php echo esc_html(get_theme_mod( 'definite_lite_copyright' )); ?></span>.
                <?php esc_html_e('All rights reserved.', 'definite-lite'); ?>
            </div>

            <nav id="footer-social-menu" class="col-lg-5">
                <?php 
				if ( has_nav_menu( 'bottom-social' ) ) : 									
						wp_nav_menu( array(
							'theme_location' => 'bottom-social',
							'container' => false,
							'menu_class' => 'social-menu',
							'echo' => true,
							'fallback_cb' => '',
							'link_before' => '<span class="screen-reader-text social-icon-label">',
							'link_after' => '</span>',
							'depth' => 1,
							)
						);
				 endif; ?>
            </nav>

        </div>

    </div>
</footer>

</div><!-- #page -->

<?php wp_footer(); ?>

</body>

</html>
