<?php 

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
*/

if ( post_password_required() ) {
	return;
}

if ( $comments ) : ?>

<div class="comments" id="comments">
    <div class="comments-header">

        <h3 class="comment-reply-title">
            <?php
			$comments_number = absint( get_comments_number() );
			
			if ( ! have_comments() ) {
				esc_html_e( 'Leave a comment', 'definite-lite' );
			} elseif ( '1' === $comments_number ) {
				/* translators: %s: post title */
				printf( esc_html_x( 'One Comment', 'comments title', 'definite-lite' ), esc_html( get_the_title() ) );
			} else {
				echo esc_html(
					sprintf(
						/* translators: 1: number of comments, 2: post title */
						_nx(
							'%1$s Comment',
							'%1$s Comments',
							$comments_number,
							'comments title',
							'definite-lite'
						),
						number_format_i18n( $comments_number ),
						get_the_title()
					)
				);
			}

			?>
        </h3>

    </div><!-- .comments-header -->

    <?php
		echo '<ol class="comment-list">';
		wp_list_comments( array(
			'walker'      	=> new Definite_Lite_Walker_Comment(),
			'avatar_size'	=> 60,
			'style' 		=> 'ol',
		) );
		echo '</ol>';
		$comment_pagination = paginate_comments_links( array(
			'echo'					=> false,
			'end_size'				=> 0,
			'mid_size'				=> 0,
			'next_text' 			=> __( 'Newer Comments', 'definite-lite' ) . ' &rarr;',
			'prev_text' 			=> '&larr; ' . __( 'Older Comments', 'definite-lite' ),
		) );

		if ( $comment_pagination ) :

			// If we're only showing the "Next" link, add a class indicating so
			if ( strpos( $comment_pagination, 'prev page-numbers' ) === false ) {
				$pagination_classes = ' only-next';
			} else {
				$pagination_classes = '';
			}
			?>

    <nav class="comments-pagination pagination<?php echo esc_attr( $pagination_classes ); ?>">
        <?php echo wp_kses_post( $comment_pagination ); ?>
    </nav>

    <?php endif; ?>

</div><!-- comments -->

<?php 
endif;

if ( comments_open() || pings_open() ) :

	comment_form( array(
		'class_form'			=> '',
		'comment_notes_before'	=> '',
		'comment_notes_after'	=> '',
	) );

elseif ( is_single() ) : ?>

<div class="comment-respond" id="respond">

    <p class="comments-closed"><?php esc_html_e( 'Comments are closed.', 'definite-lite' ); ?></p>

</div><!-- #respond -->

<?php endif; ?>
