<?php

if ( class_exists( 'Kirki' ) ) {
	// Kirki fields etc here.

	function kirki_demo_configuration_sample_styling( $config ) {
		return wp_parse_args( array(
			'logo_image'   => 'https://ancientcoders.com/wp-content/uploads/2019/10/ancient-coders-logo.png',
			'description'  => esc_html__( 'Chained is the first theme created by AncientCoders team. Chained was thought to be used in creation on news and magazine websites and also personal blogs. It has an amazing masonry architecture built in and can be used with multiple columnn layouts.', 'chained' ),
		), $config );
	}
	add_filter( 'kirki_config', 'kirki_demo_configuration_sample_styling' );

	// Remove default blogname & blogdescription
	add_action( 'customize_register', 'themename_customize_register' );
	function themename_customize_register($wp_customize) {
		$wp_customize->remove_control( 'blogname');
		$wp_customize->remove_control( 'blogdescription');
	}

	// Config
	Kirki::add_config( 'theme_settings', array(
		'capability'  => 'edit_theme_options',
		'option_type' => 'theme_mod',
	) );

	// Main Theme Settings
	Kirki::add_panel( 'chained_theme_settings', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Settings', 'chained' ),
	    'description' => esc_html__( 'Change the theme settings', 'chained' ),
	) );


	// Customizer Settings
	include get_theme_file_path( '/includes/customizer/elements/customizer-get-pro.php' );
	include get_theme_file_path( '/includes/customizer/elements/customizer-topbar.php' );
	include get_theme_file_path( '/includes/customizer/elements/customizer-header.php' );
	include get_theme_file_path( '/includes/customizer/elements/customizer-loop.php' );
	include get_theme_file_path( '/includes/customizer/elements/customizer-single.php' );
	include get_theme_file_path( '/includes/customizer/elements/customizer-footer.php' );
	include get_theme_file_path( '/includes/customizer/elements/customizer-global.php' );

}
