<?php
/**
 * Header file for the Chained Wordpress theme
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Chained
 * @since Chained 1.0.0
 */

?><!DOCTYPE html>

<html class="no-js" <?php language_attributes(); ?> itemscope itemtype="http://schema.org/WebPage">

	<head>

		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1.0" >

		<link rel="profile" href="https://gmpg.org/xfn/11">

		<?php wp_head(); ?>

	</head>

	<body <?php body_class(); ?>>

		<a class="skip-link screen-reader-text" href="#content"><?php _e( 'Skip to content', 'chained' ); ?>
		</a>

		<div class="body__before"></div>
		
		<div id="page" class="site">

		<?php if ( true == get_theme_mod('chained_show_top_bar', false ) ) {
			echo get_template_part('templates/headers/topbar');
		}
		?>

		<?php
			$header_layout = get_theme_mod('chained_select_header_style', 'style-1');
			get_template_part( 'templates/headers/header', $header_layout ); 
		?>