<?php
/**
 * Custom template tags for this theme.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package probd
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Prints HTML with meta information for the current post-date/time and author.
 */
if ( ! function_exists ( 'probd_posted_on' ) ) {
	function probd_posted_on() {
		$time_string = '<time class="text-muted entry-date published updated" datetime="%1$s">%2$s</time>';
		if ( get_the_time( 'U' ) !== get_the_modified_date() && is_single() ) {
			$time_string = '<time class="text-muted entry-date published" datetime="%1$s">%2$s</time><time class="text-muted updated" datetime="%3$s"> (%4$s) </time>';
		}
		$time_string = sprintf( $time_string,
			esc_attr( get_the_date( 'M d Y' ) ),
			esc_html( get_the_date( 'M d, Y' ) ),
			esc_attr( get_the_modified_date( 'M d Y' ) ),
			esc_html( get_the_modified_date( 'M d, Y' ) )
		);
		$posted_on = apply_filters(
			'probd_posted_on', sprintf(
				'<span class="posted-on">%1$s <a href="%2$s" rel="bookmark">%3$s</a></span>',
				'<i class="fa fa-calendar text-muted"></i>',
				esc_url( get_permalink() ),
				apply_filters( 'probd_posted_on_time', $time_string )
			)
		);
		$byline = apply_filters(
			'probd_posted_by', sprintf(
				'<span class="text-muted ml-2 byline"> %1$s<span class="author vcard"><a class="text-muted url fn n" href="%2$s"> %3$s</a></span></span>',
				$posted_on ? '<i class="fa fa-user text-muted"></i>' : '<i class="fa fa-user"></i>',
				esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
				esc_html( get_the_author() )
			)
		);
		echo $posted_on . $byline; // WPCS: XSS OK.
	}
}


/**
 * Prints HTML with meta information for the categories, tags and comments.
 */
if ( ! function_exists ( 'probd_entry_footer' ) ) {
	function probd_entry_footer() {
		// Hide category and tag text for pages.
		if ( 'post' === get_post_type() ) {
			/* translators: used between list items, there is a space after the comma */
			$categories_list = get_the_category_list( esc_html__( ', ', 'probd' ) );
			if ( $categories_list && probd_categorized_blog() && !is_front_page() && !is_home() ) {
				/* translators: %s: Categories of current post */
				printf( '<span class="text-muted mr-2 cat-links">' .'<i class="fa fa-tag">'.esc_html__( ' %s', 'probd' ).'</i>'. '</span>', $categories_list ); // WPCS: XSS OK.
			}
			/* translators: used between list items, there is a space after the comma */
			$tags_list = get_the_tag_list( '', esc_html__( ', ', 'probd' ) );
			if ( $tags_list && !is_front_page() && !is_home() ) {
				/* translators: %s: Tags of current post */
				printf( '<span class="text-muted tags-links">' .'<i class="fa fa-tags">'.esc_html__( ' %s', 'probd' ).'</i>' . '</span>', $tags_list ); // WPCS: XSS OK.
			}
		}
		if ( ! is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
			comments_popup_link( '<span class="comments-link"><i class="fa fa-comment"></i></span>', '<span class="comments-link">'.esc_html__( '1 ', 'probd' ).'<i class="fa fa-comment"></i></span>', '<span class="comments-link">% <i class="fa fa-comment"></i></span>' );
		}
		edit_post_link(
			sprintf(
				/* translators: %s: Name of current post */
				esc_html__( 'Edit %s', 'probd' ),
				the_title( '<span class="screen-reader-text">"', '"</span>', false )
			),
			'<span class="edit-link ml-4">',
			'</span>'
		);
	}
}

/**
 * Returns true if a blog has more than 1 category.
 *
 * @return bool
 */
if ( ! function_exists ( 'probd_categorized_blog' ) ) {
	function probd_categorized_blog() {
		if ( false === ( $all_the_cool_cats = get_transient( 'probd_categories' ) ) ) {
			// Create an array of all the categories that are attached to posts.
			$all_the_cool_cats = get_categories( array(
				'fields'     => 'ids',
				'hide_empty' => 1,
				// We only need to know if there is more than one category.
				'number'     => 2,
			) );
			// Count the number of categories that are attached to the posts.
			$all_the_cool_cats = count( $all_the_cool_cats );
			set_transient( 'probd_categories', $all_the_cool_cats );
		}
		if ( $all_the_cool_cats > 1 ) {
			// This blog has more than 1 category so components_categorized_blog should return true.
			return true;
		} else {
			// This blog has only 1 category so components_categorized_blog should return false.
			return false;
		}
	}
}

/**
 * Flush out the transients used in probd_categorized_blog.
 */
add_action( 'edit_category', 'probd_category_transient_flusher' );
add_action( 'save_post',     'probd_category_transient_flusher' );

if ( ! function_exists ( 'probd_category_transient_flusher' ) ) {
	function probd_category_transient_flusher() {
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}
		// Like, beat it. Dig?
		delete_transient( 'probd_categories' );
	}
}