<?php
/**
 * @package vt-grid-mag
 * @since 1.0
 */
/**
 *	Custom Logo.
 *-----------------------------------------------------------------*/
if( ! function_exists( 'vt_grid_mag_tags_site_logo' ) ) {
	function vt_grid_mag_tags_site_logo() {
		$logo = esc_url( vt_grid_mag('logo') );
		$name = esc_attr( get_bloginfo( 'name' ) );
		if( !empty( $logo ) ) {
			$site_logo = '<img src="'. $logo .'" alt="'. $name .'" />';
		}
		else {
			$site_logo = $name;
		}

		$site_logo = apply_filters( 'vt_grid_mag_tags_site_logo', $site_logo );

		if( is_home() || is_front_page() ) {
			$attr = 'h1';
		}
		elseif( is_archive() ) {
			$attr = 'h3';
		}
		elseif( is_singular() ) {
			$attr = 'h4';
		}
		else {
			$attr = 'p';
		}

		$output = sprintf( '<%1$s class="site-title"><a href="%2$s" rel="home">%3$s</a></%1$s>', $attr, esc_url( home_url( '/' ) ), $site_logo );
		echo $output;
	}
}

/**
 *	Social Links.
 *-----------------------------------------------------------------*/
if( ! function_exists( 'vt_grid_mag_tags_social_links' ) ) {
	function vt_grid_mag_tags_social_links( $before = '', $after = '', $userID = false, $brand = false, $echo = true ) {
		$social = vt_grid_mag_external_social_links();
		$_icons = '';
		$output = '';

		foreach( $social as $key => $name ) {
			$_url = $userID ? esc_url( get_the_author_meta( $key, $userID ) ) : esc_url( vt_grid_mag( $key ) );
			$_brand = $brand ? '<span>'. $name .'</span>' : '';
			if( $_url ) {
				$_icons .= sprintf( '<a href="%1$s" class="%2$s-link" target="_blank"><i class="fa fa-%2$s"></i>%3$s</a>', $_url, $key, $_brand );
			}
		}

		if( ! empty( $_icons ) ) {
			$output = $before . $_icons . $after;
		}

		if( $echo ) {
			echo $output;
		}
		else {
			return $output;
		}
	}
}

/**
 *	Post formats preview.
 *-----------------------------------------------------------------*/
if( ! function_exists( 'vt_grid_mag_tags_post_preview' ) ) {
	function vt_grid_mag_tags_post_preview() {
		global $post;
		$post_id = $post->ID;
		$output  = '';
		
		// Standard Post / Page.
		if( has_post_thumbnail( $post_id ) ) {
			global $content_width;
			$thumb_src = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), 'full' );
			$width     = is_array( $thumb_src ) ? $thumb_src[1] : 0;
			if( $width >= $content_width ) {
				if( is_singular() ) {
					if( ! vt_grid_mag('hide_featured_image') ) {
						$output = get_the_post_thumbnail( $post_id, 'full' );
					}
				}
				else {
					$layout = vt_grid_mag_external_current_layout();
					$size   = ( 'layout-default' == $layout ) ? 'full' : 'post-thumbnail';
					$output = sprintf( '<a href="%s" class="thumb-link">%s</a>', esc_url( get_permalink( $post_id ) ), get_the_post_thumbnail( $post_id, $size ) );
				}
			}
		}

		// Post Formats.
		$output  = apply_filters( 'vt_grid_mag_post_formats', $post_id, $output );
		if( !empty( $output ) ) {
			printf( '<div class="post-media clearfix">%s</div><!-- .post-media -->', $output );
		}
	}
}

/**
 *	Comment Navigation.
 *-----------------------------------------------------------------*/
if( ! function_exists( 'vt_grid_mag_tags_comment_nav' ) ) {
	function vt_grid_mag_tags_comment_nav() {
		if( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
		?>
		
		<nav class="navigation comment-navigation" role="navigation">
			<div class="nav-links clearfix">
				<?php if( get_previous_comments_link() ) : ?>

				<div class="nav-previous"><?php previous_comments_link( esc_html__( '&larr; Older Comments', 'vt-grid-mag' ) ); ?></div>
				<?php endif; if( get_next_comments_link() ) : ?>

				<div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments &rarr;', 'vt-grid-mag' ) ); ?></div>
				<?php endif; ?>

			</div><!-- .nav-links -->
		</nav><!-- .comment-navigation -->
		<?php
		endif;
	}
}

/**
 * Flush out the transients used in vt_grid_mag_categorized_blog.
 */
function vt_grid_mag_category_transient_flusher() {
	// Like, beat it. Dig?
	delete_transient( 'all_the_cool_cats' );
}
add_action( 'edit_category', 'vt_grid_mag_category_transient_flusher' );
add_action( 'save_post',     'vt_grid_mag_category_transient_flusher' );

/**
 * Footer info, copyright information
 */
if ( ! function_exists( 'vt_grid_mag_footer_copyright' ) ) :
function vt_grid_mag_footer_copyright() {

   $wp_link = '<a href="'.esc_url("http://wordpress.org").'" target="_blank"><span>' . __( 'WordPress', 'vt-grid-mag' ) . '</span></a>';

   $tg_link =  '<a href="'.esc_url("http://volthemes.com/theme/vt-grid-mag/").'" target="_blank"><span>'.__( 'VolThemes', 'vt-grid-mag') .'</span></a>';

   $default_footer_value = sprintf( __( 'Proudly powered by %s', 'vt-grid-mag' ), $wp_link ).' <span class="sep"> | </span> '.sprintf( __( 'Theme: %1$s by %2$s.', 'vt-grid-mag' ), 'VT Grid Mag', $tg_link );

   $vt_grid_mag_footer_copyright = ''.$default_footer_value.'';
   echo $vt_grid_mag_footer_copyright;
}
endif;
add_action( 'vt_grid_mag_footer_copyright', 'vt_grid_mag_footer_copyright', 10 );