<?php
/**
 * @package vt-grid-mag
 * @since 1.0
 */
/**
 *	Disable Jetpack sharing from the excerpt.
 *-----------------------------------------------------------------*/
if( ! function_exists( 'vt_grid_mag_plugins_remove_jetpack_sharing' ) ) {
	function vt_grid_mag_plugins_remove_jetpack_sharing() {
		if( function_exists( 'sharing_display' ) ) {
			remove_filter( 'the_excerpt', 'sharing_display', 19 );
		}
	}
}
add_action( 'init', 'vt_grid_mag_plugins_remove_jetpack_sharing' );


/**
 *	Jetpack infinite scroll config.
 *-----------------------------------------------------------------*/
if( ! function_exists( 'vt_grid_mag_plugins_jetpack_infinite_scroll_setup' ) ) {
	function vt_grid_mag_plugins_jetpack_infinite_scroll_setup() {
		$custom = apply_filters( 'vt_grid_mag_jetpack_infinite_scroll', array() );
		$args   = wp_parse_args( $custom, array(
			  'type'           => 'scroll'
			, 'container'      => 'primary'
			, 'footer'         => 'page'
			, 'render'         => '_vt_grid_mag_jetpack_render_content_to_scroll'
			, 'posts_per_page' => true
		) );

		add_theme_support( 'infinite-scroll', $args );
	}
}
add_action( 'after_setup_theme', 'vt_grid_mag_plugins_jetpack_infinite_scroll_setup' );

/**
 *	Render content for jetpack infinite scroll.
 *-----------------------------------------------------------------*/
if( ! function_exists( '_vt_grid_mag_jetpack_render_content_to_scroll' ) ) {
	function _vt_grid_mag_jetpack_render_content_to_scroll() {
		$layout = vt_grid_mag_external_current_layout();
		while( have_posts() ) {
			the_post();
			if( 'layout-default' != $layout ) {
				get_template_part( 'content', 'grid' );
			}
			else {
				get_template_part( 'content', get_post_format() );
			}
		}
	}
}

/**
 *	Change Jetpack's Infinite Scroll text.
 *-----------------------------------------------------------------*/
function vt_grid_mag_plugins_jetpack_infinite_scroll_load_more_text( $settings ) {
	$settings['text'] = esc_html__( 'Load more', 'vt-grid-mag' );
	return $settings;
}
add_filter( 'infinite_scroll_js_settings', 'vt_grid_mag_plugins_jetpack_infinite_scroll_load_more_text' );

