<?php
/**
 * @package vt-grid-mag
 * @since 1.0
 */
/**
 *	Set social icons.
 *-----------------------------------------------------------------*/
function vt_grid_mag_external_social_links() {
	$args = array(
		  'facebook'     => esc_html__( 'Facebook', 'vt-grid-mag' )
		, 'twitter'      => esc_html__( 'Twitter', 'vt-grid-mag' )
		, 'google-plus'  => esc_html__( 'Google+', 'vt-grid-mag' )
		, 'pinterest'    => esc_html__( 'Pinterest', 'vt-grid-mag' )
		, 'linkedin'     => esc_html__( 'LinkedIn', 'vt-grid-mag' )
		, 'instagram'    => esc_html__( 'Instagram', 'vt-grid-mag' )
		, 'youtube-play' => esc_html__( 'Youtube', 'vt-grid-mag' )
	);

	return apply_filters( 'vt_grid_mag_social_icons', $args );
}

/**
 *	Custom Excerpt lengths.
 *-----------------------------------------------------------------*/
function vt_grid_mag_external_excerpt_lengths( $lengths ) {
	if ( is_admin() ) {
		return $link;
	}
	
	return 20;
}
add_filter( 'excerpt_length', 'vt_grid_mag_external_excerpt_lengths', 98 );

/**
 *	Remove [...] from the excerpt.
 *-----------------------------------------------------------------*/
add_filter( 'excerpt_more', '__return_null' );

/**
 *	Custom more link text from the content.
 *-----------------------------------------------------------------*/
function vt_grid_mag_external_more_link_text( $link, $more_link_text ) {
	if( $more_link_text ) {
		$link = sprintf( '<a href="%s" class="more-link"><span>%s</span></a>', esc_url( get_permalink() ), esc_html__( 'Read more', 'vt-grid-mag' ) );
	}

	return $link;
}
add_filter( 'the_content_more_link', 'vt_grid_mag_external_more_link_text', 10, 2 );

/**
 *	Exclude page type from search results.
 *-----------------------------------------------------------------*/
function vt_grid_mag_external_exclude_page_type( $query ) {
	if( ! is_admin() && $query->is_main_query() && $query->is_search() ) {
		$query->set( 'post_type', array( 'post' ) );
	}
}
add_action( 'pre_get_posts', 'vt_grid_mag_external_exclude_page_type' );

/**
 *	Get current layout options.
 *-----------------------------------------------------------------*/
function vt_grid_mag_external_current_layout() {
	if( is_home() ) {
		$layout = esc_html( vt_grid_mag('home_layout') );
	}
	elseif( is_archive() || is_search() || is_404() ) {
		$layout = esc_html( vt_grid_mag('archive_layout') );
	}
	else {
		$layout = 'layout-default';
	}

	return $layout;
}

/**
 *	Set new content width with current layout.
 *-----------------------------------------------------------------*/
function vt_grid_mag_external_content_width() {
	$layout = vt_grid_mag_external_current_layout();

	if( is_page_template( 'template-fullwidth.php' ) ) {
		$GLOBALS['content_width'] = 980;
	}
	elseif( 'layout-two-columns' == $layout || 'layout-three-columns' == $layout ) {
		$GLOBALS['content_width'] = 300;
	}
	elseif( 'layout-two-columns-fully' == $layout ) {
		$GLOBALS['content_width'] = 470;
	}
}
add_action( 'template_redirect', 'vt_grid_mag_external_content_width' );

/**
 *	Get custom post formats.
 *-----------------------------------------------------------------*/
function vt_grid_mag_external_post_formats( $post_id, $output ) {
	// Video Post.
	if( has_post_format( 'video', $post_id ) && $video = get_post_meta( $post_id, '_format_video_embed', true ) ) {
		if( !empty( $video ) ) {
			$content = do_shortcode( apply_filters( 'the_content', $video ) );
			$media   = get_media_embedded_in_content( $content, array( 'video', 'iframe', 'object', 'embed' ) );
			foreach( $media as $order => $html ) {
				if( strpos( $html, 'video controls="controls"' ) === false ) {
					$output = $html;
					break;
				}
			}
		}
	}

	// Audio Post.
	elseif( has_post_format( 'audio', $post_id ) && $audio = get_post_meta( $post_id, '_format_audio_embed', true ) ) {
		if( !empty( $audio ) ) {
			$content = do_shortcode( apply_filters( 'the_content', $audio ) );
			$media   = get_media_embedded_in_content( $content, array( 'audio', 'iframe', 'object', 'embed' ) );
			foreach( $media as $order => $html ) {
				if( strpos( $html, 'audio controls="controls"' ) === false ) {
					if( strpos( $html, 'wp-audio-shortcode' ) ) {
						$output .= $html;
					}
					else {
						$output = $html;
					}
					break;
				}
			}
		}
	}

	// Gallery Post.
	elseif( has_post_format( 'gallery', $post_id ) && $gallery = get_post_meta( $post_id, '_format_gallery_images', true ) ) {
		if( $gallery ) {
			$_gallery = implode(',', $gallery);
			$_gallery = strip_tags( rtrim( $_gallery, ',') );
			$layout   = vt_grid_mag_external_current_layout();
			$size     = ( 'layout-default' == $layout ) ? 'full' : 'vt-grid-mag-thumbnail';
			$link     = class_exists( 'easyFancyBox' ) ? 'file' : 'none';
			$output   = do_shortcode( '[gallery ids="'. $_gallery .'" link="'. $link .'" size="'. $size .'" columns="1"]' );
		}
	}

	return $output;
}
add_filter( 'vt_grid_mag_post_formats', 'vt_grid_mag_external_post_formats', 10, 2 );

/**
 *	Add custom body classes.
 *-----------------------------------------------------------------*/
function vt_grid_mag_external_body_classes( $classes ) {
	if( ! get_option( 'show_avatars' ) ) {
		$classes[] = 'no-avatars';
	}
	if( is_customize_preview() ) {
		$classes[] = 'site-preview';
	}

	// Header Image.
	if( get_header_image() ) {
		$classes[] = 'header-image';
	}

	// Layout.
	if( is_page_template( 'template-fullwidth.php' ) ) {
		$classes[] = 'full-width';
	}
	else {
		$classes[] = vt_grid_mag_external_current_layout();
		$classes[] = esc_html( vt_grid_mag ('sidebar_position') );
	}

	return $classes;
}
add_filter( 'body_class', 'vt_grid_mag_external_body_classes' );

/**
 *	Custom search form.
 *-----------------------------------------------------------------*/
function vt_grid_mag_external_search_form_modify( $html ) {
	return str_replace( 'placeholder="'. esc_html__( 'Search &hellip;', 'vt-grid-mag' ) .'"', 'placeholder="'. esc_html__( 'Search and hit enter &hellip;', 'vt-grid-mag' ) .'"', $html );
}
add_filter( 'get_search_form', 'vt_grid_mag_external_search_form_modify' );

/**
 *	Header Image.
 *-----------------------------------------------------------------*/
function vt_grid_mag_external_output_custom_header_image( $output ) {
	if( get_header_image() ) {
		$output .= '.site-header { background-image: url("'. esc_url(get_header_image()) .'"); }';
										            
	}

	return $output;
}
add_filter( 'vt_grid_mag_customizer_css_output', 'vt_grid_mag_external_output_custom_header_image' );