<?php
/**
 *	@package vt-grid-mag
 *	@since 1.0
 */
function vt_grid_mag_customizer_social_links( $options ) {
	/**
	 *	Add section.
	 *--------------------------------------------------------------*/
	$options[] = array(
		  'slug'        => 'social_section'
		, 'opt_type'    => 'section'
		, 'name'        => esc_html__( 'Social Links', 'vt-grid-mag' )
		, 'description' => esc_html__( 'Define your social links. Only those filled will appear. Do not forget http://', 'vt-grid-mag' )
		, 'priority'    => 32
	);

	/**
	 *	Add controls.
	 *--------------------------------------------------------------*/
	$social  = vt_grid_mag_external_social_links();
	foreach( $social as $key => $name ) {
		$options[] = array(
			  'slug'        => $key
			, 'opt_type'    => 'url'
			, 'name'        => $name
			, 'default'     => ''
			, 'sanitize_callback'     => 'esc_url_raw'
			, 'section'     => 'social_section'
		);
	}


	return $options;
}
add_filter( 'vt_grid_mag_settings_input', 'vt_grid_mag_customizer_social_links' );