<?php
/**
 * @package vt-grid-mag
 * @since 1.0
 */
function vt_grid_mag_customizer_add_colors( $options ) {
	/**
	 *	Add section.
	 *---------------------------------------------------------*/
	$options[] = array(
		  'slug'        => 'colors'
		, 'opt_type'    => 'section'
		, 'name'        => esc_html__( 'Colors', 'vt-grid-mag' )
		, 'priority'    => 84
	);
	
	/**
	 *	Accent Color.
	 *---------------------------------------------------------*/
	$options[] = array(
		  'slug'        => 'accent_color'
		, 'opt_type'    => 'color'
		, 'name'        => esc_html__( 'Accent Color', 'vt-grid-mag' )
		, 'default'     => '#3F72D8'
		, 'section'     => 'colors'
		, 'transport'   => 'postMessage'
		, 'sanitize_callback' => 'sanitize_hex_color'
		, 'js_mod'      => 'css_output'
		, 'css_output'  => array(
			array(
				  'class' => '.infinite-loader, .comments-link-meta a:hover, .entry-title a:hover, .post-media .gallery-caption, .wp-caption-text a, .entry-content a, .comment-content a, .widget-text a, .widget a:hover, .widget_recent_comments ul li a:hover, .widget_latest_tweets_widget .latest-tweets p a, .widget_latest_tweets_widget .latest-tweets .tweet-details a:hover, .comment-awaiting-moderation, .comment-author a:hover, .comment-body .reply a:hover, .must-log-in a, .no-comments a:hover, .must-log-in a:hover, .logged-in-as a:hover, .comment-notes a:hover, .site-footer a:hover, .footer-social a:hover'
				, 'style' => 'color'
			),
			array(
				  'class' => 'button:hover, input[type="button"]:hover, input[type="reset"]:hover, input[type="submit"]:hover, .menu-toggle, .menu-toggle:hover, #infinite-handle span, .more-link span:hover, .tagcloud a:hover, .mc4wp-form button:hover, .mc4wp-form input[type=button]:hover, .mc4wp-form input[type=submit]:hover, .pagination .nav-links span, .pagination .nav-links a.page-numbers'
				, 'style' => 'background-color'
			),
			array(
				  'class' => 'button:hover, input[type="button"]:hover, input[type="reset"]:hover, input[type="submit"]:hover, .more-link span:hover'
				, 'style' => 'border-color'
			)
		)
	);
	
	/**
	 *	Header & Site Title.
	 *---------------------------------------------------------*/
	$options[] = array(
		  'slug'        => 'site_header_bg'
		, 'opt_type'    => 'color'
		, 'name'        => esc_html__( 'Header Background', 'vt-grid-mag' )
		, 'default'     => '#f4f4f4'
		, 'section'     => 'colors'
		, 'transport'   => 'postMessage'
		, 'sanitize_callback' => 'sanitize_hex_color'
		, 'js_mod'      => 'css_output'
		, 'css_output'  => array( array( 'class' => '.site-header', 'style' => 'background-color' ) )
	);

	$options[] = array(
		  'slug'        => 'site_title_color'
		, 'opt_type'    => 'color'
		, 'name'        => esc_html__( 'Site Title Color', 'vt-grid-mag' )
		, 'default'     => '#3F72D8'
		, 'section'     => 'colors'
		, 'transport'   => 'postMessage'
		, 'sanitize_callback' => 'sanitize_hex_color'
		, 'js_mod'      => 'css_output'
		, 'css_output'  => array( array( 'class' => '.site-title, .site-title a', 'style' => 'color' ) )
	);
	
	/**
	 *	Navigation.
	 *---------------------------------------------------------*/
	$options[] = array(
		  'slug'        => 'nav_color'
		, 'opt_type'    => 'color'
		, 'name'        => esc_html__( 'Navigation Text Color', 'vt-grid-mag' )
		, 'default'     => '#5A5A60'
		, 'section'     => 'colors'
		, 'transport'   => 'postMessage'
		, 'sanitize_callback' => 'sanitize_hex_color'
		, 'js_mod'      => 'css_output'
		, 'css_output'  => array( array( 'class' => '.site-navigation ul li a', 'style' => 'color' ) )
	);

	return $options;
}
add_filter( 'vt_grid_mag_settings_input', 'vt_grid_mag_customizer_add_colors' );