jQuery(document).ready(function($) {

	function initIconPicker( widget ) {
		widget.find( '.sp_btn_icon, .sp_cnt_icon, .sp_srv_icon' ).iconpicker().on(
			'iconpickerUpdated', function () {
			jQuery( this ).trigger( 'change' );
		});
	}

	function onClickIcon(){
		$('.sp_btn_icon, .sp_cnt_icon, .sp_srv_icon').on('iconpickerSelected', function (e) {
			$('.iconpicker-popover').css('display','none');
	    });

	    $('.sp_btn_icon, .sp_cnt_icon, .sp_srv_icon').on('click', function (e) {
			$('.iconpicker-popover').css('display','block');
	    });
	}

	function onFormUpdate( event, widget ) {
		initIconPicker(widget);
		onClickIcon();
	}

	$(document).on( 'widget-added widget-updated', onFormUpdate );

	$(document).ready( function() {
		$('#widgets-right .widget:has(.sp_btn_icon)').each( function () {
			initIconPicker($(this));
		});

		$('#widgets-right .widget:has(.sp_cnt_icon)').each( function () {
			initIconPicker($(this));
		});

		$('#widgets-right .widget:has(.sp_srv_icon)').each( function () {
			initIconPicker($(this));
		});
	});

	onClickIcon();

 });    