<?php
class coralina_social_widget extends WP_Widget {
    function __construct() {
        parent::__construct(
            'coralina_social_widget', 
            'Social Widget',
            array('description' => 'social buttons widget')
        );
    }

    function widget( $args, $instance ) {
        $sp_btn_link = apply_filters('widget_text', $instance['sp_btn_link']);
        $sp_btn_icon = apply_filters('widget_text', $instance['sp_btn_icon']);
        
        echo wp_kses_post($args['before_widget']);
        echo'<a href="'.esc_url($sp_btn_link).'"><i class="fab '.esc_attr($sp_btn_icon).'"></i></a>';        
        echo wp_kses_post($args['after_widget']);
    }

    function form( $instance ) {

        if(!empty($instance['sp_btn_link'])) $sp_btn_link = $instance['sp_btn_link'];
        else $sp_btn_link = '';

        if(!empty($instance['sp_btn_icon'])) $sp_btn_icon = $instance['sp_btn_icon'];
        else $sp_btn_icon = '';

        ?>
        <p><label for="<?php echo esc_attr($this->get_field_id('sp_btn_link')); ?>"><?php echo esc_html_e('Link', 'coralina-lite'); ?>:</label></br>
        <input type="text" class="sp_btn_link" id="<?php echo esc_attr($this->get_field_id('sp_btn_link')); ?>" name="<?php echo esc_attr($this->get_field_name('sp_btn_link')); ?>" value="<?php echo esc_attr($sp_btn_link); ?>"></p>
       
        <p><label for="<?php echo esc_attr($this->get_field_id('sp_btn_icon')); ?>"><?php echo esc_html_e('Icon', 'coralina-lite'); ?>:</label></br>
			<input type="text" id="<?php echo esc_attr($this->get_field_id('sp_btn_icon')); ?>" class="sp_btn_icon" name="<?php echo esc_attr($this->get_field_name('sp_btn_icon')); ?>" value="<?php echo esc_attr($sp_btn_icon); ?>"></p>
		
        <?php 
    }

    function update($new_instance, $old_instance) {
        $instance = array();
        $instance['sp_btn_link'] = ( ! empty( $new_instance['sp_btn_link'] ) ) ? sanitize_text_field($new_instance['sp_btn_link']) : '';
        $instance['sp_btn_icon'] = ( ! empty( $new_instance['sp_btn_icon'] ) ) ? sanitize_text_field($new_instance['sp_btn_icon']) : '';
        return $instance;
    }
}

function coralina_register_widgets() {
    register_widget('coralina_social_widget');
}

add_action('widgets_init', 'coralina_register_widgets');

?>