<?php
/*
 * Coralina Theme Customizer
 */

//Add postMessage support for site title and description for the Theme Customizer.
function coralina_customize_register($wp_customize) {
	$wp_customize->get_setting('blogname')->transport         = 'postMessage';
	$wp_customize->get_setting('blogdescription')->transport  = 'postMessage';
	$wp_customize->get_setting('header_textcolor')->transport = 'postMessage';
}
add_action( 'customize_register', 'coralina_customize_register' );

function coralina_customizer_addition($wp_customize) {

	$wp_customize->add_panel( 
		'coralina_default',
		array(
			'title'		=>	__('Default Setting','coralina-lite'),
			'priority'	=>	1,
		)
	);

	$wp_customize->get_section('title_tagline')->panel = 'coralina_default';
	$wp_customize->get_section('colors')->panel = 'coralina_default';
	$wp_customize->get_section('background_image')->panel = 'coralina_default';
	$wp_customize->get_section('static_front_page')->panel = 'coralina_default';
	$wp_customize->get_section('custom_css')->panel = 'coralina_default';

  /*contact section*/
  $wp_customize->add_section('contact_section' , array(
      'title'    => __('Contacts', 'coralina-lite'),
      'priority' => 2,
  ));

  //contact phone1
  $wp_customize->add_setting('contact_phone1', array(
      'capability' => 'edit_theme_options',
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field',
  ));

  $wp_customize->add_control('contact_phone1', array(
      'type' => 'input',
      'section' => 'contact_section',
      'label' => __('Phone:', 'coralina-lite'),
  ));
 
  /*posts/pages settings section*/
  $wp_customize->add_section('posts_settings_section' , array(
      'title'    => __('Posts/Pages settings', 'coralina-lite'),
      'priority' => 3
  ));

  //hide categoty and tags
  $wp_customize->add_setting('blog_tax', array(
      'capability' => 'edit_theme_options',
     	'default' => '',
     	'sanitize_callback' => 'coralina_sanitize_checkbox',
  ));

  $wp_customize->add_control('blog_tax', array(
      'settings' => 'blog_tax',
      'label'    => __('Hide categoty and tags', 'coralina-lite'),
      'section'  => 'posts_settings_section',
      'type'     => 'checkbox',
  ));

  //hide publication date
  $wp_customize->add_setting('blog_date', array(
      'capability' => 'edit_theme_options',
      'default' => '',
      'sanitize_callback' => 'coralina_sanitize_checkbox',
  ));

  $wp_customize->add_control('blog_date', array(
      'settings' => 'blog_date',
      'label'    => __('Hide publication date', 'coralina-lite'),
      'section'  => 'posts_settings_section',
      'type'     => 'checkbox',
  ));

  //full width post
  $wp_customize->add_setting('full_width_post', array(
      'capability' => 'edit_theme_options',
      'default' => '',
      'sanitize_callback' => 'coralina_sanitize_checkbox',
  ));

  $wp_customize->add_control('full_width_post', array(
      'settings' => 'full_width_post',
      'label'    => __('Full width post', 'coralina-lite'),
      'section'  => 'posts_settings_section',
      'type'     => 'checkbox',
  ));

  //full width page
  $wp_customize->add_setting('full_width_page', array(
      'capability' => 'edit_theme_options',
      'default' => '',
      'sanitize_callback' => 'coralina_sanitize_checkbox',
  ));

  $wp_customize->add_control('full_width_page', array(
      'settings' => 'full_width_page',
      'label'    => __('Full width page', 'coralina-lite'),
      'section'  => 'posts_settings_section',
      'type'     => 'checkbox',
  ));

  /*footer section*/
  $wp_customize->add_section('footer_section' , array(
      'title'    => __('Footer section', 'coralina-lite'),
      'priority' => 4
  ));

	$wp_customize->add_setting('copyright_text', array(
  		'capability' => 'edit_theme_options',
  		'default' => '',
  		'sanitize_callback' => 'sanitize_text_field',
	));

	$wp_customize->add_control('copyright_text', array(
  	  'type' => 'input',
  	  'section' => 'footer_section',
  	  'label' => __('Copyright text:', 'coralina-lite'),
	));

}

add_action( 'customize_register', 'coralina_customizer_addition' );

//Render the site title for the selective refresh partial.
function coralina_customize_partial_blogname() {
    bloginfo('name');
}

//Render the site tagline for the selective refresh partial.
function coralina_customize_partial_blogdescription() {
    bloginfo('description');
}

//Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
function coralina_customize_preview_js() {
	wp_enqueue_script('coralina-customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20151215', true );
}
add_action('customize_preview_init', 'coralina_customize_preview_js');

/*sanitize data*/

//sanitize checkbox
function coralina_sanitize_checkbox($input) {
    if ($input == 1) return 1;
    else return '';   
}