<?php
/**
 * The header for our theme
 */
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<!--begin header-->
<header class="header">
	<div class="container">
		<div class="row">
			<div class="header_wrapper">

				<!--begin site branding-->
				<div class="col-xl-2 col-lg-2 col-md-2 col-sm-4 col-4 site-branding-wrapper">
					<div class="site-branding">
						<?php echo csl_CustomSiteLogo_show_logo(); ?>
						<?php if(has_custom_logo()):

							$custom_logo_id = get_theme_mod('custom_logo');
							$logo_img_array = wp_get_attachment_image_src($custom_logo_id, 'full');
							$logo_img_src = esc_url($logo_img_array[0]);?>
							
							<a href="<?php echo esc_url(home_url('/'));?>" rel="home" title="<?php echo esc_attr(get_bloginfo('title'));?>"><img class="site-logo" src="<?php echo esc_url($logo_img_src); ?>" alt="<?php echo esc_attr(get_bloginfo('title'));?>"></a>
						<?php else: ?>	
							
							<a href="<?php echo esc_url(home_url('/')); ?>" class="h4 site-title"><?php echo esc_html(get_bloginfo('name'));?></a>
							<p class="site-description"><?php echo esc_html(get_bloginfo('description'));?></p>

						<?php endif;?>
					</div>	
				</div>
				<!--end site branding-->

				<!--begin menu-->
				<div class="col-xl-8 col-lg-8 col-md-8 col-sm-6 col-6 top-navigation-wrapper">
					<nav id="top-navigation" class="top-navigation" role="navigation">
						<?php
		    				wp_nav_menu( array(
		    					'container'       => 'ul',
		    					'theme_location'  => 'top-menu',
		    					'menu_id'         => '',
		    					'menu_class'	  => 'nav',	
		    					'depth'           => 1,
		    				) );
		    			?>
					</nav>
				</div>
				<!--end menu-->

				<!--begin social-->
				<div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-2">
					<?php
					$contact_phone1 = get_theme_mod('contact_phone1');
					if(!empty($contact_phone1)) echo '<a href="tel:+'.esc_attr(coralina_only_numbers($contact_phone1)).'" class="contact-phone show-modal" data-id="callback-request"><i class="fas fa-mobile-alt" aria-hidden="true"></i> '.esc_html($contact_phone1).'</a>';
					?>
					<div class="mobile-menu-icon text-right">
						<a href="#"><i class="fas fa-bars"></i></a>
					</div>	
				</div>
				<!--end social-->

			</div>	
		</div>
	</div>		
</header>
<!--end header-->

<!--begin mobile menu-->
<div class="mobile-menu">
	<div class="close"><i class="far fa-times-circle"></i></div>

	<div class="mobile-menu-wrapper">
		<ul class="nav-mobile">
			<?php
				wp_nav_menu( array(
					'container'       => '',
					'items_wrap'      => '%3$s',
					'theme_location'  => 'top-menu',
					'menu_id'         => '',
					'menu_class'	  => 'main_menu',	
					'depth'           => 1,
				) );
			?>
		</ul>
	</div>	
</div>
<!--end mobile menu-->