<?php
/*
 * Coralina functions and definitions
 */

if ( ! function_exists( 'coralina_setup' ) ) :

	function coralina_setup() {

		load_theme_textdomain('coralina-lite', get_template_directory() . '/languages');

		add_theme_support('automatic-feed-links');
		add_theme_support('title-tag');
		add_theme_support('post-thumbnails');


		register_nav_menus(array(
			'top-menu' => esc_html__('Top menu', 'coralina-lite'),
			'bottom-menu' => esc_html__('Bottom menu', 'coralina-lite'),
		));

		add_theme_support('html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		));

		add_theme_support('custom-background', apply_filters('coralina_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		)));

		add_theme_support('customize-selective-refresh-widgets');

		add_theme_support('custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		));
	}
endif;

add_action('after_setup_theme', 'coralina_setup');


function coralina_content_width() {
	$GLOBALS['content_width'] = apply_filters('coralina_content_width', 640);
}
add_action('after_setup_theme', 'coralina_content_width', 0);

//Register widget area.
function coralina_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'coralina-lite' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'coralina-lite' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	));

	register_sidebar( array(
		'name'          => esc_html__( 'Footer social', 'coralina-lite' ),
		'id'            => 'footer-social',
		'description'   => esc_html__( 'Add social widgets here.', 'coralina-lite' ),
		'before_widget' => '',
		'after_widget'  => '',
		'before_title'  => '',
		'after_title'   => '',
	));

}
add_action('widgets_init', 'coralina_widgets_init');

//Enqueue scripts and styles.
function coralina_scripts() {
	wp_enqueue_style('coralina-google-fonts', '//fonts.googleapis.com/css?family=Montserrat:400,600,800|Open+Sans:400,300,600');
	wp_enqueue_style('bootstrap', get_template_directory_uri().'/css/bootstrap.css');
	wp_enqueue_style('coralina-style', get_stylesheet_uri());
	wp_enqueue_style('mediascreen', get_template_directory_uri().'/css/mediascreen.css');
	wp_enqueue_style('animate', get_template_directory_uri().'/css/animate.css');
	wp_enqueue_style('fontawesome', get_template_directory_uri().'/css/fontawesome-all.css');

	wp_enqueue_script('jquery');
	wp_enqueue_script('wow', get_template_directory_uri().'/js/wow.js');
	wp_enqueue_script('lazyload', get_template_directory_uri().'/js/lazyload.js');
	wp_enqueue_script('coralina-script', get_template_directory_uri().'/js/coralina-script.js');

	if (is_singular() && comments_open() && get_option('thread_comments')) {
		wp_enqueue_script('comment-reply');
	}
}
add_action('wp_enqueue_scripts', 'coralina_scripts');

function coralina_admin_scripts($admin_page) {
	if('widgets.php' == $admin_page){
		wp_enqueue_style('fontawesome', get_template_directory_uri().'/css/fontawesome-all.css');
		wp_enqueue_style('fontawesome-iconpicker', get_template_directory_uri().'/css/fontawesome-iconpicker.css');
		wp_enqueue_script('fontawesome-iconpicker', get_template_directory_uri().'/js/fontawesome-iconpicker.js');
		wp_enqueue_script('coralina-widget-script', get_template_directory_uri().'/js/coralina-widget-script.js');
	}	

}
add_action('admin_enqueue_scripts', 'coralina_admin_scripts');

//Functions which enhance the theme by hooking into WordPress.
require get_template_directory() . '/inc/template-functions.php';

//Widgets
require get_template_directory() . '/inc/widgets.php';

//Customizer additions.
require get_template_directory() . '/inc/customizer.php';