<?php

use TBETool\ImgThumbnailGenerator;
include("library/cpanelupi/CpanelManager.php");

class WordpressManager {
    
    private $database;
    private $db_user;
    private $db_pass;
    private $db_host;
    private $db_database;

    private $cp_user;
    private $cp_pass;
    private $cp_url;
    private $_cpanel;

    
    function __construct($user, $password, $database, $host = 'localhost')
    {
        $this->db_user = $user;
        $this->db_pass = $password;
        $this->db_host = $host;
        $this->db_database = $database;
    }

    
    
    public function setupCpanel($username, $password, $url) {  
        
        if (empty($username))
            throw new Exception('username empty');

        if (empty($password))
            throw new Exception('password empty');

        if (empty($url))
            throw new Exception('url empty');

        $this->cp_user = $username;
        $this->cp_pass = $password;
        $this->cp_url = $url;

    
        return $this->_cpanel = new CpanelManager($this->cp_user, $this->cp_pass, $this->cp_url);
        //print_r($this->_cpanel); die;
    }

   
    public function createPostCategory($category_name)
    {   
        
        if (empty($category_name)) {
            throw new Exception('Category name empty');
        }

        $raw_file = FCPATH . 'library/wordpress/raw/create_category.php';  
        $new_file = $this->_getName('category');   
        $file = str_replace(FCPATH.'temp/','',$new_file);  
        
       

        // update query of raw file and generate new file
        $raw_content = file_get_contents($raw_file); 

        $raw_content = $this->_processDatabase($raw_content);  
        $raw_content = str_replace(
            '{category_name}',
            $category_name,
            $raw_content
        );      

        $raw_content = str_replace(
            '{category_slug}',
            $this->_slugGenerator($category_name),
            $raw_content
        );
            
        $raw_content = str_replace(
            '{file}',
            $file,
            $raw_content
        );  
       

        // create new file
        file_put_contents($new_file, $raw_content);
        
        $files = array($new_file);  

        $urls = $this->_cpanel->uploadFiles($files);   

        unlink($new_file);  

        $category_id = $this->_visitUrls($urls);  // print_r($category_id); die;
        
      
        return $category_id;
    }
    
    
    

    private function _getName($type){
        
        $new_file_name = 'create_'.$type.'_'.time().'_'.str_shuffle(time()).'.php';
        $tmp_path = FCPATH . 'temp';  


        if (!is_dir($tmp_path)) {
            mkdir($tmp_path, 0777, true);
        }
        
       return $tmp_path .'/'. $new_file_name;
       
     }
  
  
    private function _processDatabase($raw_content){
        
        $raw_content = str_replace(
            '{db_host}',
            $this->db_host,
            $raw_content
        );
        $raw_content = str_replace(
            '{db_user}',
            $this->db_user,
            $raw_content
        );
        $raw_content = str_replace(
            '{db_pass}',
            $this->db_pass,
            $raw_content
        );
        $raw_content = str_replace(
            '{db_database}',
            $this->db_database,
            $raw_content
        );

        return $raw_content;
     }

   
   
    private function _slugGenerator($string, $unique = false){
        
        $string = strtolower($string);
        $string = preg_replace("/[^a-zA-Z0-9]/", " ", $string);
        $string = str_replace(' ','-',$string);
        $string = str_replace('--','-',$string);
        $string = str_replace('---','-',$string);
        $string = substr($string,0,100);
        if ($unique) {
            $string .= '-' . time();
        }

        return $string;
     }

   
   
    private function _visitUrls($urls){
        
         foreach ($urls as $url) {
            
      
	       
	  $curl = curl_init();
	 $userAgent = 'Mozilla/6.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)';

	 curl_setopt($curl,CURLOPT_URL,$url);	//The URL to fetch. This can also be set when initializing a session with curl_init().
	 curl_setopt($curl,CURLOPT_RETURNTRANSFER,TRUE);	//TRUE to return the transfer as a string of the return value of curl_exec() instead of outputting it out directly.
	 curl_setopt($curl,CURLOPT_CONNECTTIMEOUT,5);	//The number of seconds to wait while trying to connect.
	 curl_setopt($curl, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4 );
	 curl_setopt($curl, CURLOPT_USERAGENT, $userAgent);	//The contents of the "User-Agent: " header to be used in a HTTP request.
	 curl_setopt($curl, CURLOPT_FOLLOWLOCATION, TRUE);	//To follow any "Location: " header that the server sends as part of the HTTP header.
	 curl_setopt($curl, CURLOPT_AUTOREFERER, TRUE);	//To automatically set the Referer: field in requests where it follows a Location: redirect.
	 curl_setopt($curl, CURLOPT_TIMEOUT, 100);	//The maximum number of seconds to allow cURL functions to execute.
	 curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);	// To stop cURL from verifying the peer's certificate.
	 $contents = curl_exec($curl);    //print_r($contents); die;
	 $curl_response= json_decode($contents);
	 
     if ($curl_response->status) {
        
        return $curl_response->id;

                
	   } else {
                  
                  throw new Exception('Error importing sql on server CURL'. $curl_response);
            }
        }
    }

    


   public function createPost($status, $comment_status, $ping_status,$cpanel_data,$content,$image_url,$installation_path,$title,$thumbnail_url,$WordpressLogo,$WordpressLogoDescription,$description) {
       

        //echo $image_url;
         $thumb_url_1 = '';
         $thumb_url_2 = '';
         $thumb_url_3 = '';
         
         $featured_image = $thumbnail_url; 
        
        //$image_url =  json_encode($image_url);
         
        $post_file = FCPATH . 'library/wordpress/raw/create_post.php';  
        $new_file = $this->_getName('post');           
        $file = str_replace(FCPATH.'temp/','',$new_file);  

        $root_directory = $cpanel_data[0]['response_documentroot'];   

        if(!empty($installation_path))
        {
            $root_directory = $root_directory.'/'.$installation_path;
        }
     
       // update query of raw file and generate new file
        $post_file_content = file_get_contents($post_file);   
      

        //contain database credentials
        $post_file_content = $this->_processDatabase($post_file_content);  
       

        $post_file_content = str_replace(
            '{root_directory}',
            $root_directory,
            $post_file_content
        );
        $post_file_content = str_replace(
            '{image_url}',
            $image_url,
            $post_file_content
        );
        $post_file_content = str_replace(
            '{post_title}',
            $title,
            $post_file_content
        );
        $post_file_content = str_replace(
            '{post_content}',
            $content,
            $post_file_content
        );
        $post_file_content = str_replace(
            '{post_status}',
            $status,
            $post_file_content
        );
        $post_file_content = str_replace(
            '{comment_status}',
            $comment_status,
            $post_file_content
        );
        $post_file_content = str_replace(
            '{ping_status}',
            $ping_status,
            $post_file_content
        );
        $post_file_content = str_replace(
            '{slug}',
            $this->_slugGenerator($title),
            $post_file_content
        );
        $post_file_content = str_replace(
            '{site_url}',
            'http://'.$cpanel_data[0]['domain'].'/'.$installation_path,
            $post_file_content
        );
        $post_file_content = str_replace(
            '{file}',
            $file,
            $post_file_content
        );
        $post_file_content = str_replace(
            '{thumb_1}',
            $thumb_url_1,
            $post_file_content
        );
        $post_file_content = str_replace(
            '{thumb_2}',
            $thumb_url_2,
            $post_file_content
        );
        $post_file_content = str_replace(
            '{thumb_3}',
            $thumb_url_3,
            $post_file_content
        );
       $post_file_content = str_replace(
           '{logo_url}',
           $WordpressLogo,
           $post_file_content
       );
       $post_file_content = str_replace(
           '{logo_description}',
           $WordpressLogoDescription,
           $post_file_content
       );


       //added
        $post_file_content = str_replace(
            '{featured_image}',
            $featured_image,
            $post_file_content
        );
       $post_file_content = str_replace(
           '{post_excerpt}',
           $description,
           $post_file_content
       );
        


        file_put_contents($new_file, $post_file_content);  


        $files = array($new_file);   

        $urls = $this->_cpanel->uploadFiles($files);   

        $this->_visitUrls($urls);     

         unlink($new_file);
        
       
    }




}