<?php
$data = array('id' => $this->session->userdata('user_id'));
$data['user_data']=$this->Membershipmodel->getUser($data);
?>

<!DOCTYPE html>
<html>
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <title>My Account</title>
    <?php $this->load->view('head');?>
</head>
<body>
<style>
.swal2-popup {
    display: none;
    position: relative;
    box-sizing: border-box;
    flex-direction: column;
    justify-content: center;
    width: 32em;
    /* max-width: 120%; */
    width: 500px;
    height: 360px;
    padding: 1.25em;
    border: none;
    border-radius: .3125em;
    background: #fff;
    font-family: inherit;
    font-size: 1rem;
}
.swal2-content {
    z-index: 1;
    justify-content: center;
    margin: 0;
    padding: 0;
    color: #545454;
    font-size:16px;
    font-weight: 400;
    line-height: normal;
    text-align: center;
    word-wrap: break-word;
}
.swal2-icon{
    width: 8em;
    height: 8em;
}
.swal2-icon .swal2-icon-content{
    font-size: 6.75em;
}
.swal2-styled.swal2-confirm{
    font-size: 1.9em;
}
</style>



<?php $this->load->view('header')?>
<?php $this->load->view($sidebar)?>
<div class="col-sm-9 col-sm-offset-3 col-lg-10 col-lg-offset-2 main">
    <div class="min-vh-footer">
    <div class="p-t-50">
        <div class="row">
            <div class="col-lg-12">
                <h3 class="page-header">My Account</h3>
            </div>
        </div><!--/.row-->
    </div>
    
   
    <!-- GDPR card-->
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    Manage Your Data
                </div>
                <div class="panel-body">
                    <div class="row btn-row">
                        <div class="col-md-3 col-xs-6">
                            <button type="button" class="btn btn-info" data-toggle="modal"
                                    rel="tooltip"
                                    title="Change your email"
                                    data-target="#myModal">
                                Change Email
                            </button>
                        </div>
                        <div class="col-md-3 col-xs-6" >
                            <button onclick="download_all_data()" rel="tooltip" data-toggle="tooltip" title="" class="btn btn-warning primary-btn" data-original-title="Download all Data"> Download Account Data</button>
                        </div>
                        <div class="col-md-3 col-xs-6" >
                            <button data-url="<?php echo site_url()?>disable"
                                    data-message="You are about to send a request for Stop Processing your Data. This request will completely stop your data from processing and also this will Disable your Account. This step is not reversible and thus please be very cautious in confirming."
                                    data-toggle="tooltip"
                                    data-icon="warning"
                                    class="btn btn-warning btn-del"
                                    title="By deactivate your account you won't be able to login into your account"> Deactivate My Account
                            </button>
                        </div>
                        <div class="col-md-3 col-xs-6" >
                            <button data-url="<?php echo site_url()?>delete"
                                    data-message="You are about to send a request for Deleting your account. This request will completely delete your Account. This step is not reversible and thus please be very cautious in confirming.OK"
                                    data-toggle="tooltip"
                                    data-icon="error"
                                    class="btn btn-danger btn-del dangerbtn"
                                    title="If you delete your account you all data will be lost and you won't be able to login into your account"> Delete My Account
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
 

    <!-- End GDPR card-->

    <!-- Update profile-->
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    Update Your Profile Details
                </div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="col-md-3 prof-cont">
                                <div class="card">
                                    <canvas class="header-bg" width="250" height="70" id="header-blur"></canvas>
                                    <div class="avatar">
                                        <img src="<?php if($data['user_data'][0]['image'] != null){
                                            echo base_url().'assets/img/user_images/'.$data['user_data'][0]['image'];
                                        } else{ echo base_url().'assets/img/user2.png';}
                                        ?>" alt="user" id="profile">
                                    </div>
                                    <div class="content">
                                        <p><?php echo $data['user_data'][0]['username']; ?>
                                        </p>
                                    </div>
                                </div>
                                <?php   $username = $data['user_data'][0]['username'];?>
                                
                                <form id="image">
                                <div class="row" style="margin-top:10px;margin-left:5px;">
                                   <div class="form-group">
                                        <label><span style ="margin-left:5px;">Change Profile</span></label>
                                        <input type="file" name="file" class="form-control upload-pic" data-placement="bottom" data-toggle="tooltip" data-html="true" title="Upload a profile image. JPG, JPEG, PNG files within 5MB is allowed"> 
                                    </div>
                                </div>
                                </form>
                            </div>
                            
                            
                            
                            <form id="update-profile">
                            
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>User's Name</label>
                                        <input type="text" name="username" class="form-control" value="<?php if(!empty($username)){echo $username;} else { }?>" required>
                                    </div>

                                </div>
                                
                              <div class="col-md-4" >
                                    <div class="form-group">
                                        <label>User's Email</label>
                                        <input  type="text" name="email" class="form-control" value="<?php if(!empty($data['user_data'][0]['email'])){echo $data['user_data'][0]['email'];} else { }?>" readonly>
                                    </div>

                            </div>
                                  
                           
                            <?php if($this->session->userdata('account_type') == 'user') { 
                                    ?>
                            <div class="col-md-3 pull-right">
                                <div class="form-group">
                                    <input type="submit" class="update-profile-btn  btn btn-primary form-control" name="submit" value="Update Profile" id="submitbtn">
                                </div>
                            </div>
                        <?php } ?>
                            </div>
                             
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--END profile update-->

    <!-- change password-->
   
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    Change Password
                </div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12">
                            
                            <form id="update-password">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Old Password</label>
                                        <input type="password" name="password" class="form-control" required>
                                    </div>

                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>New Password</label>
                                        <input type="password" name = "new_password" class="form-control" required>
                                    </div>

                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Confirm Password</label>
                                        <input type="password" name="confirm_password" class="form-control">
                                    </div>

                                </div>
                                <div class="col-md-3 pull-right">
                                    <div class="form-group">
                                        <input type="submit" class="btn btn-primary form-control" name="submit" value="Update Password" id="submitbtn">
                                    </div>
                                </div>
                            </div>
                            </form>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
   


    <!-- Modal -->
    <div id="myModal" class="modal fade" role="dialog" style="top:80px;">
        <div class="modal-dialog">

            <!-- Modal content-->
            <div class="modal-content">
                <div class="panel-heading">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Change Email</h4>
                </div>
                <?php echo form_open('UsersController/changeEmail');?>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>New Email :</label>
                                <input type="email" name="email" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Password :</label>
                                <input type="password" name="password" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <input type="submit" class="btn btn-info" name="submit" value="Change Email" id="submitbtn">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
                </form>
            </div>

        </div>
    </div>
</div>

    <div id="preloader">
        <div id="loader"></div>
    </div>
    <!-- END change password-->
    <!---footer------>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
    <?php $this->load->view('footer');?>
    <!---footer------>
  <script type="text/javascript" src="//cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>

  <link rel="stylesheet" href="<?php echo base_url();?>assets/toastr.min.css">
 
   
    <script>
        $(document).on('click', '.alert-pop', function (e) {
            e.preventDefault();
            var message = $(this).data('alert-message');
            var type = $(this).data('alert-type');
            var url = $(this).attr('href');

            if (type == 'confirm') {
                var confirm = window.confirm(message);
                if(confirm)
                {
                    window.location.href = url;
                }
            } else if (type == 'alert') {
                alert(message);
            }
        });
    </script>

    <script>
        $(document).on('click', '.btn-del', function () {

            var url = $(this).data('url');
            var message = $(this).data('message');
            var icon = $(this).data('icon');

            swal({
                title: "Are you sure?",
                text: "Note : " + message,
                icon: icon,
                buttons: true,
                dangerMode: true,
            })
                .then((willDelete) => {
                    if (willDelete) {
                        window.location.href = url;
                    }
                });
        });

    </script>

    <script>
        $(document).ready(function(){
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>
    <script>
        $(document).ready(function(){
            $('[rel="tooltip"]').tooltip();
        });
    </script>
    
    
    <!--user profile-->
    <script>
        $(document).on('submit','#update-profile', function (e) {
        e.preventDefault();
        $('#preloader').fadeIn();
		let form = $('#update-profile').serialize(); 
		let url = '<?php echo base_url().'profile'; ?>';
		
		$.ajax({
			method: 'POST',
			url: url,
			data: form,
			success: function (res) {
                $('#preloader').fadeOut();
				let response = $.parseJSON(res);
				if (response.status == 1) {
				     toastr.success(response.message, 'Success');    
				} else {
				     toastr.error(response.message, 'Error');    
				
				}
			}
		});
	 });
    </script>
    
    
    <!--user password-->
    <script>
        $(document).on('submit','#update-password', function (e) {
        e.preventDefault();
        $('#preloader').fadeIn();
		let form = $('#update-password').serialize(); 
		let url = '<?php echo base_url().'UsersController/changePassword'; ?>';
		
		$.ajax({
			method: 'POST',
			url: url,
			data: form,
			success: function (res) {
			    $('#preloader').fadeOut();
				let response = $.parseJSON(res);
			
				if (response.status == 1) {
				     toastr.success(response.message, 'Success');    
				} else if(response.status == 3) {
				     toastr.error(response.message, 'Error');    
				
				}
				else if(response.status == 4) {
				     toastr.error(response.message, 'Error');    
				
				}
				else  {
				     toastr.error(response.message, 'Error');    
				
				}
			}
		});
	 });
    </script>
    
    


 <!--change user image-->
  
  <script>
	$(document).on('change', '.upload-pic', function() {
	     $('#preloader').fadeIn();
	    let image = $('#image')[0];
		let formData = new FormData(image);
	    let url = '<?php echo base_url().'UsersController/changeProfileImage'; ?>';
	   
		$.ajax({
			method: 'POST',
			url: url,
			data: formData,
			contentType: false,
			cache: false,
			processData: false,
			success: function(data) {
			     $('#preloader').fadeOut();
				let res = $.parseJSON(data);
			    if (res.status == 1) {
					$('#profile').attr('src', res.path);
                    $('#profile-userpic').attr('src',res.path);
					toastr.success(res.message, 'Success');    
					

				} else if(res.status == 3){
				    
				    toastr.error(res.message, 'Error');
					
				}
				
				else {
				    
				    toastr.error(res.message, 'Error');
					
				}
			
			}
		});
	});

    function download_all_data(selector) {

        Swal.fire({
            title: 'Are you sure?',
            text: "Software Store Builder stores your private informations. It also stores your published sites. If you wish to download these data, you can do that by clicking ok button.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            confirmButtonText: 'OK'
        }).then((result) => {
            if (result.value) {

                $(selector).html('Downloading...');
                $.ajax({
                    url: '<?= site_url() ?>' + 'download-account-data',
                    method: 'POST',
                    data: {
                        type: 'download_my_data',
                        isDownloadData: 'yes'
                    },
                    success: function (response) {
                        console.log(response);
                        $("#main_page_loader").hide();
                        let response_data = JSON.parse(response);
                        if (response_data.status === true) {
                            $(selector).html('Download All Data');
                            //fire_alert(true, response_data.message);
                            //window.open(response_data.url);
                            window.location.href = response_data.url;

                        }
                        else {
                            fire_alert(false, response_data.message);
                            $(selector).html('Download All Data');
                        }
                    }
                });
            }
        });
    }

    $("button").click(function () {
    $('[data-toggle="tooltip"], .tooltip').tooltip("hide");
  });

  </script>

</div>
<style>
    .swal2-cancel{
    display: inline-block !important;
    height: 51px !important;
    width: 116px !important;
    font-size: 16px !important;
    text-align: center !important;
    background: red !important;
    }

</style>
</body>
</html>