<!DOCTYPE html>
<html>
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title>View Single Store</title>
<?php $this->load->view('head');?>
<meta http-equiv="refresh" content="40">
</head>
<body>
<?php $this->load->view('header');?>
<?php $this->load->view('side-bar');?>
<div class="col-sm-9 col-sm-offset-3 col-lg-10 col-lg-offset-2 main">
  <div class="min-vh-footer" >
    <div class="p-t-50">
        <div class="row">
            <div class="col-lg-12">
                <h3 class="page-header">Single Store Data</h3>
            </div>
        </div><!--/.row-->
    </div>

<div class="row">
			<div class="col-md-12 store-data">
				<div class="panel panel-default">
					<div class="panel-body">
						<table id="table_id" class="display ">
						    <thead>
						        <tr>
						            <th>Store Title</th>
						            <th>Visit Store</th>
						            <th>Steps</th>
                                    <th>Store Status</th>
						            <th>Theme Selected</th>
                                    <th>Created Date</th>
						            <th>Actions</th>
						        </tr>
						    </thead>
						    <tbody>
						    	<?php foreach ($sites as $store): ?>
							        <tr>
							            <td data-order="<?= $store['created'] ?>"><?php echo $store['blog_title']?></td>
							            <td data-order="<?= $store['created'] ?>"><a href="https://<?php echo $this->StoreModel->getDomainName($store['cpanel_id']).'/'.$store['installation_path'];?>"
                                               target="_blank"
                                               title="Go to your Store"
                                               class="btn btn-info btn-xs">
                                                <i class="fas fa-external-link-square-alt"></i>
                                            </a>
                                        </td>
							            <td data-order="<?= $store['created'] ?>">
							            	<?php if($store['step_1'] == 1) {?>
							            		<img src="<?php echo base_url();?>assets/img/check.png" class="progress" title="step 1">
							            	<?php } else {?>
							            		<img src="<?php echo base_url();?>assets/img/cross.png" class="progress" title="step 1">
							            	<?php }?>
							            	<?php if($store['step_2'] == 1) {?>
							            		<img src="<?php echo base_url();?>assets/img/check.png" class="progress" title="step 2">
							            	<?php } else {?>
							            		<img src="<?php echo base_url();?>assets/img/cross.png" class="progress" title="step 2">
							            	<?php }?>
							            	<?php if($store['step_3'] == 1) {?>
							            		<img src="<?php echo base_url();?>assets/img/check.png" class="progress" title="step 3">
							            	<?php } else {?>
							            		<img src="<?php echo base_url();?>assets/img/cross.png" class="progress" title="step 3">
							            	<?php }?>
							            </td>
                                        <td data-order="<?= $store['created'] ?>">
                                            <?php if($store['failed'] == 0) {?>
                                                <?php if($store['statuses_id'] == 1) {?>
                                                    <p style="color: #00CC00">Ready to create</p>
                                                <?php }elseif($store['statuses_id'] == 2){?>
                                                 <p style="color: #00CC00">Processing...</p>
                                                <?php } elseif($store['statuses_id'] == 3){?>
                                                    <p style="color: #00CC00">Complete</p>
                                                <?php }?>
                                                <?php } else if(strpos($store['message'], 'RequestThro (truncated...)') !== false){?>
                                                <p style="color: red">failed
                                                    <span rel="tooltip" title="Please click on the right side button to know more about this issue.">
                                                        <i class="fa fa-question-circle">
                                                        </i></span> <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/http-503-service-unavailable.html"
                                                                       rel="tooltip"
                                                                       title="Visit the link to know more about error."
                                                                       target="_blank">
                                                        <i class="fas fa-external-link-square-alt"></i>
                                                    </a></p>
                                            <?php } else {?>
                                                <p style="color: #00CC00">Pending...</p>
                                            <?php }?>
                                        </td>
							            <td data-order="<?= $store['created'] ?>"><?php echo $this->StoreModel->getField('name','themes',$store['theme_id'])?></td>
                                        <td data-order="<?= $store['created'] ?>">
                                            <?php echo !empty($store['created']) ? $store['created'] : 'NULL'; ?>
                                        </td>
							            <td data-order="<?= $store['created'] ?>">
                                            <?php if($store['step_1'] != 1) {?>
                                                <?php if($store['statuses_id'] != 3) {?>
                                                <a href="<?php echo site_url().'edit-single-site?id='.$store['id']?>"
                                                   class="btn btn-warning btn-xs"
                                                   rel="tooltip"
                                                   title="Click on this button to edit and retry in case of failure.">
                                                    <i class="fa fa-pencil-alt"></i>
                                                </a>
                                                <?php }?>
                                            <?php } else if($store['step_2'] != 1) {?>
                                                <?php if($store['statuses_id'] != 3) {?>
                                                    <a href="<?php echo site_url().'edit-category?id='.$store['id']?>"
                                                       class="btn btn-warning btn-xs"
                                                       rel="tooltip"
                                                       title="Click on this button to edit and retry in case of failure.">
                                                        <i class="fa fa-pencil-alt"></i>
                                                    </a>
                                                <?php }?>
                                            <?php } else {?>
                                                <?php if($store['statuses_id'] != 3) {?>
                                                    <a href="<?php echo site_url().'edit-category?id='.$store['id']?>"
                                                       class="btn btn-warning btn-xs"
                                                       rel="tooltip"
                                                       title="Click on this button to edit and retry in case of failure.">
                                                        <i class="fa fa-pencil-alt"></i>
                                                    </a>
                                                <?php }?>
                                            <?php } ?>

                                            <button data-url="<?php echo site_url().'assign_user_list?id='.$store['id']?>"
                                                    class="btn btn-primary btn-xs assign"
                                                    rel="tooltip"
                                                    title="Assign this store to your client(s)">
                                                <i class="fa fa-user-plus"></i>
                                            </button>
                                             <?php if($this->session->userdata('account_type') == 'user') { 
                                             ?>
                                            <button data-url="<?php echo site_url().'delete_store?id='.$store['id']?>"
                                                    class="btn btn-danger btn-xs btn-del"
                                                    rel="tooltip"
                                                    title="Delete store">
                                                <i class="fa fa-trash"></i>
                                            </button>
                                        <?php } ?>
                                        </td>
							        </tr>
						        <?php endforeach; ?>
						    </tbody>
						</table>
					</div>
				</div>
			</div>
		</div><!--/.row-->
    <!---footer------>
    </div>
    <?php $this->load->view('footer');?>
    <!---footer------>
</div>


<!-- Modal -->
<div id="myModal" class="modal fade" role="dialog">
    <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Assign single store to your client </h4>
            </div>
            <div id="modal-body" class="modal-body">
                <p>Some text in the modal.</p>
            </div>
            <div class="modal-footer">
               
            </div>
        </div>

    </div>
</div>

<script type="text/javascript">
	$(document).ready( function () {
    $('#table_id').DataTable({
        "order": [[ 3, "desc" ]], //or asc
        "columnDefs" : [{"targets":3, "type":"date-eu"}],
    });
} );
</script>

<script>
    $(document).on('click', '.btn-del', function () {

        var url = $(this).data('url');
        // alert(url);
        swal({
            title: "Are you sure?",
            text: "Note : Your Store will not be deleted, only this records will be erased.",
            icon: "error",
            buttons: true,
            dangerMode: true,
        })
            .then((willDelete) => {
                if (willDelete) {
                    window.location.href = url;
                }
            });
    });

</script>

<script>
    $(document).on('click','.assign', function () {
        var url = $(this).data('url');

        $('#modal-body').load(url, function () {
            $('#myModal').modal('show');
        });
    });
</script>

</body>
</html>
