<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title>Create Single Store</title>
<?php $this->load->view('head');?>
</head>
<body>
<?php $this->load->view('header');?>
<?php $this->load->view('side-bar');?>
<div class="col-sm-9 col-sm-offset-3 col-lg-10 col-lg-offset-2 main">
    <div class="p-t-50">
        <div class="row">
            <div class="col-lg-12">
                <h3 class="page-header">Hosting Details & Store Details 
                    <small><a href="<?= site_url() ?>tutorials">How to Create Single Store - Tutorial</a></small></h3>
            </div>
        </div>
        <!--/.row-->
    </div>
    <ul class="breadcrumb">
        <li class="active"><a href="javascript:void(0);">Hosting Details & Store Details</a></li>
        <li class=""><a href="javascript:void(0);">Niche Selection Envato category</a></li>
        <li><a href="javascript:void(0);">Choose Theme</a></li>
    </ul>
    <div class="row" style="min-height:80vh">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="wrapps">
                    <?php echo form_open('SingleSiteController/host_details');?>
                    <div class="row">
                        <div class="title_with_line">
                            cPanel and Monetization Details
                        </div>
                    </div>
                    <div class="row p-t-30">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>cPanel:</label>
                                <span class="tooltip-title-bg" rel="tooltip" title="Select your cPanel Account in which you would like to Setup the Software Store.">
                                        <i class="fa fa-question-circle"></i>
                                    </span>
                                <select class="form-control" name="cpanel_id" required>
                                    <option value="">-select-</option>
                                    <?php foreach ($cpanel_records as $cpanel): ?>
                                        <option value="<?php echo $cpanel['id'];?>">
                                            <?php echo $cpanel['username'].' ('.$cpanel['domain'].')';?></option>
                                    <?php endforeach;?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Store Path:
                                    <span class="tooltip-title-bg" rel="tooltip" title="Select the path of your installation folder. This will be the URL of your Software Store. In-order to use main domain leave this empty.">
                                        <i class="fa fa-question-circle"></i>
                                    </span>
                                </label>
                            <!--<span class="directory-separator">/</span>-->
                                <input type="text" name="installation_path" class="form-control" placeholder="Leave this blank if you want to use main domain">
                            </div>
                               <div class="alert alert-warning">Please make sure that the store path you are entering is empty to use, otherwise this will overwrite and replace the existing files (if any) on this path
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Envato User ID:</label>
                                <span class="tooltip-title-bg" rel="tooltip" title="Select the Envato account through which you would be fetching the products for your store.">
                                        <i class="fa fa-question-circle"></i>
                                    </span>
                                <select class="form-control" name="envato_id" required>
                                    <option value="">-select-</option>
                                    <?php foreach ($envato_records as $envato): ?>
                                        <option value="<?php echo $envato['id'];?>">
                                            <?php echo $envato['username'];?></option>
                                    <?php endforeach;?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Amazon Affiliate ID:</label>
                                 <span class="tooltip-title-bg" rel="tooltip" title="Select the Amazon account through which you will be fetching products to advertise on your Store">
                                        <i class="fa fa-question-circle"></i>
                                    </span>
                                <select class="form-control" name="amazon_id">
                                    <option value="">-select-</option>
                                    <?php foreach ($amazon_records as $amazon): ?>
                                        <option value="<?php echo $amazon['id'];?>">
                                            <?php echo $amazon['affiliate_tag'];?></option>
                                    <?php endforeach;?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row p-t-30">
                        <div class="title_with_line">
                            Store Details &nbsp;<small>(Please enter a new username and password to access your store to be built.)</small>
                        </div>
                    </div>
                    <div class="row p-t-30">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Store Title:</label>
                                <span class="tooltip-title-bg" rel="tooltip" title="Give a Title to your Store">
                                        <i class="fa fa-question-circle"></i>
                                    </span>
                                <input type="text" name="blog_title" class="form-control" placeholder="Enter Store Title" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Store Username:</label>
                                <span class="tooltip-title-bg" rel="tooltip" title="Give a username to your Store.This would be required to log into admin panel.">
                                        <i class="fa fa-question-circle"></i>
                                    </span>
                                <input type="text" name="blog_username" class="form-control" placeholder="Enter Store Username" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Store Password:</label>
                                <span class="tooltip-title-bg" rel="tooltip" title="Give a password to your Store.This would be required to log into admin panel.">
                                        <i class="fa fa-question-circle"></i>
                                    </span>
                                <input type="password" name="blog_password" class="form-control" placeholder="Enter Store Password" required>
                            </div>
                        </div>
                    </div>
                    <div class="row p-t-30" align="center">
                        <input type="submit" name="submit" value="Proceed to Niche Selection"  class="btn btn-info" id="submitbtn">
                    </div>
                </form>
                </div>
            </div>
        </div>
    </div>
    <!---footer------>
    <?php $this->load->view('footer');?>
    <!---footer------>
</div>
</body>
<script>
$('#submitbtn').click( function( event ) {
        $(document).find( 'select, textarea, input' ).each(function(){
            if($( this ).prop( 'required' )  && !$(this).val())  {
                $(this).css("border", "1px solid red");
            }
            else if ((!$( this ).prop( 'required' ) != "")){
                $(this).css("border", "1px solid  #ddd");
            }
        })
})
$(document).find( 'select, textarea, input' ).on('change', function(){
    if($(this).prop( 'required') && !$(this).val()){
        $(this).css("border", "1px solid red");
      } 
     else {
        $(this).css("border", "1px solid #ddd");
    }
});
</script>
</html>