<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Gdpr{

	public function recurse_copy($src,$dst) {
        $dir = opendir($src);
        if($dir)
        {
            @mkdir($dst);
            while(false !== ( $file = readdir($dir)) ) {
                if (( $file != '.' ) && ( $file != '..' )) {
                    if ( is_dir($src . '/' . $file) ) {
                        recurse_copy($src . '/' . $file,$dst . '/' . $file);
                    }
                    else {
                        copy($src . '/' . $file,$dst . '/' . $file);
                    }
                }
            }
            closedir($dir);

            return true;
        }
        else
        {
            return false;
        }
     }


    //generates the zip file
    public function zip_the_file($source, $destination){
        if (!extension_loaded('zip') || !file_exists($source)) {
            return false;
        }

        $zip = new ZipArchive();
        if (!$zip->open($destination, ZIPARCHIVE::CREATE)) {
            return false;
        }

        $source = str_replace('\\', '/', realpath($source));

        if (is_dir($source) === true)
        {
            $files = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($source), RecursiveIteratorIterator::SELF_FIRST);

            foreach ($files as $file)
            {
                $file = str_replace('\\', '/', $file);

                // Ignore "." and ".." folders
                if( in_array(substr($file, strrpos($file, '/')+1), array('.', '..')) )
                    continue;

                $file = realpath($file);

                if (is_dir($file) === true)
                {
                    $zip->addEmptyDir(str_replace($source . '/', '', $file . '/'));
                }
                else if (is_file($file) === true)
                {
                    $zip->addFromString(str_replace($source . '/', '', $file), file_get_contents($file));
                }
            }
        }
        else if (is_file($source) === true)
        {
            $zip->addFromString(basename($source), file_get_contents($source));
        }

        return $zip->close();
     }


    




    //delete the specified directory
    public function deleteDir($dirPath) {
        if (! is_dir($dirPath)) {
            throw new InvalidArgumentException("$dirPath must be a directory");
        }
        if (substr($dirPath, strlen($dirPath) - 1, 1) != '/') {
            $dirPath .= '/';
        }
        $files = glob($dirPath . '*', GLOB_MARK);
        foreach ($files as $file) {
            if (is_dir($file)) {
                $this->deleteDir($file);
            } else {
                unlink($file);
            }
        }
        rmdir($dirPath);
        }
 

 
      //download user details
      public function download_user_data($userid,$user_record,$amazon_account_connected,$cpanel_account_connected){
              if (!file_exists('uploads/downloads/'.$userid.'/')) {
                    mkdir('uploads/downloads/'.$userid.'/', 0777, true);
                }
                
                $user_record_formatted = 'Name: ' . $user_record[0]['username'] . " \n";
                $user_record_formatted .= 'Email: ' . $user_record[0]['email'] . " \n";
                $user_record_formatted .= 'created: ' . $user_record[0]['created'] . " \n";
                $user_record_formatted .= 'Profile Pic: '. base_url().$user_record[0]['image'] . " \n";
                $user_record_formatted .= 'Last modified: '.$user_record[0]['modified'] . " \n";

                $user_record_formatted .= " \n";
                

               /* if(isset($amazon_account_connected) && $amazon_account_connected != 0)
                {
                    $user_record_formatted .= "Amazon accounts connected: \n ";
                    foreach ($amazon_account_connected as $key => $amazon) {
                        $amazon_account = " ";
                        $amazon_account .= "Affiliate Tag: ". $amazon->affiliate_tag . " \n" ;
                        $amazon_account .= "Access Key: ". $amazon->access_key ." \n" ;
                        $user_record_formatted .= $amazon_account;

                    }
                }*/
                 
                 
                if(isset($cpanel_account_connected) && $cpanel_account_connected != 0)
                {
                    $user_record_formatted .= "Cpanel accounts connected: \n ";
                    foreach ($cpanel_account_connected as $key => $cpanel) {
                        $cpanel_account = " ";
                        $cpanel_account .= "Domain Name: ". $cpanel->domain . " \n" ;
                        $user_record_formatted .= $cpanel_account;

                    }
                }


                return $user_record_formatted;
        }


    
       //unlink user data
      public function unlink_user_data($userid){
       	 unlink('uploads/downloads/'.$userid.'/user_data_tiktalkbuilder.zip');
         
         $check = $this->zip_the_file('uploads/downloads/'.$userid.'/','uploads/downloads/'.$userid.'/user_data_tiktalkbuilder.zip');
          
         return $check;
          }

        

       //delete user data from upload folder directory
      public function delete_user_data($userid){
        	
        	if(is_dir('uploads/backgrounds/'.$userid.'/'))
                {
                   $this->deleteDir('uploads/backgrounds/'.$userid.'/');
                }
            if(is_dir('uploads/music/'.$userid.'/'))
                { 
                   $this->deleteDir('uploads/music/'.$userid.'/');
                }

            if(is_dir('uploads/videos/'.$userid.'/'))
                {
                   $this->deleteDir('uploads/videos/'.$userid.'/');
                }
        }



}	
