<?php
/**
 * Created by PhpStorm.
 * User: Vega 6
 * Date: 02-Apr-20
 * Time: 05:21 PM
 */

class Envato
{

    /**
     * Function: fetch_products
     *
     * This Function will fetch Products against keyword and no of post
     *
     * @parama: url,user_access_token
     * @return: array
    */
    public function fetch_products($url,$user_access_token)
    {
        $headers = array('Authorization: Bearer '.$user_access_token);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER,$headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);
        return $result;
    }

    /**
     * Function: get_user_access
     *
     * This Function will return user credentail like access_token
     *
     * @param: url,code
     * @return array
     */
    public function get_user_access($url,$code)
    {
        $params = array(
            'grant_type'    => 'authorization_code',
            'code'          => $code,
            'client_id'     => CODE_CLIENT,
            'client_secret' => CODE_APP_KEY,
        );

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1); // Remove on Get Request
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded'));
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        return json_decode($result);
    }


    /**
     * Function : refresh_access_token
     *
     * This Function will return user updated refresh token
     *
     * @param: url,$refresh_token
     * @return array
     */
    public function refresh_access_token($url,$refresh_token)
    {
        $params = array(
            'grant_type'    => 'refresh_token',
            'refresh_token'   => $refresh_token,
            'client_id'     => CODE_CLIENT,
            'client_secret' => CODE_APP_KEY,
        );

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1); // Remove on Get Request
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded'));
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        return json_decode($result);
    }


    /**
     * Function : get_user_details
     *
     * This Function will other user details like username,email
     * Function: delete
     *
     * @param: url, token
     * @return array
     * This function will delete requested affiliate
     */
    public function get_user_details($url,$token)
    {
        $headers = array('Authorization: Bearer '.$token);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER,$headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        return json_decode($result);
    }



    /**
     * Function: toStars
     *
     * This function get numeric value of star and return star in html format
     *
     * @param: n
     * @return: html
    */
    function toStars ($n)
    {
        $star = floor($n/2);
        $half = $n - ($star*2) >= 0.5 ? 1 : 0;
        $blank = 5 - ($star + $half);

        return str_repeat("<i class='fa fa-star' style='color: orange'></i>", $star)
            . str_repeat("<i class='fa fa-star-half-empty' style='color: orange'></i>", $half)
            . str_repeat("<i class='fa fa-star-o' style='color: orange'></i>", $blank);
    }


}