<?php

use TBETool\S3Service;

class AmazonManager
{

    private $region;
    private $access_key;
    private $secret_key;

    /**
     * This function make an object of to connect to amazon transcribe service
     * @param $region , region
     * @param $access_key , access key
     * @param $secret_key , secret key
     */
    public function connect($region, $access_key, $secret_key)
    {
        $this->region = $region;
        $this->access_key = $access_key;
        $this->secret_key = $secret_key;
    }

    /**
     * This function upload a file to amazon s3 bucket, if credentials are valid
     * it will return url of uploaded file else throw exception
     * @param $path , absolute path of your file
     * @param string $bucket
     * @return string
     * @throws Exception
     */
    public function s3Upload($path,$bucket=S3_BUCKET)
    {
        $file_extension = $this->_getFileExtension($path);

        $s3Service = new S3Service($this->access_key,$this->secret_key,$bucket);
        $s3Service->setS3Region($this->region);
        $s3Service->setS3Version('latest');
        $s3Service->setS3HttpVerify(false);
        try {

            $local_file = $path;
            $key = 'file_'.time().'_'.str_shuffle(time()).'.'.$file_extension;
            $s3_url = $s3Service->moveToS3($local_file,$key,array('public-read'));
            return $s3_url;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    /**
     * Return extension of the file
     * @param $path
     * @return mixed
     */
    private function _getFileExtension($path)
    {
        $explode = explode('.', $path);
        $ext = end($explode);
        return $ext;
    }

}