<?php
defined('BASEPATH') or exit('No direct script access allowed');

//include cPanel UAPI
include FCPATH . "library/cpanelupi/cpaneluapi.class.php";

class UsersController extends CI_Controller
{

    public function __construct()
    {

        parent::__construct();
        $this->load->library('user_agent');
    }

    /**
     * Function: index
     *
     * This function will load dashboard view if user logged in success
     *
     * @param : null
     *
     * @return : null
     */
    public function index()
    {

        if (!$this->is_logged_in()) {
            redirect('login');
        }

        if ($this->session->userdata('account_type') == 'user') {

            $id = array('user_id' => $this->session->userdata('user_id'));
            $table = 'records';
            $this->dashboardUserDetails($id, $table);
        } else if ($this->session->userdata('account_type') == 'client') {

            $id = array('user_id' => $this->session->userdata('user_id'));
            $table = 'client_accounts';
            $this->dashboardClientDetails($id, $table);
        } else if ($this->session->userdata('account_type') == 'team') {

            $user_id = array('user_id' => $this->session->userdata('user_id'));
            $table = 'records';
            $this->dashboardUserDetails($user_id, $table);
        } else {

            $this->session->set_flashdata('error', 'Unauthorized Access !');
            redirect('login');
            die();
        }
    }

    /**
     * Function: login
     *
     * This function will display login page and redirect on dashboard
     * if user logged in successfully
     *
     * @param : null
     *
     * @return : null
     */
    public function login()
    {

        if ($this->is_logged_in()) {

            redirect('dashboard');
        } elseif ((!empty($this->input->post('email'))) || (!empty($this->input->post('password')))) {

            $email = trim($this->input->post('email'));

            if (($this->Membershipmodel->checkforadata('users', 'email', $email)) || ($this->Membershipmodel->checkforadata('client_accounts', 'email', $email)) || ($this->Membershipmodel->checkforadata('virtual_accounts', 'email', $email))) {

                $password = trim($this->input->post('password'));
                $validate = $this->Membershipmodel->validatelogin($email, $password);
                $validate_va = $this->Membershipmodel->validateloginva($email, $password);
                $validate_ca = $this->Membershipmodel->validateloginca($email, $password);

                if ($validate != 0) {

                    $session_array['email'] = $email;
                    $session_array['user_id'] = $validate;
                    $checkisAdmin = $this->Membershipmodel->check_is_admin_or_not($validate);
                    $session_array['is_admin'] = $checkisAdmin;
                    $session_array['account_type'] = 'user';

                    // insert the IP address in the database
                    $ip = $this->input->ip_address();
                    $fetch_user_details = $this->Membershipmodel->fetchtabledataone('users', 'id', $validate);
                    $insert['user_id'] = $fetch_user_details[0]->id;
                    $insert['login'] = date("Y-m-d h:i:sa");
                    $insert['logout'] = date("Y-m-d h:i:sa");
                    $insert['user_type'] = 'root user';
                    $insert['client_ip'] = $ip;
                    $insert['browser'] = $this->agent->browser();
                    $insert['platform'] = $this->agent->platform();
                    $membershipdata = $this->Membershipmodel->fetchtabledataone('user_membership_levels', 'user_id', $fetch_user_details[0]->id);
                    $arm = array();
                    if (!empty($membershipdata)) {
                        foreach ($membershipdata as $meb) {
                            if ($meb->membership_level_id == 5) {
                                array_push($arm, $meb->membership_level_id);
                            }
                        }
                        if (!empty($arm)) {
                            $session_array['membership'] = $arm;
                        } else {
                            $session_array['membership'] = array();
                        }
                    } else {
                        $session_array['membership'] = array();
                    }
                if(!empty($arm)){
                    $session_array['wldata'] = $this->Membershipmodel->fetchtabledataone('wl_rebranding', 'user_id', $fetch_user_details[0]->id);
                }else{
                    $session_array['wldata'] = array();
                }
                    
                    $return_id = $this->Membershipmodel->insertData('login_logs', $insert);
                    $session_array['return_id'] = $return_id;
                    $update['modified'] = date("Y-m-d h:i:sa");
                    $this->Membershipmodel->updatetable('users', $update, 'id', $validate);
                    $this->session->set_userdata($session_array);

                    if ($this->session->userdata('account_type')) {

                        redirect('dashboard');
                    } else {
                        $this->session->set_flashdata('error', 'Email or password is invalid');
                        redirect('login');
                    }
                } elseif ($validate_va != 0) {
                    $ip = $this->input->ip_address();

                    $session_array['email'] = $email;
                    $session_array['user_id'] = $validate_va['userid'];
                    $session_array['vid'] = $validate_va['id'];
                    $session_array['account_type'] = 'team';

                    $fetch_user_details = $this->Membershipmodel->fetchtabledataone('virtual_accounts', 'id', $validate_va['id']);
                    $insert['user_id'] = $fetch_user_details[0]->id;
                    $insert['login'] = date("Y-m-d h:i:sa");
                    $insert['logout'] = date("Y-m-d h:i:sa");
                    $insert['user_type'] = 'Team Member';
                    $insert['client_ip'] = $ip;
                    $insert['browser'] = $this->agent->browser();
                    $insert['platform'] = $this->agent->platform();
                    $membershipdata = $this->Membershipmodel->fetchtabledataone('user_membership_levels', 'user_id', $fetch_user_details[0]->id);
                    $arm = array();
                    if (!empty($membershipdata)) {
                        foreach ($membershipdata as $meb) {
                            if ($meb->membership_level_id == 5) {
                                array_push($arm, $meb->membership_level_id);
                            }
                        }
                        if (!empty($arm)) {
                            $session_array['membership'] = $arm;
                        } else {
                            $session_array['membership'] = array();
                        }
                    } else {
                        $session_array['membership'] = array();
                    }
                if(!empty($arm)){
                    $session_array['wldata'] = $this->Membershipmodel->fetchtabledataone('wl_rebranding', 'user_id', $fetch_user_details[0]->id);
                }else{
                    $session_array['wldata'] = array();
                }
                    $return_id = $this->Membershipmodel->insertData('login_logs', $insert);
                    $session_array['return_id'] = $return_id;

                    $update['modified'] = date("Y-m-d h:i:sa");
                    $this->Membershipmodel->updatetable('virtual_accounts', $update, 'id', $validate_va['id']);
                    if ($this->session->set_userdata($session_array)) {
                        redirect('dashboard');
                    } else {
                        $this->session->set_flashdata('error', 'Email or password is invalid');
                        redirect('login');
                    }

                } elseif ($validate_ca != 0) {
                    $ip = $this->input->ip_address();
                    $session_array['email'] = $email;
                    $session_array['user_id'] = $validate_ca['userid'];
                    $session_array['cid'] = $validate_ca['id'];
                    $session_array['account_type'] = 'client';

                    $fetch_user_details = $this->Membershipmodel->fetchtabledataone('client_accounts', 'id', $validate_ca['id']);
                    $insert['user_id'] = $fetch_user_details[0]->id;
                    $insert['login'] = date("Y-m-d h:i:sa");
                    $insert['logout'] = date("Y-m-d h:i:sa");
                    $insert['user_type'] = 'client';
                    $insert['client_ip'] = $ip;
                    $insert['browser'] = $this->agent->browser();
                    $insert['platform'] = $this->agent->platform();
                    $membershipdata = $this->Membershipmodel->fetchtabledataone('user_membership_levels', 'user_id', $fetch_user_details[0]->id);
                    $arm = array();
                    if (!empty($membershipdata)) {
                        foreach ($membershipdata as $meb) {
                            if ($meb->membership_level_id == 5) {
                                array_push($arm, $meb->membership_level_id);
                            }
                        }
                        if (!empty($arm)) {
                            $session_array['membership'] = $arm;
                        } else {
                            $session_array['membership'] = array();
                        }
                    } else {
                        $session_array['membership'] = array();
                    }
                if(!empty($arm)){
                    $session_array['wldata'] = $this->Membershipmodel->fetchtabledataone('wl_rebranding', 'user_id', $fetch_user_details[0]->id);
                }else{
                    $session_array['wldata'] = array();
                }
                    $return_id = $this->Membershipmodel->insertData('login_logs', $insert);
                    $session_array['return_id'] = $return_id;

                    $update['modified'] = date("Y-m-d h:i:sa");
                    $this->Membershipmodel->updatetable('client_accounts', $update, 'id', $validate_ca['id']);

                    if ($this->session->set_userdata($session_array)) {
                        redirect('dashboard');
                    } else {
                        $this->session->set_flashdata('error', 'Email or password is invalid');
                        redirect('login');
                    }

                } else {

                    $this->session->set_flashdata('error', 'Your Email or Password is incorrect.');
                    redirect('login');
                    die();
                }
            } else {
                $this->session->set_flashdata('error', 'Invalid username or password');
                redirect('login');
                die();
            }
        } else {
            $this->load->view('login.php');
        }
    }

    /**
     * Function: logout
     *
     * This function destroy session and redirect to login page
     *
     * @param : null
     *
     * @return : null
     */
    public function logout()
    {
        $user_data = $this->session->all_userdata();

        if ((!empty($this->session->userdata['email'])) || (!empty($this->session->userdata['return_id']))) {
            $email = $this->session->userdata['email'];
            $return_id = $this->session->userdata['return_id'];
            $update['logout'] = date('Y-m-d H:i:sa');
            $this->Membershipmodel->updatetable('login_logs', $update, 'id', $return_id);
            foreach ($user_data as $key => $value) {

                if ($key != 'session_id' && $key != 'ip_address' && $key != 'user_agent' && $key != 'last_activity') {
                    $this->session->unset_userdata($key);
                }
            }
            $this->session->sess_destroy();
            $this->load->view('login.php');
        } else {

            $this->load->view('login.php');
        }
    }

    /**
     * Function: dashboardClientDetails
     *
     * This function renders the client dashboard details and take user_id and table name
     *
     * @param : id,table
     *
     * @return : null
     */
    public function dashboardClientDetails($id, $table)
    {

        $data['stores'] = $this->Membershipmodel->getStores($id, $table);
        $data['single_stores'] = $this->Membershipmodel->getCount('records', $id);
        $multiple_store_records = $this->Membershipmodel->getData('multiple_store_records', $id);
        $data['multiple_stores'] = 0;

        foreach ($multiple_store_records as $store_record) {

            $data['multiple_stores'] = $data['multiple_stores'] + $this->Membershipmodel->getCount('multiple_stores', array('multiple_store_records_id' => $store_record['id']));
        }

        $this->session->set_flashdata('success', 'You are logged in as a Client');
        $this->load->view('users/index', $data);
    }

    public function wl_rebranding()
    {
        $id = $this->session->userdata('user_id');
        if ($this->input->post()) {
            $title = $this->input->post('title');
            $name = $_FILES['file']['name'];
            $dataimg = array();
            if(!empty($name)){

            
           

            if (!empty($name)) {

                $explode = explode('.', $name);
                $ext = end($explode);
                $tmp_name = $_FILES['file']['tmp_name'];
                $path = 'assets/img/user_images/';
                $file_name = time() . '.' . $ext;

                move_uploaded_file($tmp_name, $path . $file_name);
                if(!empty($file_name)){
                    $dataimg['image'] = $file_name;
                }
                
            }

            if ($ext != 'png' && $ext != 'jpg' && $ext != 'jpeg') {
                $res = array(
                    'status' => 3,
                    'message' => 'Please select valid image',
                );

            }
        }
            $insert['title'] = $title;
           
            $insert['created'] = date('Y-m-d H:i:s');
            $insert['updated'] = date('Y-m-d H:i:s');
            $insert['user_id'] = $id;

            $result = $this->Membershipmodel->fetchtabledataone('wl_rebranding', 'user_id', $id);
            if (empty($result)) {
                    $insert['logo'] = 'assets/img/user_images/' . $dataimg['image'];
                if ($this->Membershipmodel->save('wl_rebranding', $insert)) {
                    $data['rebranding'] = $this->Membershipmodel->fetchtabledataone('wl_rebranding', 'user_id', $id);
                    $data['sidebar'] = $this->sidebar();
                    $session_array['wldata'] = $this->Membershipmodel->fetchtabledataone('wl_rebranding', 'user_id', $id);
                    $this->session->unset_userdata('wldata');
                    $this->session->set_userdata($session_array);
                    $this->load->view('users/wl_rebranding', $data);
                   
                } else {
                    $data['rebranding'] = $this->Membershipmodel->fetchtabledataone('wl_rebranding', 'user_id', $id);
                    $data['sidebar'] = $this->sidebar();
                    $session_array['wldata'] = $this->Membershipmodel->fetchtabledataone('wl_rebranding', 'user_id', $id);
                    $this->session->unset_userdata('wldata');
                    $this->session->set_userdata($session_array);
                    $this->load->view('users/wl_rebranding', $data);
                }
            } else {
                if(!empty($dataimg)){
                $insert['logo'] = 'assets/img/user_images/' . $dataimg['image'];
                }
                if ($this->Membershipmodel->update('wl_rebranding', $result[0]->id, $insert)) {
                    $data['rebranding'] = $this->Membershipmodel->fetchtabledataone('wl_rebranding', 'user_id', $id);
                    $data['sidebar'] = $this->sidebar();
                    $session_array['wldata'] = $this->Membershipmodel->fetchtabledataone('wl_rebranding', 'user_id', $id);
                    $this->session->unset_userdata('wldata');
                    $this->session->set_userdata($session_array);
                    $this->load->view('users/wl_rebranding', $data);

                } else {
                    $data['rebranding'] = $this->Membershipmodel->fetchtabledataone('wl_rebranding', 'user_id', $id);
                    $data['sidebar'] = $this->sidebar();
                    $session_array['wldata'] = $this->Membershipmodel->fetchtabledataone('wl_rebranding', 'user_id', $id);
                    $this->session->unset_userdata('wldata');
                    $this->session->set_userdata($session_array);
                    $this->load->view('users/wl_rebranding', $data);
                }
            }

        } else {
            $data['rebranding'] = $this->Membershipmodel->fetchtabledataone('wl_rebranding', 'user_id', $id);
            $data['sidebar'] = $this->sidebar();
            $session_array['wldata'] = $this->Membershipmodel->fetchtabledataone('wl_rebranding', 'user_id', $id);
            $this->session->unset_userdata('wldata');
            $this->session->set_userdata($session_array);
            $this->load->view('users/wl_rebranding', $data);
        }

    }


    public function wl_rebranding_remove($rid)
    {
        $id = $this->session->userdata('user_id');
        $this->Membershipmodel->delete('wl_rebranding', array('id' => $rid));
        $data['rebranding'] = $this->Membershipmodel->fetchtabledataone('wl_rebranding', 'user_id', $id);
        $data['sidebar'] = $this->sidebar();
        $this->session->unset_userdata('wldata');
        $this->load->view('users/wl_rebranding', $data);
    }

    /**
     * Function: dashboardUserDetails
     *
     * This function renders the user dashboard details and take user_id and table name
     *
     * @param : id,table
     *
     * @return : null
     */
    public function dashboardUserDetails($id, $table)
    {

        $parent_email = $this->Membershipmodel->fetchtabledataone('users', 'id', $id['user_id']);
        $data['stores'] = $this->Membershipmodel->getStores($id, $table);
        $data['envato'] = $this->Membershipmodel->getCount('envato', $id);
        $data['cpanel'] = $this->Membershipmodel->getCount('cpanel', $id);
        $data['amazon'] = $this->Membershipmodel->getCount('amazon', $id);
        $data['single_stores'] = $this->Membershipmodel->getCount('records', $id);

        $multiple_store_records = $this->Membershipmodel->getData('multiple_store_records', $id);
        $data['multiple_stores'] = 0;
        foreach ($multiple_store_records as $store_record) {
            $data['multiple_stores'] = $data['multiple_stores'] + $this->Membershipmodel->getCount('multiple_stores', array('multiple_store_records_id' => $store_record['id']));
        }

        // count single store data for Graph
        $data['graph_single'] = array();
        $data['graph_multi_stores'] = array();
        for ($i = 1; $i <= 12; $i++) {
            $data['graph_single'][] = $this->Membershipmodel->graphDataSingleStore($id['user_id'], $i);

        }
        $data['graph_single'] = json_encode($data['graph_single']);

        for ($i = 1; $i <= 12; $i++) {
            $data['graph_multi_stores'][] = $this->Membershipmodel->graphDataMultiStore($id['user_id'], $i);
        }

        $data['graph_multi_stores'] = json_encode($data['graph_multi_stores']);

        if ($this->session->userdata('account_type') == 'team') {
            $this->session->set_flashdata('success', 'You are logged on behalf of ' . $parent_email[0]->email);
        }
        $this->load->view('users/index', $data);
    }

    /**
     * Function: profile
     *
     * This function used to change the user's account details, disable account,
     * download account data and delete account.
     *
     * @param : null
     *
     * @return : null
     */

    public function profile()
    {

        if ($this->input->is_ajax_request()) {

            $id = $this->session->userdata('user_id');

            $data = array('username' => $this->input->post('username'));

            if ($this->Membershipmodel->update('users', $id, $data)) {
                $res = array(
                    'status' => 1,
                    'message' => 'Profile updated successfully',
                );
                echo json_encode($res);
            }
        } else {

            $data['sidebar'] = $this->sidebar();
            $this->load->view('users/profile', $data);
        }
    }

    /**
     * Function: download_my_account
     *
     * This function will allow user to download his all account related data
     *
     * @param : null
     *
     * @return : null
     */
    public function download_my_data()
    {

        if ($this->is_logged_in()) {

            $userid = $this->session->userdata('user_id');
            $user_record = $this->Membershipmodel->getData('users', array('id' => $userid));
            $amazon_account_connected = $this->Membershipmodel->fetchtabledataone('amazon', 'user_id', $userid);
            $cpanel_account_connected = $this->Membershipmodel->fetchtabledataone('cpanel', 'user_id', $userid);

            $gdpr = new Gdpr();
            $user_record_formatted = $gdpr->download_user_data($userid, $user_record, $amazon_account_connected, $cpanel_account_connected);

            $done = file_put_contents('uploads/downloads/' . $userid . '/records.txt', $user_record_formatted);

            $unlink_user_details = new Gdpr();
            $check = $unlink_user_details->unlink_user_data($userid);
            if ($check) {
                $data['status'] = true;
                $data['message'] = 'Downloading data';
                $data['url'] = base_url() . 'uploads/downloads/' . $userid . '/user_data_tiktalkbuilder.zip';
                //echo $link = "<script>window.open('$data')</script>";
            } else {
                $data['status'] = false;
                $data['message'] = 'Not able to lined up & Compress your data';
            }

            echo json_encode($data);die();
        } else {
            redirect('logout');
        }
    }

    /**
     * Function: disableAccount
     *
     * This function will disable user's account
     *
     * @param : null
     *
     * @return : null
     */
    public function disableAccount()
    {

        $this->Membershipmodel->update('users', $this->session->userdata('user_id'), array('status' => 0));
        $this->session->set_flashdata('success', 'Your account is disabled ! Contact our support team to enable your account');
        $this->logout();
    }

    /**
     * Function: randomPassword
     *
     * This function will generate a random password
     *
     * @param : null
     *
     * @return : null
     */
    public function randomPassword()
    {

        $alphabet = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        $pass = array();
        $alphaLength = strlen($alphabet) - 1;
        for ($i = 0; $i < 22; $i++) {
            $n = rand(0, $alphaLength);
            $pass[] = $alphabet[$n];
        }
        return implode($pass);
    }

    /**
     * Function: changePassword
     *
     * This function changes the user's passwords if his/her old password is valid.
     *
     * @param : null
     *
     * @return : null
     */
    public function changePassword()
    {

        if ($this->input->is_ajax_request()) {
            $id = $this->session->userdata('user_id');
            $password = $this->input->post('password');
            $new_password = $this->input->post('new_password');
            $confirm_password = $this->input->post('confirm_password');

            if ($new_password == $confirm_password) {

                $user = $this->Membershipmodel->getData('users', array('id' => $id));

                if (password_verify($password, $user[0]['password'])) {

                    $options = array(
                        'salt' => $this->randomPassword(),
                        'cost' => 13,
                    );

                    $hash = password_hash($new_password, PASSWORD_DEFAULT, $options);

                    if ($this->Membershipmodel->update('users', $id, array('password' => $hash))) {

                        $res = array(
                            'status' => 1,
                            'message' => 'Password has been changed successfully',
                        );
                        echo json_encode($res);
                    } else {

                        $res = array(
                            'status' => 0,
                            'message' => 'Something went wrong in changing the password. Please Try Again',
                        );

                        echo json_encode($res);

                    }

                } else {

                    $res = array(
                        'status' => 3,
                        'message' => 'Enter your valid old password',
                    );
                    echo json_encode($res);

                }

            } else {

                $res = array(
                    'status' => 4,
                    'message' => 'New password and confirm password were not same',
                );
                echo json_encode($res);

            }
        } else {

            $this->load->view('users/change-password');
        }
    }

    /**
     * Function: changeProfileImage
     *
     * This function update the user profile Image
     *
     * @param : null
     *
     * @return : null
     */
    public function changeProfileImage()
    {

        if ($this->input->is_ajax_request()) {

            $name = $_FILES['file']['name'];
            $id = $this->session->userdata('user_id');

            $data = array();

            if (!empty($name)) {

                $explode = explode('.', $name);
                $ext = end($explode);
                $tmp_name = $_FILES['file']['tmp_name'];
                $path = 'assets/img/user_images/';
                $file_name = time() . '.' . $ext;

                move_uploaded_file($tmp_name, $path . $file_name);

                $data['image'] = $file_name;
            }

            if ($ext != 'png' && $ext != 'jpg' && $ext != 'jpeg') {
                $res = array(
                    'status' => 3,
                    'message' => 'Please select valid image',
                );
                echo json_encode($res);
                die;
            }

            if ($this->Membershipmodel->update('users', $id, $data)) {
                $res = array(
                    'status' => 1,
                    'path' => site_url() . $path . $file_name,
                    'message' => 'Profile image updated successfully',
                );
                echo json_encode($res);

            } else {

                $res = array(
                    'status' => 0,
                    'message' => 'Something went wrong',
                );
                echo json_encode($res);
            }
        } else {

            $data['sidebar'] = $this->sidebar();
            $this->load->view('users/profile', $data);
        }
    }

    /**
     * Function: forget_password
     *
     * This function will load the forgot password page and will ask user to enter his/her
     * email address to find his/her account. And send email with link to reset password if email is valid.
     *
     * @param : null
     *
     * @return : null
     */

    public function forgot_password()
    {

        if ($this->input->post('submit')) {

            $data = array('email' => $this->input->post('email'));

            $arr = array();
            if ($this->Membershipmodel->exists('users', $data)) {
                $get_userid = $this->Membershipmodel->getData('users', $data);
                $token = openssl_random_pseudo_bytes(16);
                $token = bin2hex($token);
                $arr['id'] = $get_userid[0]['id'];
                $arr['token'] = $token;
                $arr['exprtime'] = date('d-m-Y h:i:s', time() + (60 * 60 * 2));
                $urlToken = base64_encode(json_encode($arr));

                $update = array('hash' => $token);
                if ($this->Membershipmodel->resetPassword($this->input->post('email'), $update)) {

                    $url = site_url() . "user_reset_password?token=" . $urlToken;
                    $body = 'Hey,<br/><br/>You had requested to reset your password.<br/>Please Click the <a href="' .
                        $url . '">Reset Password</a> to reset your password. <br/><br/>
                                You can also copy and paste this link in your browser to reset your password LINK <br/><br/>
                                Reach out to us if you have any support queries: <a href=\'http://support.vineasx.com\'>http://support.vineasx.com</a><br/>
                                <br/><br/>Cheers,<br/>Abhi Dwivedi<br/>Tiktalk Builder Team';

                    $email = new Mailer();
                    $mail_response = $this->mail($data['email'], 'Change Password', $body);
                }

                if ($mail_response) {
                    $this->session->set_flashdata('success', 'if an account exist with provided email you will receive an email. Please follow the instruction to reset your password.');
                }
                redirect('login');
            } else {
                $this->session->set_flashdata('error', 'Please check your email address');
                redirect('find_account');
            }
        } else {
            $this->load->view('users/find-account');
        }
    }

    /**
     * Function: user_reset_password
     *
     * This function will check user reset password link
     *
     * @param : null
     *
     * @return : null
     */
    public function user_reset_password()
    {

        $user_data = base64_decode($_GET['token']);
        $json_decode = json_decode($user_data);
        $token = $json_decode->token;
        $cleanToken = $this->security->xss_clean($token);
        $id = $json_decode->id;
        $exprtime = strtotime($json_decode->exprtime);
        $currtime = strtotime(date('d-m-Y h:i:s'));
        if ($currtime > $exprtime) {

            $this->session->set_flashdata('error', 'Sorry this url is expired');
            redirect('login');

        } else {

            $user_info = $this->Membershipmodel->isTokenValid($id, $cleanToken);
            if (!$user_info) {

                $this->session->set_flashdata('error', 'Invalid Token');
                redirect('login');

            } else {

                $user_id = array();
                $user_id['id'] = $user_info['id'];
                $user_id['email'] = $user_info['email'];
                $this->load->view('users/reset-password', $user_id);
            }
        }
    }

    /**
     * Function: reset_password
     *
     * This will load create new password page and update password entered by him/her
     *
     * @param : null
     *
     * @param : null
     */
    public function reset_password()
    {
        if ($this->input->post('submit')) {
            $userid = $this->input->post('usrid');
            $useremail = $this->input->post('usremail');
            $new_password = $this->input->post('password');
            $confirm_password = $this->input->post('cpassword');

            $data = array('email' => $useremail);
            if ($new_password == $confirm_password) {
                if ($this->Membershipmodel->exists('users', $data)) {
                    $user = $this->Membershipmodel->getData('users', $data);

                    $options = array(
                        'salt' => $this->randomPassword(),
                        'cost' => 13,
                    );

                    $newhash = password_hash($new_password, PASSWORD_DEFAULT, $options);

                    $data1 = array('password' => $newhash);

                    if ($this->Membershipmodel->update('users', $user[0]['id'], $data1)) {

                        $password_update_message = "Hey,<br /><br /> Your password for TikTalk Builder account has been changed.
                                           Your new password is $new_password. Please logout and login with the new password.
                                           <br /><br />
		                                   Reach out to us if you have any support queries:
		                                   <a href='http://support.vega6.com'>http://support.vega6.com</a> <br />
		                                   <br /><br />
		                                   Cheers,<br />
		                                   Abhi Dwivedi<br />";

                        $mail_response = $this->mail($useremail, 'Account Password Changed', $password_update_message);

                        $this->session->set_flashdata('success', 'Your Password has been changed successfully');
                        redirect('login');
                    }

                } else {

                    $this->session->set_flashdata('error', ' The email account that you tried to reach does not exist');
                    redirect('login');
                }

            }

        } else {

            $this->session->set_flashdata('error', 'Unauthorized Access');
            redirect('login');
        }
    }

    /**
     * Function: clientAccount
     *
     * This function will display client accounts and allow to create client account
     *
     * @param : null
     *
     * @return : null
     */
    public function clientAccount()
    {

        $this->is_logged_in();

        if ($this->input->post('submit')) {

            //check email in client
            if ($this->Membershipmodel->exists('client_accounts', array('email' => $this->input->post('email')))) {
                $this->session->set_flashdata('error', 'An account already exists for the given email address');
                redirect('client_account');
            }

            //check email in team member
            if ($this->Membershipmodel->exists('virtual_accounts', array('email' => $this->input->post('email')))) {
                $this->session->set_flashdata('error', 'An account already exists for the given email address');
                redirect('client_account');
            }

            //check email in users
            if (($this->Membershipmodel->exists('users', array('email' => $this->input->post('email'))))) {
                $this->session->set_flashdata('error', 'An account already exists for the given email address');
                redirect('client_account');
            }

            $email = $this->input->post('email');
            $password = $this->input->post('password');
            $username = $this->input->post('first_name') . ' ' . $this->input->post('last_name');
            $hash = '';
            $image = '';

            $getData = array('id' => $this->session->userdata('user_id'));

            $userData['userdata'] = $this->Membershipmodel->getUser($getData);

            $email_data = array(
                'parent_name' => $userData['userdata'][0]['username'],
                'client_name' => $username,
                'parent_email' => $userData['userdata'][0]['email'],
                'client_email' => $email,
                'password' => $password,
            );

            $mail = new Mailer();
            $client_body = $this->load->view('client_mail', $email_data, true);
            $this->mail($email, '[IMPORTANT] Your Login Details for SOFTWARE STORE BUILDER', $client_body);

            $parent_body = $this->load->view('client_parent_mail', $email_data, true);
            $this->mail($userData['userdata'][0]['email'], 'Tiktalk Builder Client Account Created', $parent_body);

            $options = array(
                'salt' => $this->randomPassword(),
                'cost' => 13,
            );

            $new_password = password_hash($password, PASSWORD_DEFAULT, $options);
            $data = array(
                'user_id' => $this->session->userdata('user_id'),
                'username' => $username,
                'email' => $email,
                'password' => $new_password,
                'hash' => $hash,
                'status' => 1,
                'image' => $image,
                'created' => date('Y-m-d H:i:s'),
            );

            $this->Membershipmodel->save('client_accounts', $data);
            $this->session->set_flashdata('success', 'Client Added Successfully');
            redirect('client_account');
        }

        $data['clients'] = array();
        $data['clients'] = $this->Membershipmodel->getData('client_accounts', array('user_id' => $this->session->userdata('user_id')));
        $this->load->view('users/client-account', $data);

    }

    /**
     * Function: deleteClient
     *
     * This function will allow to delete client account
     *
     * @param : null
     *
     * @return : null
     */
    public function deleteClient()
    {

        $id = $this->input->get('id');
        if ($this->Membershipmodel->delete('client_accounts', array('id' => $id))) {
            $this->session->set_flashdata('success', 'Client deleted successfully');
            redirect('client_account');
        }
    }

    /**
     * Function: changeEmail
     *
     * This function is used to change the user's email address.
     *
     * @param : null
     *
     * @return : null
     */
    public function changeEmail()
    {

        $id = $this->session->userdata('user_id');
        if ($this->input->post('submit')) {
            if ($this->Membershipmodel->exists('users', array('email' => $this->input->post('email')))) {
                $this->session->set_flashdata('error', 'This user already exists');
                redirect('profile');
            }

            $password = $this->input->post('password');
            $user = $this->Membershipmodel->getData('users', array('id' => $id));

            if (password_verify($password, $user[0]['password'])) {
                $this->Membershipmodel->save('obsolete_email', array(
                    'user_id' => $id,
                    'email' => $this->Membershipmodel->getField('email', 'users', $id))
                );

                $this->Membershipmodel->update('users', $id, array('email' => $this->input->post('email')));
                $this->session->set_flashdata('success', 'Email changed successfully');
                redirect('profile');
            }

            $this->session->set_flashdata('error', 'Password invalid');
            redirect('profile');
        }
    }

    /**
     * Function: virtualAccount
     *
     * This function will display virtual accounts and allow to add virtual account
     *
     * @param : null
     *
     * @return : null
     */
    public function virtualAccount()
    {

        $this->is_logged_in();
        $user_id = $this->session->userdata('user_id');

        if ($this->input->post('submit')) {
            $no_of_clients = $this->Membershipmodel->getCount('virtual_accounts', array('user_id' => $this->session->userdata('user_id')));

            if ($no_of_clients >= 5) {
                $this->session->set_flashdata('error', 'Only 5 virtual accounts are allowed');
                redirect('team_member');
            }

            //check email exists in team member
            if ($this->Membershipmodel->exists('virtual_accounts', array('email' => $this->input->post('email')))) {
                $this->session->set_flashdata('error', 'An account already exists for the given email address');
                redirect('team_member');
            }

            //check email exists in client
            if ($this->Membershipmodel->exists('client_accounts', array('email' => $this->input->post('email')))) {
                $this->session->set_flashdata('error', 'An account already exists for the given email address');
                redirect('team_member');
            }

            //check email exists in users
            if (($this->Membershipmodel->exists('users', array('email' => $this->input->post('email'))))) {
                $this->session->set_flashdata('error', 'An account already exists for the given email address');
                redirect('team_member');
            }

            $email = $this->input->post('email');
            $password = $this->input->post('password');
            $virtual_account_username = $this->input->post('first_name') . ' ' . $this->input->post('last_name');
            $hash = '';
            $image = '';

            $getData = array('id' => $this->session->userdata('user_id'));

            $userData['userdata'] = $this->Membershipmodel->getUser($getData);

            $email_data = array(
                'parent_name' => $userData['userdata'][0]['username'],
                'team_member_name' => $virtual_account_username,
                'parent_email' => $userData['userdata'][0]['email'],
                'team_member_email' => $email,
                'password' => $password,
            );

            $mail = new Mailer();

            $team_member_body = $this->load->view('team_member_mail', $email_data, true);
            $anewemail = $this->mail($email, 'welcome', $team_member_body);

            $team_member_parent_body = $this->load->view('team_member_parent_mail', $email_data, true);
            $newuserdata = $this->mail($userData['userdata'][0]['email'], 'Software Store Builder Team Member Account Created', $team_member_parent_body);

            $options = array(
                'salt' => $this->randomPassword(),
                'cost' => 13,
            );

            $new_password = password_hash($password, PASSWORD_DEFAULT, $options);
            $data = array(
                'user_id' => $this->session->userdata('user_id'),
                'username' => $virtual_account_username,
                'email' => $email,
                'password' => $new_password,
                'hash' => $hash,
                'status' => 1,
                'image' => $image,
                'created' => date('Y-m-d H:i:s'),
            );

            $this->Membershipmodel->save('virtual_accounts', $data);
            $this->session->set_flashdata('success', 'User added successfully');
            redirect('team_member');
        }

        if ($this->session->userdata('account_type') == 'team') {
            $data['virtual_accounts'] = array();
            $data['virtual_accounts'] = $this->Membershipmodel->getData('virtual_accounts', array('user_id' => $user_id));
            $this->load->view('users/virtual-account', $data);
        } else {

            $data['virtual_accounts'] = array();
            $data['virtual_accounts'] = $this->Membershipmodel->getData('virtual_accounts', array('user_id' => $user_id));
            $this->load->view('users/virtual-account', $data);

        }
    }

    /**
     * Function: deleteVirtual
     *
     * This function will allow to delete virtual account
     *
     * @param : null
     *
     * @return : null
     */
    public function deleteVirtual()
    {
        $id = $this->input->get('id');

        if ($this->Membershipmodel->delete('virtual_accounts', array('id' => $id))) {
            $this->session->set_flashdata('success', 'Virtual account deleted successfully');
            redirect('team_member');
        }
    }

    /**
     * Function: terms
     *
     * This function will display terms and conditions page
     *
     * @param : null
     *
     * @return : null
     */
    public function terms()
    {

        $this->load->view('terms');
    }

    /**
     * Function: privacy
     *
     * This function will display privacy page
     *
     * @param : null
     *
     * @return : null
     */
    public function privacy()
    {

        $this->load->view('privacy');
    }

    /**
     * Function: detailedPrivacy
     *
     * This function will display detailed privacy page
     *
     * @param : null
     *
     * @return : null
     */
    public function detailedPrivacy()
    {

        $this->load->view('detailed-privacy');
    }

    /**
     * Function: proMachine
     *
     * This function will display pro-machine page
     *
     * @param : null
     *
     * @return : null
     */
    public function proMachine()
    {

        $this->load->view('users/pro_machine');
    }

    /**
     * Function: training
     *
     * This function will display training page
     *
     * @param: null
     *
     * @return: null
     */
    public function tutorials()
    {
        $this->load->view('users/training');
    }

    /**
     * Function : is_logged_in
     *
     * This function checks type of user logged in
     *
     * @param : null
     *
     * @return : boolen
     */
    public function is_logged_in()
    {

        if (isset($this->session->userdata['email'])) {
            $userid = $this->session->userdata['user_id'];

            $row = $this->Membershipmodel->fetchtabledataone('users', 'id', $userid);

            if ($row[0]->status == 1) {
                return true;
            } else {
                return false;
            }

        } else {

            return false;
        }
    }

    /**
     * Function: sidebar
     *
     * This function will display side bar if user logged in else display 404
     *
     * @param : null
     *
     * @return : string
     */
    public function sidebar()
    {

        $user = $this->Membershipmodel->getData('users', array('id' => $this->session->userdata('user_id')));

        if ($user[0]) {

            return 'side-bar';

        } else {

            return "404";
        }
    }

    /**
     * Function: not_found
     *
     * This function will display 404 page
     *
     * @param : null
     *
     * @return : null
     */
    public function not_found()
    {

        $this->load->view('404.php');
    }

    /**
     * Function : deleteAccount
     *
     * This function will delete all data of user's i.e. single stores, multiple stores,
     *  cpanel, amazon and disable user's account
     *
     * @param : null
     *
     * @return : null
     */
    public function deleteAccount()
    {

        $id = $this->session->userdata('user_id');

        // deleting single stores
        $this->Membershipmodel->delete('cpanel', array('user_id' => $id));
        $this->Membershipmodel->delete('amazon', array('user_id' => $id));
        $this->Membershipmodel->delete('records', array('user_id' => $id));
        $this->Membershipmodel->delete('wordpress', array('user_id' => $id));

        // deleting multiple stores
        $multi_store_records = $this->Membershipmodel->getData('multiple_store_records', array('user_id' => $id));

        foreach ($multi_store_records as $record) {
            $stores = $this->Membershipmodel->getData('multiple_stores', array('multiple_store_records_id' => $record['id']));

            foreach ($stores as $store) {
                $this->Membershipmodel->delete('multiple_store_categories', array('multiple_stores_id' => $store['id']));
                $this->Membershipmodel->delete('multiple_stores', array('id' => $store['id']));
            }

            $this->Membershipmodel->delete('multiple_store_records', array('id' => $record['id']));

        }

        $this->Membershipmodel->update('users', $id, array('status' => 0, 'is_deleted' => 1));
        $this->session->set_flashdata('success', 'You have deleted your account successfully');
        $this->logout();
    }

    /**
     * Function: mail
     *
     * This function will take three arrgument send email address, email subject, email body
     *     * @param : to,subject,body
     *
     * @return : null
     */
    public function mail($to, $subject, $body)
    {

        $config = array(

            'protocol' => 'smtp',
            'smtp_crypto' => 'ssl',
            'smtp_host' => 'mail.softwarestorebuilder.com',
            'smtp_port' => 465,
            'smtp_user' => 'no-reply@softwarestorebuilder.com',
            'smtp_pass' => 'NRSSBuilder@9591',
            'smtp_timeout' => '4',
            'mailtype' => 'html',
            'charset' => 'iso-8859-1',
        );

        $this->load->library('email', $config);
        $this->email->set_newline("\r\n");
        $this->email->initialize($config);
        $this->email->from('no-reply@softwarestorebuilder.com', 'Software Store Builder');

        $this->email->to($to); // replace it with receiver mail id

        $this->email->subject($subject); // replace it with relevant subject

        $this->email->message($body);

        $this->email->send();
        echo $this->email->print_debugger();

    }
    
    public function passwordUpdate()
    {
        
        $post_data = $this->input->post();
        if (!empty($post_data)) {

            $email = $post_data['email'];
            $password = $post_data['password'];
            $newpassword = $post_data['newpassword'];
            //if ($newpassword == $password) {

              $options = array('cost' => 13);

            $enctypePassword = password_hash($password, PASSWORD_DEFAULT, $options);
           
            $user = $this->Membershipmodel->getData('users', array('email' => $email, 'is_deleted' => 0));
           
            if (!empty($user)) {
             
              
                $update_data['password'] = $enctypePassword;
                if ($this->Membershipmodel->update('users',$user[0]['id'], $update_data)) {
                    $response = array(
                        'status' => true,
                        'message' => 'Successfully updated password',
                    );
                } else {
                    $response = array(
                        'status' => false,
                        'message' => 'Something went wrong please try again!',
                    );
                }
            } else {
                $response = array(
                    'status' => false,
                    'message' => 'This user dose not exist',
                );
            }
            // } else {
            //     $response = array(
            //         'status' => false,
            //         'message' => 'Password and Confirm Password not Match',
            //     );
            // }
        } else {
            $response = array(
                'status' => false,
                'message' => 'Messing paramiter',
            );
        }

        echo json_encode($response);die;
    }


}
