<?php
defined('BASEPATH') OR exit('No direct script access allowed');

// cpanel uapi
include("library/cpanelupi/CpanelManager.php");
require_once('library/wordpress/wp_hash/src/class-phpass.php');
use ApaiIO\ApaiIO;
use ApaiIO\Configuration\GenericConfiguration;
use ApaiIO\Operations\Search;
use ApaiIO\Request\GuzzleRequest;
use GuzzleHttp\Client;
use TBETool\PasswordGenerator;

/**
 * @property  Envato
 * @property  Membershipmodel Membershipmodel
 * @property  StoreModel StoreModel
 */
class SingleSiteController extends CI_Controller{
   
    public function __construct(){
		
         parent:: __construct();
         $this->load->library('Envato');
         $this->load->library('AmazonManager');
        $this->load->helper('form');
        $this->load->helper('url');
 	}


    /**
     * Function: index
     *
     * This function loads the index page for adding new site
     *
     * @param : null
     *
     * @return : null
     */
    public function index(){

        $id = $this->session->userdata('user_id');
        $data['cpanel_records'] = $this->StoreModel->getData('cpanel',array('user_id'=>$id));
        $data['envato_records'] = $this->StoreModel->getData('envato',array('user_id'=>$id));
        $data['amazon_records'] = $this->StoreModel->getData('amazon',array('user_id'=>$id));
        $this->load->view('store/index',$data);
     }
    

    
     /**
      * Function: _generateWordpressHashPassword
      *
      * This function hash the password entered by user and return hash password entered by user.
      *
      * @param: password
      * @return: string
      */
     private function _generateWordpressHashPassword($password){

          $wp_hasher = new PasswordHash(8, true);
          return $wp_hasher->HashPassword( trim($password) );
     }


    
  
    /**
     * Function: host_details
     *
     * STEP 1: cPanel and Monetization Details This function checks the credentials given by user, for cPanel and Amazon, if credentials are    valid data will be site to the data base and user will move to next step. if credentials are not valid it will throw an error.
     *
     * @param : null
     *
     * @return : null
    */
   public function host_details(){

       if($this->input->post('submit')){  
          
           $cpanel_id = $this->input->post('cpanel_id');
           $envato_id = $this->input->post('envato_id');
           $amazon_id = $this->input->post('amazon_id');
           $installation_path =preg_replace('/[^A-Za-z0-9-]/', '', $this->input->post('installation_path'));

           if($this->input->post('installation_path') == "public_html"){
               $installation_path = "";
           }

           //generate site username, database and password
           $hash_password = $this->_generateWordpressHashPassword($this->input->post('blog_password'));
           $passwordGenerator = new PasswordGenerator(5, 1, 'lower_case,numbers');
           
           $wordpress_user_db = $passwordGenerator->generate();
           $passwordGenerator2 = new PasswordGenerator(12);
           $wordpress_db_pwd = $passwordGenerator2->generate();

           $wordpress = array(
                     
                            'blog_title' => $this->input->post('blog_title'),
                            'username' => $this->input->post('blog_username'),
                            'password' => $this->input->post('blog_password'),
                            'hash_password' => $hash_password,
                            'db_username' => $wordpress_user_db,
                            'db_password' => $wordpress_db_pwd,
                            'db_name' => $wordpress_user_db,
                            'user_id' => $this->session->userdata('user_id')
                         );

           $this->session->set_userdata('wordpress',$wordpress);

        
           /* STEP 1: Create Records tables record */
           
           $blog_title = array(

                           'blog_title' => $this->input->post('blog_title'),
                           'user_id' => $this->session->userdata('user_id'),
                           'cpanel_id'=> $cpanel_id,
                           'envato_id' => $envato_id,
                           'amazon_id' =>$amazon_id,
                           'installation_path' => $installation_path
                          );

          // insert new record in records table and return last insert Id
          if($record_id = $this->StoreModel->save('records',$blog_title))
             {   
                 $this->StoreModel->save('wordpress', $wordpress,$record_id);
                 redirect('category'.'?id='.$record_id);
             }
          
         }
          return false;
       }
 



       /**
        * Function: amazon_category
        *
        * STEP 2: Niche Selection
        * This function stores the Niche Selection details in categories table.
        *
        * @param : null
        *
        * @return : null
        */

     public function amazon_category(){
         
        if($this->input->post('submit')){  
                                             
            $categories = $this->input->post('category');
            $id = $this->input->post('record_id');
            $record_id = array('id' => $id);
            $records  = $this->StoreModel->getRecords($record_id);
            $theme_id = $records[0]['theme_id'];  
            $amazon_id = $records[0]['amazon_id'];
            $video_category =$this->input->post('video_category');
            $meta_keyword = $this->input->post('meta_keyword');
            $meta_description = $this->input->post('meta_description');


            if((!empty($video_category)) && ($video_category == 1)) {

                if(empty($categories[0]['keyword'])){
                    echo "Enter Keyword";   die;
                }

                else
                {

                    if(empty($categories[0]['no_of_products']) || $categories[0]['no_of_products'] <= 0){

                        $this->session->set_flashdata('error','Please Enter a Valid No of Post');
                        redirect('category?id='.$id);
                    }

                    else

                    {
                        $no_of_products = $categories[0]['no_of_products'];
                    }
                }


                // Check Envato on Keyword before User Proceed on next Action
                $user_id = $this->session->userdata('user_id');
                $envato_post =  $this->StoreModel->getData('envato',array('user_id' => $user_id));
                $token = $envato_post[0]['access_token'];
                $ref_token = $envato_post[0]['refresh_token'];

                $no_of_products = $categories[0]['no_of_products'];
                $newkeyword = urlencode($categories[0]['keyword']);

                $last_date = strtotime($envato_post[0]['modified']);
                $curr_date = strtotime(date("Y-m-d h:i:s"));

                $hours = $curr_date - $last_date;

                // Need to Update user access token
                if($hours >= 3600 || $hours <= 0){

                    $refresh_token_res = $this->envato->refresh_access_token('https://api.envato.com/token',$ref_token);

                    if(empty($refresh_token_res->error)){
                        $data_envato['access_token'] = $refresh_token_res->access_token;
                        $data_envato['modified'] =  date("Y-m-d h:i:s");

                        $this->Membershipmodel->updateData('envato',$user_id,$data_envato);
                        $token = $refresh_token_res->access_token;
                    }
                }
                $url = 'https://api.envato.com/v1/discovery/search/search/item?page_size='.$no_of_products.'&term='.$newkeyword.'&site=codecanyon.net';

                $envato_data = $this->envato->fetch_products($url,$token);

                $envato_data_decode = json_decode($envato_data);

                if(empty($envato_data_decode->matches)){

                    $this->session->set_flashdata('error','No results found on this "'.$categories[0]['keyword'].'" keyword');
                    redirect('category?id='.$id);
                }
                    
               foreach ($categories as $category){
                   $category_name = $this->StoreModel->getField('name','amazon_categories',$category['id']);
                $data = array(

                              'record_id' => $id,
                              'user_id' => $this->session->userdata('user_id'),
                                'category_id' => $category['id'],
                                'category' => $category_name,
                              'keyword' => $category['keyword'],
                              'no_of_products' => $category['no_of_products'],
                              'video_category' => $video_category,
                              'meta_keyword' => $meta_keyword,
                              'meta_description' => $meta_description,
                              'status' => 1,
                              'created' => date('Y-m-d H:i:s')
                         );
                       
                 
                 $this->StoreModel->save('categories',$data);

                }
             
             }
          
           else
           
            {    
                   $id = $this->input->post('record_id');
                   $record_id = array('id' => $id);
                   $records  = $this->StoreModel->getRecords($record_id);

                   $video_category =$this->input->post('video_category');
                   $meta_keyword = $this->input->post('meta_keyword');
                   $meta_description = $this->input->post('meta_description');
                   $category  = $this->input->post('category');
                   $category_id = $category[0]['id'];
                   $category_keyword = $category[0]['keyword'];
                   $total_no_post = $category[0]['no_of_products'];
                  
                   $titktalk_arr  = $this->input->post('titktalk_arr');
                   $explode_array =  explode(',', $titktalk_arr[0]);
                   $category_no_of_products = count($explode_array);
                    $category_name = $this->StoreModel->getField('name','amazon_categories',$category_id);
                   $encoded_data =  json_encode($titktalk_arr);

                if($titktalk_arr[0] == ''){
                    $this->session->set_flashdata('error','Please Select Products in Custom Selection');
                    redirect('category?id='.$id);
                }

                   if((!empty($video_category)) && ($video_category == 2)) {

                     if(empty($categories[0]['keyword'])){
                          
                            echo "Enter Keyword";   die;
                   
                     }

                    else 
                     {
                 
                      $data = array(
                                      'record_id' => $id,
                                      'user_id' => $this->session->userdata('user_id'),
                                      'keyword' => $category_keyword,
                                      'category_id' => $category_id,
                                      'category' => $category_name,
                                      'no_of_products' => $category_no_of_products,
                                      'total_products' => $total_no_post,
                                      'data' => $encoded_data,
                                      'video_category' => $video_category,
                                      'meta_keyword' => $meta_keyword,
                                      'meta_description' => $meta_description,
                                      'status' => 1,
                                      'created' => date('Y-m-d H:i:s')
                                   );
                     

                      $this->StoreModel->save('categories',$data);

                    }  
                  }
              }
                   
                $this->StoreModel->update_records($id,array('step_2'=>1));
                redirect('theme?id='.$id);
          }
        
         else
          {   
              $record_id = $this->input->get('id');
              $blog_title = $this->StoreModel->getRecords(array('id' => $record_id));
              $amazon_id = $this->StoreModel->getField('amazon_id','records',$record_id);
              $region_id =$this->StoreModel->getField('region_id','amazon',$amazon_id);
              $data['categories'] = $this->StoreModel->getData('amazon_categories',array('region_id'=>$region_id));

              $data['video_categories'] = $this->StoreModel->getTable('video_categories');
              $data['title'] = $blog_title[0]['blog_title']; 
              $this->load->view('store/amazon-category',$data);
          }
      }



       
       /**
        * Function: choose_theme
        *
        * STEP 3: Lists all the themes, setTheme, set siteLogo (logo url and description)
        * This function fetch all themes to the user.
        *
        * @param : null
        *
        * @return : null
        */
      public function choose_theme(){
        
        $data['themes'] = $this->StoreModel->getData('themes',array('recommend'=>0));
        $data['recommends'] = $this->StoreModel->getData('themes',array('recommend'=>1));
        $this->load->view('store/choose-theme',$data);
      } 

      
      

     /**
      * Function: setTheme
      *
      * This function update the selected theme id in the records table
      *
      * @param : null
      *
      * @return : null
      */
     public function setTheme(){

        $id = $this->input->post('id');
        $thmeid = $this->input->post('theme_id');

        if(!empty($thmeid)){
              
            $data = array('theme_id' => $this->input->post('theme_id'),
                          'step_3' => 1
                         );
            
            $recomend = $this->StoreModel->getField('recommend','themes',$data['theme_id']);
        
            if($this->StoreModel->update_records($id,$data)){
                if($recomend == 1)
                {   
                    $set_status = array('statuses_id'=>1);
                    $this->StoreModel->update_records($id,$set_status);
                    redirect('buttons?id='.$id);
                }

            }
        else
            {
                $this->session->set_flashdata('error','Theme could not be saved');
                redirect('SingleSiteController/view_stores');
            }
        
        }

        else
         {
              $this->session->set_flashdata('error','Theme selection is required');
              redirect('theme?id='.$this->input->post('id'));
         }

      }

     



     /**
      * Function: siteLogo
      *
      * store site url and logo in wordpress table
      *
      * @param : null
      *
      * @return : null
      */
     public function siteLogo(){
         
        if($this->input->post('submit')) {

            $logo_upload = 0;

            $record_id = $this->input->post('id');
            $wordpress_id = $this->StoreModel->getField('wordpress_id','records',$record_id);
            $logo_url = $this->input->post('logo_url');
            $upload_url = $this->input->post('upload_url');

            if(empty($logo_url)){

                if($_FILES['file']['name'] != '' || $upload_url ==''){
                    $config['upload_path'] = './uploads';
                    $config['allowed_types'] = 'jpeg|jpg|png';
                    $config['max_size']   = 500;

                    $this->load->library('upload', $config);
                    $this->upload->initialize($config);

                    if (!$this->upload->do_upload('file')) {
                        $error = array('error' => $this->upload->display_errors());
                        $this->session->set_flashdata('error',$error['error']);

                        redirect('site-logo?id='.$record_id);
                    }

                    $logo_url = FCPATH.'uploads/'.$_FILES["file"]["name"];

                    // Upload Image on Amazon S3
                    try{
                        $amazon = new AmazonManager();
                        $amazon->connect(AWS_REGION,S3_ACCESS_KEY,S3_SECRET_KEY);
                        $s3_url = $amazon->s3Upload($logo_url,S3_BUCKET);

                        $logo_url = $s3_url;

                    }catch(Exception $e){
                        echo $e->getMessage();
                        $this->session->set_flashdata('error',$e->getMessage());
                        die();
                    }
                }
                else{
                    $logo_url = $upload_url;
                }

                $logo_upload = 1;

                // Delete Image
                unlink(FCPATH.'uploads/'.$_FILES["file"]["name"]);
            }


            $data = array('logo_url' => $logo_url,
                          'description' => $this->input->post('description'),
                            'logo_upload' => $logo_upload
                         );

            $this->StoreModel->updateData($wordpress_id,'wordpress',$data);

            $this->session->set_flashdata('success','Site creating process started');

            $command = "php ".FCPATH."index.php CreateSiteCronController SingleSiteCreate > /dev/null &";
            exec($command);

            redirect('view-site');

        }
            
           $records  = $this->StoreModel->getRecords(array('id' => $this->input->get('id'))); 
           $wordpress_arr = array('id' => $records[0]['wordpress_id']);
           $wordpress_records  = $this->StoreModel->getWordpressRecords($wordpress_arr);
           $logo_url = $wordpress_records[0]['logo_url'];
           $logo_description = $wordpress_records[0]['description'];
           $is_upload = $wordpress_records[0]['logo_upload'];
           $data['logo_url'] = $logo_url;
           $data['logo_description'] = $logo_description;
           $data['is_upload'] = $is_upload;
             
           $this->load->view('store/site-logo.php',$data);
       }

    /**
     * Function: chooseButton
     *
     * This Function will store button id in records table
     *
     * @param : null
     *
     * @return : null
    */
    function chooseButton()
    {

        $id = $this->input->post('id');

        if($this->input->post('submit'))
        {
            $button_id = $this->input->post('button_id');


            if(empty($button_id))
            {
                $button_id = 1;
            }

            if($this->StoreModel->update_records($id,array('button_id'=>$button_id)))
            {
                redirect('site-logo?id='.$id);
            }

        }

        $data['buttons'] = $this->StoreModel->getTable('buttons');
        $this->load->view('store/buttons',$data);
    }


    public function uploadImage(){

        if($this->input->is_ajax_request())
        {

            $name = $_FILES['file']['name'];
            $id = $this->session->userdata('user_id');

            $data = array();

            if (!empty($name)) {

                $explode = explode('.', $name);
                $ext = end($explode);
                $tmp_name = $_FILES['file']['tmp_name'];
                $path = 'assets/img/user_upload/';
                $file_name = time().'.'.$ext;

                move_uploaded_file($tmp_name, $path.$file_name);

                $data['image'] = $file_name;
            }

            if ($ext != 'png' && $ext != 'jpg' && $ext != 'jpeg') {
                $res = array(
                    'status' => 3,
                    'message' => 'Please select valid image'
                );
                echo json_encode($res);
                die;
            }

            if($this->Membershipmodel->update('users',$id,$data))
            {
                $res = array(
                    'status' => 1,
                    'path' => site_url() . $path . $file_name,
                    'message' => 'Profile image updated successfully'
                );
                echo json_encode($res);


            }else{

                $res = array(
                    'status' => 0,
                    'message' => 'Something went wrong'
                );
                echo json_encode($res);
            }
        }

        else{

            $data['sidebar'] = $this->sidebar();
            $this->load->view('users/profile',$data);
        }
    }
     

      /**
       * Function: view_stores
       *
       * This function reads or display all the sites associated to the user.
       *
       * @param: null
       *
       * @return : null
       */
      public function view_stores(){
         
         if($this->session->userdata('account_type') == 'team'){
           
           $id = array('user_id'=> $this->session->userdata('user_id'));
           $data['sites'] = $this->StoreModel->getData('records',$id,'desc');
           $this->load->view('store/view-stores',$data);
         }
         elseif($this->session->userdata('account_type') == 'user')
         {
           $id = array('user_id'=> $this->session->userdata('user_id'));
           $data['sites'] = $this->StoreModel->getData('records',$id,'desc');
           $this->load->view('store/view-stores',$data);
         }
         else
         {
             die();
         }
      }



     /**
      * Function: editSingleSite
      *
      * This function will user to edit previous actions
      *
      * @param: null
      *
      * @return: null
     */
      public function editSingleSite(){
           
         if($this->input->post('type') == 'edit')
         {
               //echo "hii"; print_r($_POST); die;
             $cpanel_id = $this->input->post('cpanel_id');
             $envato_id = $this->input->post('envato_id');
             $installation_path =preg_replace('/[^A-Za-z0-9-]/', '', $this->input->post('installation_path'));

             //generate site username, database and password
             $hash_password = $this->_generateWordpressHashPassword($this->input->post('blog_password'));
             $passwordGenerator = new PasswordGenerator(5, 1, 'lower_case,numbers');
           
             $wordpress_user_db = $passwordGenerator->generate();
             $passwordGenerator2 = new PasswordGenerator(12);
             $wordpress_db_pwd = $passwordGenerator2->generate();

             $wordpress = array(
                       
                              'blog_title' => $this->input->post('blog_title'),
                              'username' => $this->input->post('blog_username'),
                              'password' => $this->input->post('blog_password'),
                              'hash_password' => $hash_password,
                              'db_username' => $wordpress_user_db,
                              'db_password' => $wordpress_db_pwd,
                              'db_name' => $wordpress_user_db,
                              'user_id' => $this->session->userdata('user_id')
                           );

             //$this->session->set_userdata('wordpress',$wordpress);

        
             /* STEP 1: Create Records tables record */
           
             $blog_title = array(

                             'blog_title' => $this->input->post('blog_title'),
                             'user_id' => $this->session->userdata('user_id'),
                             'cpanel_id'=> $cpanel_id,
                             'envato_id' => $envato_id,
                             'installation_path' => $installation_path
                         );

          
             $site_record_id = $this->input->post('site_record_id');   

             if($record_id = $this->StoreModel->updateData($site_record_id,'records',$blog_title))
             {    
                 
                 $get_record_details = $this->StoreModel->getRecords(array('id' => $site_record_id));
                 $wordpress_ID = $get_record_details[0]['wordpress_id'];  
                 
                 $this->StoreModel->updateData($wordpress_ID,'wordpress',$wordpress);
                 
                 redirect('edit-category?id='.$site_record_id);
             }
           
          }
          
         else
          {
             $id = $this->session->userdata('user_id');
             $site_record_id = $this->input->get('id');
             $get_record = $this->StoreModel->getRecords(array('id' => $site_record_id));

             $wordpress_ID = $get_record[0]['wordpress_id'];
             $get_wordpress_record = $this->StoreModel->getWordpressRecords(array('id'=>$wordpress_ID));

             $arr = array_merge($get_record[0],$get_wordpress_record[0]);

             $data['single_site_record'] = $arr;

             $data['cpanel_records'] = $this->StoreModel->getData('cpanel',array('user_id'=>$id));
             $data['envato_records'] = $this->StoreModel->getData('envato',array('user_id'=>$id));
             $data['amazon_records'] = $this->StoreModel->getData('amazon',array('user_id'=>$id));
             $data['record_id'] = $site_record_id;
           
             $this->load->view('store/edit_single_site.php',$data);
          }
           
       }
     

       


       /**
        * Function: editCategory
        *
        * This function will update the site associated to the user.
        *
        * @param : null
        *
        * @return : null
        */
       public function editCategory(){
        
        if($this->input->post('type') == 'edit_niche')
        {


            $id = $this->input->post('record_id');  
            $site_title = $this->input->post('site_title');
            $categories = $this->input->post('category');    
            $video_category =$this->input->post('video_category');
            $meta_keyword = $this->input->post('meta_keyword');
            $meta_description = $this->input->post('meta_description');
            $category_id = $this->input->post('category_id');

            if((!empty($video_category)) && ($video_category == 1)) {


                if(empty($categories[0]['keyword'])){
                     echo "Enter Keyword";   die;
                }
               
                else
                {
                  
                  if(empty($categories[0]['no_of_products'])){
                
                         $no_of_products = 0;
                   }
                
                  else
               
                  {
                        $no_of_products = $categories[0]['no_of_products'];
                  }
               }

                // Check Envato on Keyword before User Proceed on next Action
                $user_id = $this->session->userdata('user_id');
                $envato_post =  $this->StoreModel->getData('envato',array('user_id' => $user_id));
                $token = $envato_post[0]['access_token'];
                $ref_token = $envato_post[0]['refresh_token'];

                $no_of_products = $categories[0]['no_of_products'];
                $newkeyword = urlencode($categories[0]['keyword']);

                $last_date = strtotime($envato_post[0]['modified']);
                $curr_date = strtotime(date("Y-m-d h:i:s"));

                $hours = $curr_date - $last_date;

                // Need to Update user access token
                if($hours >= 3600 || $hours <= 0){

                    $refresh_token_res = $this->envato->refresh_access_token('https://api.envato.com/token',$ref_token);

                    if(empty($refresh_token_res->error)){
                        $data_envato['access_token'] = $refresh_token_res->access_token;
                        $data_envato['modified'] =  date("Y-m-d h:i:s");

                        $this->Membershipmodel->updateData('envato',$user_id,$data_envato);
                        $token = $refresh_token_res->access_token;
                    }
                }
                $url = 'https://api.envato.com/v1/discovery/search/search/item?page_size='.$no_of_products.'&term='.$newkeyword.'&site=codecanyon.net';

                $envato_data = $this->envato->fetch_products($url,$token);

                $envato_data_decode = json_decode($envato_data);

                if(empty($envato_data_decode->matches)){
                    $this->session->set_flashdata('error','No results found on this "'.$categories[0]['keyword'].'" keyword');
                    redirect('edit-category?id='.$id);
                }
                     
                    
               foreach ($categories as $category){
                       
                $category_name = $this->StoreModel->getField('name','amazon_categories',$category['id']);

                $data = array(
                              'record_id' => $id,
                              'user_id' => $this->session->userdata('user_id'),
                                'category_id' => $category['id'],
                                'category' => $category_name,
                              'keyword' => $category['keyword'],
                              'no_of_products' => $category['no_of_products'],
                              'video_category' => $video_category,
                              'meta_keyword' => $meta_keyword,
                              'meta_description' => $meta_description,
                              'status' => 1,
                              'created' => date('Y-m-d H:i:s')
                         );

                 $store_category_id = $this->input->post('store_category_id');
                 $this->StoreModel->updateData($store_category_id,'categories',$data);


                }
             
             }
          
           else
            {

               $id = $this->input->post('record_id');  
               $site_title = $this->input->post('site_title');
               $video_category =$this->input->post('video_category');
               $meta_keyword = $this->input->post('meta_keyword');
               $meta_description = $this->input->post('meta_description');
               $category  = $this->input->post('category');
               $category_id = $category[0]['id'];
               $category_keyword = $category[0]['keyword'];
               $titktalk_arr  = $this->input->post('titktalk_arr');
               $explode_array =  explode(',', $titktalk_arr[0]);
               $category_no_of_products = count($explode_array);
               $encoded_data =  json_encode($titktalk_arr);
               $category_name = $this->StoreModel->getField('name','amazon_categories',$category_id);
                   
                   if((!empty($video_category)) && ($video_category == 2)) {

                       if($titktalk_arr[0] == ''){
                           $this->session->set_flashdata('error','Please Select Products in Custom Selection');
                          redirect('edit-category?id='.$id);
                       }

                
                     if(empty($categories[0]['keyword'])){
                          
                            echo "Enter Keyword";   die;
                   
                     }
                       
                    else 
                     {
                         $data = array(  'record_id' => $id,
                                      'user_id' => $this->session->userdata('user_id'),
                                        'category_id' => $category_id,
                                      'category' => $category_name,
                                      'keyword' => $category_keyword,
                                      'no_of_products' => $category_no_of_products,
                                      'data' => $encoded_data,
                                      'video_category' => $video_category,
                                      'meta_keyword' => $meta_keyword,
                                      'meta_description' => $meta_description,
                                      'status' => 1,
                                      'created' => date('Y-m-d H:i:s')
                                   );
                     

                       $store_category_id = $this->input->post('store_category_id');

                       $this->StoreModel->updateData($store_category_id,'categories',$data);


                    }  
                  }
              }
                   
                $this->StoreModel->update_records($id,array('step_2'=>1));
                redirect('theme?id='.$id);
        }

        else
        {
          
         $record_id = $this->input->get('id');
         $amazon_id = $this->StoreModel->getField('amazon_id','records',$record_id);
         $region_id =$this->StoreModel->getField('region_id','amazon',$amazon_id);
         $data['categories'] = $this->StoreModel->getData('amazon_categories',array('region_id'=>$region_id));
            //fetch data for niche selection
         $data['store_category'] = $this->StoreModel->getData('categories', array('record_id'=>$record_id,'status'=>1));

         if(!empty($data['store_category'])){

             $category_id = $data['store_category'][0]['category_id'];
             $data['category_name'] = $this->StoreModel->getField('name','amazon_categories',$category_id);
             $data['category_id']  = $category_id;
         }else{
             $data['category_id']  = '';
         }

         $data['blog_title'] = $this->StoreModel->getField('blog_title','records',$record_id);
         $data['video_categories'] = $this->StoreModel->getTable('video_categories');
         $data['site_record_id'] = $record_id;

         $this->load->view('store/edit-category',$data);

        }
      }


      
      

       /**
        * Function: preview
        *
        * This function will preview selected products
        *
        * @param : null
        *
        * @return : null
       */
       public function preview(){
         
         $preview_id =  $this->input->get('preview-id');
         $last_id_single_site_temp =  $this->input->get('id');
         $user_id = $this->session->userdata('user_id');
         $fetch_custom_data = $this->StoreModel->getField('data','single_site_temp',$last_id_single_site_temp);
         $decode_fetch_custom_data = json_decode($fetch_custom_data);
         if (array_key_exists($preview_id,$decode_fetch_custom_data))
         {
            print_r($decode_fetch_custom_data[$preview_id]->getembedurl); 
         }
       }
      
      
      
      
      /**
       * Function: load_more
       *
       * This function will load more products from codecanyon api
       *
       * @param : null
       *
       * @return : null
      */
      public function load_more(){
          
          $no_of_products = 10;
          $next_page_id = $this->input->post('next_page_id');
          $next_page_id = $next_page_id + 1;
          $last_inserted_id = $this->input->post('last_inserted_id');
          $site_id = $this->input->post('site_id');
          
          $sitekeyword = $this->input->post('siteKeyword');
          $keywordSearch = urlencode($sitekeyword);
          $newkeyword = str_replace('+', '%20', $keywordSearch);
          
          //google cse
          $apiKey = 'AIzaSyAk8-pG2ZA6qexAIc5MgB66TAfjAUVSbCA';
          $apiId = '004764022391982851886:yfsnwcpiif1'; 
          $query = $newkeyword;
               
          $items = array();
          
                    
                     //google cse crawler
                     $ch = curl_init();
                     $request = "https://www.googleapis.com/customsearch/v1?" ."q=" . $query . "&cx=".$apiId ."&key=" . $apiKey ."&last=" . ($next_page_id);

                     curl_setopt($ch, CURLOPT_URL, $request);
                     curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                     curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);

                     $output = curl_exec($ch);
                     $output = json_decode($output);
                    
                   
                    

                    
                    foreach( $output->items as $result ) {
                   
                
                      if (!empty($result->link)) 
                    
                        $items[] = $result->link;

                       } 
                    
                    
            
            $totalResults = count($items);
            $storeTikTalkArray = array();
            $storeTikTalkArray['data'] = $this->storeTiktalkArray($totalResults,json_encode($items));
            
            $fetch_custom_data = $this->StoreModel->getField('data','single_site_temp',$last_inserted_id);
            $decode_fetch_custom_data = json_decode($fetch_custom_data);
            $updated_array = array_merge($decode_fetch_custom_data,$storeTikTalkArray['data']);   
                   
            //update the tiktok response array in single_site_temp table in database
                   
            $siteArr =  array('data' => json_encode($updated_array));
                   
            $is_updated = $this->StoreModel->updateData($last_inserted_id,'single_site_temp', $siteArr); 
                    
            if($is_updated){
                
                $data['arr'] = $storeTikTalkArray['data'] ;
                $data['last_id'] = $last_inserted_id;
                $data['next_page_id'] = $next_page_id;
                $data['tiktok_keyword'] = $sitekeyword;
                   
                $this->load->view('load-more', $data);
                
             }
            
         }
      
     
     
      /**
       * Function: single_custom
       *
       * This function will codecanyon products and load in a popup modal, where user can select custom products
       *
       * @param : null
       *
       * @return : null
      */
      public function single_custom(){   
          
        if(($this->input->is_ajax_request()) && ($this->input->post('type') == 'select') && ($this->input->post('selectedValue') == 2))
         {

            $user_id = $this->session->userdata('user_id');
            $total_post = $this->input->post('total_post');
            $oldKeyword = $this->input->post('oldKeyword');


            if($total_post == ''){
                $no_of_products = $this->input->post('count') * 2;

            }else{
                $no_of_products = $this->input->post('total_post') * 2;
            }

            $sitekeyword = $this->input->post('siteKeyword');
            $keywordSearch = urlencode($sitekeyword);
            $newkeyword = str_replace('+', '%20', $keywordSearch);

             if($no_of_products <= 0 || $no_of_products == ''){
                 $data['message'] = 'Please enter no of post !';
                 echo $data['message'];
                 die();
             }

             if($this->input->post('count') >= 51){
                 $data['message'] = 'Please enter less than 50 custom products';
                 echo $data['message'];
                 die();
             }

            if(empty($sitekeyword)){
                $data['message'] = 'Please enter the keyword !';
                echo $data['message'];
                die();
            }

            // User Access Token
            $envato_data =  $this->StoreModel->getData('envato',array('user_id' => $user_id));
            $access_token = $envato_data[0]['access_token'];
            $last_date = $envato_data[0]['modified'];
            $refresh_token = $envato_data[0]['refresh_token'];

            // Covert into Time
             $last_dated = strtotime($last_date);
             $curr_dated = strtotime(date("Y-m-d h:i:s"));

             $hours = $curr_dated - $last_dated;

             // Check User access token is expire or not
             if($hours >= 3600 || $hours >= 0){

                 $refresh_token_res = $this->envato->refresh_access_token('https://api.envato.com/token',$refresh_token);

                 if(empty($refresh_token_res->error)){
                     $data['access_token'] = $refresh_token_res->access_token;
                     $data['modified'] =  date("Y-m-d h:i:s");

                     $this->Membershipmodel->updateData('envato',$user_id,$data);
                     $access_token = $refresh_token_res->access_token;
                 }
             }

            $url = "https://api.envato.com/v1/discovery/search/search/item?page_size=".$no_of_products."&term=".$newkeyword."&site=codecanyon.net";

            $response = $this->envato->fetch_products($url,$access_token);
            $envato_decode_data = json_decode($response);

            if(empty($envato_decode_data->error)){

                $record_id = $this->input->post('site_id');

                $response_data = array(
                    'user_id' => $user_id,
                    'record_id' => $record_id,
                    'data' => $response,

                );

                if($this->Membershipmodel->exists('single_site_temp',array('record_id'=>$record_id))){
                    $this->Membershipmodel->updateSiteTemp($record_id,$response_data);
                }else{
                    $this->StoreModel->insertData('single_site_temp', $response_data);
                }


                if(!empty($total_post) and $oldKeyword == $sitekeyword){
                   $site_temp_data = $this->StoreModel->getData('categories',array('record_id' => $record_id));
                   $site_temp_data2 = $this->StoreModel->getData('single_site_temp',array('record_id' => $record_id));
                   $data['site_data'] = $site_temp_data[0]['data'];
                   $data['products'] = json_decode($site_temp_data2[0]['data']);

                }else{
                    $data['products'] = json_decode($response);
                }

                $this->load->view('template-view', $data);
            }
            else{
                echo json_encode($envato_decode_data->error);
                die();
            }

                 }
       
               else
                {

                   $return['message'] = 'Please enter the keyword !';
                   $ret = json_encode($return);
                   echo $ret;
                }
         
       }
    
   //create and store in an array for tiktalk embed data
      public function storeTiktalkArray($totalResults,$data){
             
             if(!empty($data)){
                 $array = json_decode($data);
             } 
             
             
             $totalResults = $totalResults - 1 ;
             $array1= array();
             $dataArray = array();
             
             
             foreach($array as $i => $item) {
                 
                $getformatedurl = $array[$i];  
                $gettiktokembedurl = 'https://www.tiktok.com/oembed?url='.$getformatedurl;  
                $jsondatatiktokurl = $this->curl_file_get_contents($gettiktokembedurl); 
                $getembed = json_decode($jsondatatiktokurl);     
          
                if(empty($getembed->html)){
              
                }
          
               else
                {  
             
                  $dataArray['title'] = $getembed->title;   
                  $dataArray['getembedurl'] = $getembed->html;  
                  $dataArray['thumbnail_url'] = $getembed->thumbnail_url;  
                  array_push($array1,$dataArray); 
                } 
                 
             }
             
             return $array1;    
       }



      /**
       * Function: deleteStore
       *
       * This function delete the site associated to the user.
       *
       * @param : null
       *
       * @return : null
       */
     public function deleteStore(){
        $id = $this->input->get('id');
        $wordpress_id = $this->StoreModel->getField('wordpress_id','records',$id);
        $this->StoreModel->delete('categories',array('record_id'=>$id));
        $this->StoreModel->delete('wordpress',array('id'=>$wordpress_id));
        $this->StoreModel->delete('records',array('id'=>$id));
        $this->session->set_flashdata('success','Site deleted successfully');
        redirect('view-site');
     }

    
     
      /**
       * Function: assignUserList
       *
       * This function will lists all the sites associated to the client created by logged In user.
       *
       * @param : null
       *
       * @return : null
       */
      public function assignUserList(){
        $data['site_id'] = $this->input->get('id');
        $user_id = $this->session->userdata('user_id'); 
        $data['clients'] = $this->StoreModel->getData('client_accounts',array('user_id'=>$user_id)); 
        $this->load->view('store/assign-store',$data);
      }

   
      /**
       * Function: storeClientAssign
       *
       * This function will add single sites assign to client
       *
       * @param : null
       *
       * @return : boolen
      */
    public function storeClientAssign(){

       
       $id = $this->session->userdata('user_id');
       $data = array(
                      'client_id' => $this->input->post('client_id'),
                      'wordpessId' => $this->input->post('wordpessId'),
                      'user_id' => $id
                    );
       
       $site_assign_status = $this->input->post('single_site_status');  

       if($this->StoreModel->exist('sites_assign_client',$data))
        {    
            $result = $this->StoreModel->getData('sites_assign_client',$data);
            if(!empty($result[0]['id']))
            {
                $this->StoreModel->updateData($result[0]['id'],'sites_assign_client',array('is_site_assign_client_status'=>$site_assign_status));
            }else
              {
                 return false;
              }
        }
       else
        {
              $data['is_site_assign_client_status'] = 1;
              $data['is_single_site'] = 1;
              $this->StoreModel->save('sites_assign_client',$data);
              return true;
        }
        
      }



     /**
      * Function: action
      *
      * This function will manage comman action
      *
      * @param : null
      *
      * @return : null
     */
     public function action(){
        $id = array('id' => $this->input->get('id'));
        $data = $this->StoreModel->getRecords($id);
        if($data[0]['step_2'] == 0)
        {
            redirect('category?id='.$this->input->get('id'));
        } 
        elseif($data[0]['step_3'] == 0) 
        {
            redirect('theme?id='.$this->input->get('id'));
        }
        elseif ($data[0]['failed'] == 1){
            redirect('StoreController/editCategory?id='.$id['id']);

        }

       else{
            echo "not found";
        }
       }

  
      
     
    /**
     * Function: curl_file_get_contents
     *
     * This function will get a valid url and return json data
     *
     * @param : url
     *
     * @return : json
    */
    public function curl_file_get_contents($url){ 
        
        $curl = curl_init();
        $userAgent = 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)';
        curl_setopt($curl,CURLOPT_URL,$url);
        curl_setopt($curl,CURLOPT_RETURNTRANSFER,TRUE);
        curl_setopt($curl,CURLOPT_CONNECTTIMEOUT,5);   
        curl_setopt($curl, CURLOPT_USERAGENT, $userAgent); 
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, TRUE);  
        curl_setopt($curl, CURLOPT_AUTOREFERER, TRUE); 
        curl_setopt($curl, CURLOPT_TIMEOUT, 1500); 
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE); 
        $contents = curl_exec($curl);
        curl_close($curl);
        return $contents;
     }



     
     
 }
  