<?php

use TBETool\PasswordGenerator;

/**
 *
 * @property CI_Input input
 * @property CI_Session session
 * @property CI_Form_validation form_validation
 * @property Membershipmodel UserModel
 * @property CI_Email email
 * @property CI_User_agent agent
 * @property CI_Encryption encryption
 */

class PKController extends CI_Controller
{
	function __construct()
	{
		parent:: __construct();
		$this->load->library('form_validation');
		$this->load->library('mailer');
		$this->load->helper('url');
		$this->load->model('Membershipmodel');
		$this->load->library('user_agent');
		$this->load->library('encryption');


	}

	/**
	 * function called by jvzoo with post data
	 */
	public function index()
	{
//        Configure::write('debug', true);
//        $request_data = $this->input->post();
//
//        $mail = new Mailer();
//        $mail->send('anujsharma9196@gmail.com','json data',json_encode($request_data));

		if ($this->input->server('REQUEST_METHOD') == 'POST') {


			if ($this->_pkIpnVerification($this->input->post())) {

				echo 'paykickstart verified::';


				$email = $this->input->post('buyer_email');
				$product_number = $this->input->post('product_id');

					echo 'request is sale::';

					/**
					 * fetch membership level type
					 */
					$membershipLevel = $this->Membershipmodel->fetchtabledataone('membership_levels',paykickstart_product_id,$product_number);

					/**
					 * check if user exists
					 */
					$checkUser = $this->Membershipmodel->fetchtabledataone('users',email,$email);

					echo 'checking user::';
					if (!$checkUser) {
						echo 'no existing user::';
						/**
						 * create new account if membership type is front end
						 */
						if ($membershipLevel[0]->front_end == 1) {
							/**
							 * register new user
							 */
							echo 'request is frontend::';

							$passwordGenerator = new PasswordGenerator();
							$password = $passwordGenerator->generate();
							$options = array(
								'salt' => $this->randomPassword(),
								'cost' => 13 
							   );
							   $hash = password_hash($password, PASSWORD_DEFAULT, $options);
			   
							$explode = explode('@', $email);
							$name = $explode[0];
							$user = array(
								'email' => $email,
								'username' => $name,
								'password' => $hash,
								'registered_by' => 'PayKickstart',
								'status' => 1
							);
							if ($user_id = $this->Membershipmodel->insertData('users',$user))
							{

								$this->curl_post_request($user);
								echo 'user saved::';
								/**
								 * alert user with registration and password
								 * todo : send new formated html email
								 */

								$d = array('username'=>$email,'password'=>$password);
								$body = $this->load->view('welcome_mail',$d,TRUE);
								$this->mail($email,'[IMPORTANT] Your Software Store Builder Account Details.',$body);


								

								/**
								 * Assign membership level
								 */

								$m_level =  array(
									'user_id' => $user_id,
									'membership_level_id' => $membershipLevel[0]->id,
									'assigned_by' => 'PayKickstart'
								);
								if ($this->Membershipmodel->insertData('user_membership_levels',$m_level)) {
									echo 'membership assigned::';

								} else {

									echo 'membership not assigned::';
								}

								

								echo 'User created::';

							} else {
								die('something went wrong. Not able to create your account 1');
							}
						} else {
							/**
							 * send email with invalid request
							 */
							die('new membership request other than front end received. account creation declined');
						}

					} else {
						echo 'user already exists::';
						/**
						 * update user
						 */
						$user = $this->Membershipmodel->getData('users',array('email'=>$email));
						$checkmem = array(
							'user_id' => $user[0]['id'],
							'membership_level_id' => $membershipLevel[0]->id
						);

						$mem_name = $this->Membershipmodel->getField('title','membership_levels',$membershipLevel[0]->id);
						$checkMembership =$this->Membershipmodel->exists('user_membership_levels',$checkmem);
						if (!$checkMembership) {

							echo 'this memebership does not exists::';


							$m_level =  array(
								'user_id' => $user[0]['id'],
								'membership_level_id' => $membershipLevel[0]->id,
								'assigned_by' => 'PayKickstart'
							);
							if ($this->Membershipmodel->insertData('user_membership_levels',$m_level)) {

								$d = array('membership_level'=>$mem_name);
								$body = $this->load->view('upgrade',$d,TRUE);
								$this->mail($email,'Software Store Builder Account Upgraded.',$body);

								echo 'memebership created::';

								echo 'membership updated::';
							} else {
								die('something went wrong. Not able to update your account 2');
							}
						} else {
							echo 'this membership already exists::';
						}
					}

			} else {
				die('PayKickStart verification failed');
			}
		} else {
			die ('request method not supported');
		}

		die();
	}

	public function randomPassword(){

        $alphabet = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        $pass = array(); 
        $alphaLength = strlen($alphabet) - 1; 
        for ($i = 0; $i < 22; $i++) {
            $n = rand(0, $alphaLength);
            $pass[] = $alphabet[$n];
        }
        return implode($pass); 
     } 

	 
	/**
	 * verify jvzipn
	 * @param $request_data
	 * @return bool
	 */


	private function _pkIpnVerification($data)
	{
	    
		$secret_key = 'gdexifaK9q8F';
		// Hash received
		$ipnHash = $data['hash'];

		// Unset encrypted keys
		unset($data['hash'], $data['verification_code']);

		// Trim and ommit empty/null values from the data
		$data = array_filter(array_map('trim', $data));

		// Alphabetically sort IPN parameters by their key. This ensures
		// the params are in the same order as when Paykickstart
		// generated the verification code, in order to prevent
		// hash key invalidation due to POST parameter order.
		ksort($data, SORT_STRING);

		// Implode all the values into a string, delimited by "|"
		// Generate the hash using the imploded string and secret key
		$hash = hash_hmac( 'sha1', implode("|", $data), $secret_key );

		return $hash == $ipnHash;
	}


	public function mail($to,$subject,$body){

		// $config = Array(

		// 	'protocol' => 'smtp',
		// 	'smtp_host' => 'mail.smtp2go.com',
		// 	'smtp_port' => 80,
		// 	'smtp_user' => 'reelApps',
		// 	'smtp_pass' => '(;a)hTL+Q^/t>%3M',
		// 	'smtp_timeout' => '4',
		// 	'mailtype' => 'html',
		// 	'charset' => 'iso-8859-1'
		// );
		
		$config = Array(
            'protocol' => 'smtp',
            'smtp_host' => 'mail.smtp.com',
            'smtp_port' => 80,
            'smtp_user' => 'abhi-sender@vega6.com',
            'smtp_pass' => 'tH9(t*N4yMAnk9XV',
            'smtp_timeout' => '4',
            'mailtype' => 'html',
            'charset' => 'iso-8859-1'
		);
		$this->load->library('email', $config);
		$this->email->set_newline("\r\n");
		$this->email->from('abhi@abhineos.com', 'Software Store Builder');

		$this->email->to($to); // replace it with receiver mail id

		$this->email->subject($subject); // replace it with relevant subject

		$this->email->message($body);

		$this->email->send();

	}

	/** This function get one argument and return a encryted string.
	 * @param $data
	 * @return mixed
	 */
	protected function _encrypt($data)
	{
		$this->encryption->initialize(
			array(
				'cipher' => 'aes-256',
				'mode' => 'ctr',
				'key' => 'BN&980cgZ(Q&XKA5BahTtPOHp4G8r_7T'
			)
		);

		$encrypt = $this->encryption->encrypt($data);

		return $encrypt;
	}

	/**
	 * This function get one argument as input and return decrypt string
	 * @param $data
	 * @return mixed
	 */
	protected function _decrypt($data)
	{
		$this->encryption->initialize(
			array(
				'cipher' => 'aes-256',
				'mode' => 'ctr',
				'key' => 'BN&980cgZ(Q&XKA5BahTtPOHp4G8r_7T'
			)
		);

		$plaintext = $this->encryption->decrypt($data);

		return $plaintext;
	}

	public function curl_post_request($data)
	{
		$url = 'https://api.getresponse.com/v3/contacts';

		$get_response['name'] = $data['first_name'];
		$get_response['email'] = $data['email'];
		$get_response['dayOfCycle'] = '0';
		$get_response['campaign']['campaignId'] = GET_RESPONSE_CAMPAIGN_ID;

		$post = json_encode($get_response);

		$ch = curl_init();
		curl_setopt_array($ch, array(
			CURLOPT_URL => $url,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_POST => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_POSTFIELDS => $post,
			CURLOPT_HTTPHEADER => array(
				'Content-Type: application/json',
				'X-Auth-Token: api-key de9227f28c5208001f5c2a9a34e7c984'
			)
		));
		$result = curl_exec($ch);
		curl_close($ch);
	}
}

