<?php
/**
 * Created by PhpStorm.
 * User: Vega 6
 * Date: 28-Apr-20
 * Time: 02:43 PM
 */

class ImpactController extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();

        $this->load->model('StoreModel');
        $this->load->model('Membershipmodel');
        $this->load->model('MultipleStoreModel');
    }

    public function index()
    {
        $user_id = $this->session->userdata('user_id');

        if($this->input->post()){
            $link = trim($this->input->post('link'));

            if($this->Membershipmodel->exists('impact',array('user_id'=>$user_id))){
                $this->session->set_flashdata('error','User an create only 1 tracking link');
                redirect('impact');
            }

            if(!empty($link)){

                $data = array(
                  'user_id' => $user_id,
                  'link' => $link,
                  'modified' => date("Y-m-d h:i:s")
                );

                $this->Membershipmodel->insertData('impact',$data);

                $this->session->set_flashdata('success','Tracking Link Added Success');
                redirect('impact');
            }else{
                $this->session->set_flashdata('error','Input Value is empty');
                redirect('impact');
            }

        }
        else {

            $data['impact_records'] = $this->Membershipmodel->getData('impact',array('user_id'=>$user_id));

            $this->load->view('impact/index',$data);
        }
    }


    /**
     * Function: delete
     *
     * This function will delete requested affiliate
     *
     * @param : null
     *
     * @return : null
     */
    public function delete(){

        if($this->Membershipmodel->delete('impact',array('id'=>$this->input->get('id'))))
        {
            $this->session->set_flashdata('success','Impact Tracking Link deleted Successfully');
            redirect('impact');
        }
    }

}