<?php
/**
 * Created by PhpStorm.
 * User: Vega 6
 * Date: 30-Mar-20
 * Time: 01:01 PM
 * @property  MultipleStoreModel
 * @property  StoreModel
 */

class EnvatoController extends CI_Controller
{


    public function __construct()
    {
        parent::__construct();

        $this->load->model('StoreModel');
        $this->load->model('Membershipmodel');
        $this->load->model('MultipleStoreModel');

        $this->load->library('Envato');

    }

    /**
     * Function: login
     *
     * This Function Will Redirect on Envato Login page
     *
     * @param : null
     *
     * @return : null
    */
    public function index()
    {
        if(!$this->is_logged_in()){
            redirect('login');
        }

        $user_id = $this->session->userdata('user_id');

        $data['envato_records'] = $this->Membershipmodel->getData('envato',array('user_id'=>$user_id));

        $data['success_envato'] = 1;
        $this->load->view('envato/index',$data);
    }


    /**
     * Function: loginEnvato
     *
     * This function will redirect user on envato login page
     *
     * @param : null
     *
     * @return : null
    */
    public function loginEnvato()
    {

        $url = 'https://api.envato.com/authorization?response_type=code&client_id='.CODE_CLIENT.'&redirect_uri='.site_url('envato-callback');

        redirect($url);

    }


    /**
     * Function: callback
     *
     * This Function will get user info after user logged in successfully
     *
     * @param : null
     *
     * @return : null
    */
    public function callback()
    {
        $code = $this->input->get('code');
        $user_id = $this->session->userdata('user_id');

        if(!empty($code)){

            $access_token_data = $this->envato->get_user_access('https://api.envato.com/token',$code);

            // Insert Response in Database
            if(!empty($access_token_data)){


                // Get Username from envato account
                $user_details = $this->envato->get_user_details('https://api.envato.com/v1/market/private/user/username.json', $access_token_data->access_token);

                if(empty($user_details->error)) {
                    $data = array(
                        'user_id' => $user_id,
                        'username' => $user_details->username,
                        'refresh_token' => $access_token_data->refresh_token,
                        'access_token' => $access_token_data->access_token,
                        'token_type' => $access_token_data->token_type,
                        'status' => 1
                    );
                }
                else{
                    $this->session->set_flashdata('error','Seems you have not yet enabled your marketplace at Envato. Please go and enable your Envato marketplace');
                    redirect('envato');
                }

                if($this->Membershipmodel->exists('envato',array('user_id'=>$user_id))){

                    $data['modified'] =  date("Y-m-d h:i:sa");

                    $this->Membershipmodel->updateData('envato',$user_id,$data);
                    $this->session->set_flashdata('success','This Account is Already Connected');
                }
                else{
                    $this->session->set_flashdata('success','Envato account connected successfully.');
                    $this->Membershipmodel->insertData('envato',$data);
                }

                redirect('envato-success');

            }
        }
    }


    public function envatoSuccess()
    {
        $this->session->set_flashdata('success','Envato account connected successfully.');
        $this->load->view('envato/envato_success.php');
    }


    /**
     * Function: delete
     *
     * This function will delete requested affiliate
     *
     * @param : null
     *
     * @return : null
     */
    public function delete()
    {

        if(!$this->is_logged_in()){
            redirect('login');
        }

        if($this->Membershipmodel->delete('envato',array('id'=>$this->input->get('id'))))
        {
            $this->session->set_flashdata('success','Envato account deleted Successfully');
            redirect('envato');
        }
    }


    /**
     * Function : is_logged_in
     *
     * This function checks type of user logged in
     *
     * @param : null
     *
     * @return : boolen
     */
    public function is_logged_in(){

        if(isset($this->session->userdata['email']))
        {
            $userid = $this->session->userdata['user_id'];

            $row = $this->Membershipmodel->fetchtabledataone('users','id',$userid);

            if($row[0]->status == 1)
                return true;
            else
                return false;
        }
        else
        {

            return false;
        }
    }



}